/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.presentation.action;

import java.util.List;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edapt.history.History;
import org.eclipse.emf.edapt.history.HistoryPackage;
import org.eclipse.emf.edapt.history.reconstruction.EcoreForwardReconstructor;
import org.eclipse.emf.edapt.history.reconstruction.HistoryValidator;
import org.eclipse.emf.edapt.history.reconstruction.IReconstructor;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class ExtendedValidateAction
extends ValidateAction {
    public ExtendedValidateAction() {
        EValidator.Registry.INSTANCE.put((Object)HistoryPackage.eINSTANCE, (Object)new EValidator.Descriptor(){

            public EValidator getEValidator() {
                return org.eclipse.emf.edapt.history.util.HistoryValidator.INSTANCE;
            }
        });
    }

    public void run() {
        EObject element = (EObject)this.selectedObjects.get(0);
        History history = (History)element.eResource().getContents().get(0);
        EcoreForwardReconstructor reconstructor = new EcoreForwardReconstructor(history.eResource().getURI());
        reconstructor.addReconstructor((IReconstructor)new HistoryValidator());
        reconstructor.reconstruct(history.getLastRelease(), false);
        super.run();
    }

    protected void handleDiagnostic(Diagnostic diagnostic) {
        int severity = diagnostic.getSeverity();
        String title = null;
        String message = null;
        if (severity == 4 || severity == 2) {
            title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_title");
            message = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationProblems_message");
        } else {
            title = EMFEditUIPlugin.INSTANCE.getString("_UI_ValidationResults_title");
            message = EMFEditUIPlugin.INSTANCE.getString(severity == 0 ? "_UI_ValidationOK_message" : "_UI_ValidationResults_message");
        }
        int result = 0;
        if (diagnostic.getSeverity() == 0) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
            result = 1;
        } else {
            result = DiagnosticDialog.open((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message, (Diagnostic)diagnostic);
        }
        if (this.eclipseResourcesUtil != null) {
            Resource resource = this.getResource(diagnostic);
            if (resource != null) {
                this.eclipseResourcesUtil.deleteMarkers((Object)resource);
            }
            if (result == 0) {
                List data;
                if (!diagnostic.getChildren().isEmpty() && !(data = ((Diagnostic)diagnostic.getChildren().get(0)).getData()).isEmpty() && data.get(0) instanceof EObject) {
                    Viewer viewer;
                    IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                    if (part instanceof ISetSelectionTarget) {
                        ((ISetSelectionTarget)part).selectReveal((ISelection)new StructuredSelection(data.get(0)));
                    } else if (part instanceof IViewerProvider && (viewer = ((IViewerProvider)part).getViewer()) != null) {
                        viewer.setSelection((ISelection)new StructuredSelection(data.get(0)), true);
                    }
                }
                for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                    Resource childResource = this.getResource(diagnostic);
                    if (childResource == null) continue;
                    this.eclipseResourcesUtil.createMarkers(childResource, childDiagnostic);
                }
            }
        }
    }

    private Resource getResource(Diagnostic diagnostic) {
        List data = diagnostic.getData();
        if (data.size() > 0 && data.get(0) instanceof EObject) {
            EObject element = (EObject)data.get(0);
            return element.eResource();
        }
        return null;
    }
}

