/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.recorder.ui;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edapt.common.ui.EcoreUIUtils;
import org.eclipse.emf.edapt.common.ui.PartAdapter;
import org.eclipse.emf.edapt.history.HistoryPackage;
import org.eclipse.emf.edapt.history.recorder.EditingDomainListener;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreEditorDetector
extends PartAdapter
implements IPropertyListener {
    private final Map<EcoreEditor, EditingDomainListener> mapping;
    private static EcoreEditorDetector instance = new EcoreEditorDetector();

    public static EcoreEditorDetector getInstance() {
        return instance;
    }

    private EcoreEditorDetector() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        activePage.addPartListener((IPartListener)this);
        this.mapping = new HashMap<EcoreEditor, EditingDomainListener>();
        IEditorReference[] editorReferences = activePage.getEditorReferences();
        int i = 0;
        int n = editorReferences.length;
        while (i < n) {
            IEditorReference editorReference = editorReferences[i];
            IEditorPart editor = editorReference.getEditor(false);
            if (editor instanceof EcoreEditor) {
                EcoreEditor ecoreEditor = (EcoreEditor)editor;
                this.addEditor(ecoreEditor);
            }
            ++i;
        }
    }

    public void addEditor(EcoreEditor editor) {
        EditingDomainListener listener = this.getListener(editor);
        if (listener == null) {
            listener = new EditingDomainListener(editor.getEditingDomain());
        }
        if (listener.loadHistory()) {
            this.validateListener(editor, listener);
        }
    }

    public void addEditorAndCreateHistory(EcoreEditor editor, List<Resource> metamodelResources, URI historyURI) {
        EditingDomainListener listener = this.getListener(editor);
        if (listener == null) {
            listener = new EditingDomainListener(editor.getEditingDomain());
            listener.createHistory(metamodelResources, historyURI);
            this.validateListener(editor, listener);
        }
    }

    private void validateListener(EcoreEditor editor, EditingDomainListener listener) {
        this.mapping.put(editor, listener);
        editor.addPropertyListener((IPropertyListener)this);
        this.hackAdapterFactory(editor);
        if (listener.isListening()) {
            listener.endListening();
        }
        listener.beginListening();
    }

    private void hackAdapterFactory(EcoreEditor editor) {
        ComposedAdapterFactory composedAdapterFactory = (ComposedAdapterFactory)editor.getAdapterFactory();
        AdapterFactory adapterFactory = composedAdapterFactory.getFactoryForType((Object)HistoryPackage.eINSTANCE.getHistory());
        if (adapterFactory instanceof ReflectiveItemProviderAdapterFactory) {
            composedAdapterFactory.removeAdapterFactory(adapterFactory);
            composedAdapterFactory.addAdapterFactory((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        }
    }

    private void removeEditor(EcoreEditor editor) {
        EditingDomainListener listener = this.mapping.get(editor);
        if (listener != null) {
            listener.endListening();
            editor.removePropertyListener((IPropertyListener)this);
        }
        this.mapping.remove(editor);
    }

    public void partOpened(IWorkbenchPart part) {
        EcoreEditor editor;
        if (part instanceof EcoreEditor && EcoreUIUtils.isMetamodelEditor((EcoreEditor)(editor = (EcoreEditor)part))) {
            this.addEditor(editor);
        }
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof EcoreEditor) {
            EcoreEditor editor = (EcoreEditor)part;
            this.removeEditor(editor);
        }
    }

    public EditingDomainListener getListener(EcoreEditor editor) {
        return this.mapping.get(editor);
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 257) {
            EcoreEditor editor = (EcoreEditor)source;
            EditingDomainListener listener = this.mapping.get(editor);
            listener.resetRecorder();
        }
    }
}

