/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.reconstruction.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.edapt.common.ui.ModelSash;
import org.eclipse.emf.edapt.common.ui.SelectionUtils;
import org.eclipse.emf.edapt.common.ui.StructureTreeViewer;
import org.eclipse.emf.edapt.common.ui.SyncedMetamodelEditorViewBase;
import org.eclipse.emf.edapt.declaration.Parameter;
import org.eclipse.emf.edapt.history.Change;
import org.eclipse.emf.edapt.history.ContentChange;
import org.eclipse.emf.edapt.history.Delete;
import org.eclipse.emf.edapt.history.NonDelete;
import org.eclipse.emf.edapt.history.OperationChange;
import org.eclipse.emf.edapt.history.OperationInstance;
import org.eclipse.emf.edapt.history.PrimitiveChange;
import org.eclipse.emf.edapt.history.Release;
import org.eclipse.emf.edapt.history.ValueChange;
import org.eclipse.emf.edapt.history.reconstruction.CompositeReconstructorBase;
import org.eclipse.emf.edapt.history.reconstruction.EcoreBackwardReconstructor;
import org.eclipse.emf.edapt.history.reconstruction.EcoreForwardReconstructor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;

public class ReconstructionView
extends SyncedMetamodelEditorViewBase {
    public static final String ID = ReconstructionView.class.getName();
    private ModelSash sash;
    private CompositeReconstructorBase reconstructor;

    protected void createContents(Composite parent) {
        this.sash = new ModelSash(parent, 0);
        this.sash.getStructureViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object element = SelectionUtils.getSelectedElement((ISelection)event.getSelection());
                if (element != null) {
                    Object source = ReconstructionView.this.reconstructor.getMapping().resolveSource(element);
                    ReconstructionView.this.getEditor().setSelectionToViewer(Collections.singletonList(source));
                }
            }
        });
    }

    public void selectionChanged(IStructuredSelection structuredSelection) {
        if (structuredSelection.size() == 1) {
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof Change) {
                this.setChange((Change)firstElement);
            } else if (firstElement instanceof Release) {
                this.setRelease((Release)firstElement);
            }
        }
    }

    public void setRelease(Release release) {
        this.reconstructor = this.createReconstructor(release);
        this.reconstructor.reconstruct(release, false);
        StructureTreeViewer structureViewer = this.sash.getStructureViewer();
        structureViewer.setInput((Object)this.reconstructor.getResourceSet());
        structureViewer.expandToLevel(3);
    }

    public void setChange(Change change) {
        this.reconstructor = this.createReconstructor(change.getRelease());
        this.reconstructor.reconstruct(change, false);
        StructureTreeViewer structureViewer = this.sash.getStructureViewer();
        structureViewer.setInput((Object)this.reconstructor.getResourceSet());
        structureViewer.expandToLevel(3);
        this.showAffectedElements(change);
    }

    private void showAffectedElements(Change change) {
        StructureTreeViewer structureViewer = this.sash.getStructureViewer();
        if (change instanceof PrimitiveChange) {
            if (change instanceof ContentChange) {
                if (change instanceof Delete) {
                    Delete delete = (Delete)change;
                    EObject target = (EObject)this.reconstructor.getMapping().resolveTarget((Object)delete.getTarget());
                    structureViewer.setSelection((ISelection)new StructuredSelection((Object)target), true);
                } else if (change instanceof NonDelete) {
                    NonDelete nonDelete = (NonDelete)change;
                    EObject element = (EObject)this.reconstructor.getMapping().resolveTarget((Object)nonDelete.getElement());
                    structureViewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
                }
            } else if (change instanceof ValueChange) {
                ValueChange valueChange = (ValueChange)change;
                EObject element = (EObject)this.reconstructor.getMapping().resolveTarget((Object)valueChange.getElement());
                structureViewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
            }
        } else if (change instanceof OperationChange) {
            OperationChange operationChange = (OperationChange)change;
            OperationInstance operationInstance = operationChange.getOperation();
            Parameter mainParameter = operationInstance.getOperation().getMainParameter();
            Object value = operationInstance.getParameterValue(mainParameter.getName());
            Object resolved = this.reconstructor.getMapping().resolveTarget(value);
            if (mainParameter.isMany()) {
                structureViewer.setSelection((ISelection)new StructuredSelection((List)resolved), true);
            } else {
                structureViewer.setSelection((ISelection)new StructuredSelection(resolved), true);
            }
        }
    }

    private CompositeReconstructorBase createReconstructor(Release release) {
        URI uri = URI.createURI((String)"recons");
        EList releases = release.getHistory().getReleases();
        int index = releases.indexOf(release);
        if (index >= releases.size() - 2) {
            return new EcoreBackwardReconstructor(uri);
        }
        return new EcoreForwardReconstructor(uri);
    }

    protected void editorChanged(EcoreEditor oldEditor) {
        if (this.getEditor() == null) {
            this.sash.getStructureViewer().setInput(null);
        }
    }

    public void setFocus() {
        if (!this.sash.isDisposed()) {
            this.sash.setFocus();
        }
    }
}

