/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.lang.model.tck;

import jakarta.enterprise.lang.model.AnnotationTarget;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.FieldInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import jakarta.enterprise.lang.model.declarations.RecordComponentInfo;
import jakarta.enterprise.lang.model.types.Type;
import org.jboss.cdi.lang.model.tck.LangModelUtils;
import org.jboss.cdi.lang.model.tck.SimpleAnnotation;
import org.jboss.cdi.lang.model.tck.SimpleClass;
import org.jboss.cdi.lang.model.tck.SimpleEnum;
import org.jboss.cdi.lang.model.tck.SimpleInterface;
import org.jboss.cdi.lang.model.tck.SimpleRecord;

public class Equality {
    SimpleClass simpleClass;
    SimpleInterface simpleInterface;
    SimpleEnum simpleEnum;
    SimpleAnnotation simpleAnnotation;
    SimpleRecord simpleRecord;

    public static void verify(ClassInfo clazz) {
        Equality.verifyDeclarations(clazz);
        Equality.verifyTypes(clazz);
    }

    private static void verifyDeclarations(ClassInfo clazz) {
        ClassInfo simpleClass = LangModelUtils.classOfField(clazz, "simpleClass");
        ClassInfo simpleInterface = LangModelUtils.classOfField(clazz, "simpleInterface");
        ClassInfo simpleEnum = LangModelUtils.classOfField(clazz, "simpleEnum");
        ClassInfo simpleAnnotation = LangModelUtils.classOfField(clazz, "simpleAnnotation");
        ClassInfo simpleRecord = LangModelUtils.classOfField(clazz, "simpleRecord");
        Equality.assertEquality((AnnotationTarget)simpleClass, (AnnotationTarget)LangModelUtils.classOfField(clazz, "simpleClass"));
        Equality.assertEquality((AnnotationTarget)simpleInterface, (AnnotationTarget)LangModelUtils.classOfField(clazz, "simpleInterface"));
        Equality.assertEquality((AnnotationTarget)simpleEnum, (AnnotationTarget)LangModelUtils.classOfField(clazz, "simpleEnum"));
        Equality.assertEquality((AnnotationTarget)simpleAnnotation, (AnnotationTarget)LangModelUtils.classOfField(clazz, "simpleAnnotation"));
        Equality.assertEquality((AnnotationTarget)simpleRecord, (AnnotationTarget)LangModelUtils.classOfField(clazz, "simpleRecord"));
        Equality.assertInequality((AnnotationTarget)simpleClass, (AnnotationTarget)simpleInterface);
        Equality.assertInequality((AnnotationTarget)simpleClass, (AnnotationTarget)simpleEnum);
        Equality.assertInequality((AnnotationTarget)simpleClass, (AnnotationTarget)simpleAnnotation);
        Equality.assertInequality((AnnotationTarget)simpleClass, (AnnotationTarget)simpleRecord);
        Equality.assertInequality((AnnotationTarget)simpleInterface, (AnnotationTarget)simpleClass);
        Equality.assertInequality((AnnotationTarget)simpleInterface, (AnnotationTarget)simpleEnum);
        Equality.assertInequality((AnnotationTarget)simpleInterface, (AnnotationTarget)simpleAnnotation);
        Equality.assertInequality((AnnotationTarget)simpleInterface, (AnnotationTarget)simpleRecord);
        Equality.assertInequality((AnnotationTarget)simpleEnum, (AnnotationTarget)simpleClass);
        Equality.assertInequality((AnnotationTarget)simpleEnum, (AnnotationTarget)simpleInterface);
        Equality.assertInequality((AnnotationTarget)simpleEnum, (AnnotationTarget)simpleAnnotation);
        Equality.assertInequality((AnnotationTarget)simpleEnum, (AnnotationTarget)simpleRecord);
        Equality.assertInequality((AnnotationTarget)simpleAnnotation, (AnnotationTarget)simpleClass);
        Equality.assertInequality((AnnotationTarget)simpleAnnotation, (AnnotationTarget)simpleInterface);
        Equality.assertInequality((AnnotationTarget)simpleAnnotation, (AnnotationTarget)simpleEnum);
        Equality.assertInequality((AnnotationTarget)simpleAnnotation, (AnnotationTarget)simpleRecord);
        Equality.assertInequality((AnnotationTarget)simpleRecord, (AnnotationTarget)simpleClass);
        Equality.assertInequality((AnnotationTarget)simpleRecord, (AnnotationTarget)simpleInterface);
        Equality.assertInequality((AnnotationTarget)simpleRecord, (AnnotationTarget)simpleEnum);
        Equality.assertInequality((AnnotationTarget)simpleRecord, (AnnotationTarget)simpleAnnotation);
        MethodInfo simpleMethod = LangModelUtils.singleDeclaredMethod(simpleClass, "simpleMethod");
        Equality.assertEquality((AnnotationTarget)simpleMethod, (AnnotationTarget)LangModelUtils.singleDeclaredMethod(simpleClass, "simpleMethod"));
        Equality.assertInequality((AnnotationTarget)simpleMethod, (AnnotationTarget)LangModelUtils.singleDeclaredMethod(simpleClass, "anotherMethod"));
        Equality.assertInequality((AnnotationTarget)simpleMethod, (AnnotationTarget)LangModelUtils.singleDeclaredMethod(simpleInterface, "simpleMethod"));
        FieldInfo simpleStaticField = LangModelUtils.singleDeclaredField(simpleClass, "simpleStaticField");
        FieldInfo simpleField = LangModelUtils.singleDeclaredField(simpleClass, "simpleField");
        Equality.assertEquality((AnnotationTarget)simpleStaticField, (AnnotationTarget)LangModelUtils.singleDeclaredField(simpleClass, "simpleStaticField"));
        Equality.assertEquality((AnnotationTarget)simpleField, (AnnotationTarget)LangModelUtils.singleDeclaredField(simpleClass, "simpleField"));
        Equality.assertInequality((AnnotationTarget)simpleStaticField, (AnnotationTarget)simpleField);
        Equality.assertInequality((AnnotationTarget)simpleField, (AnnotationTarget)simpleStaticField);
        Equality.assertInequality((AnnotationTarget)simpleStaticField, (AnnotationTarget)LangModelUtils.singleDeclaredField(simpleInterface, "simpleField"));
        Equality.assertInequality((AnnotationTarget)simpleField, (AnnotationTarget)LangModelUtils.singleDeclaredField(simpleInterface, "simpleField"));
        RecordComponentInfo simpleRecordComponent = LangModelUtils.singleRecordComponent(simpleRecord, "simpleRecordComponent");
        Equality.assertEquality((AnnotationTarget)simpleRecordComponent, (AnnotationTarget)LangModelUtils.singleRecordComponent(simpleRecord, "simpleRecordComponent"));
        Equality.assertInequality((AnnotationTarget)simpleRecordComponent, (AnnotationTarget)LangModelUtils.singleRecordComponent(simpleRecord, "anotherRecordComponent"));
    }

    private static void verifyTypes(ClassInfo clazz) {
        Type simpleClass = LangModelUtils.singleField(clazz, "simpleClass").type();
        Type simpleInterface = LangModelUtils.singleField(clazz, "simpleInterface").type();
        Type simpleEnum = LangModelUtils.singleField(clazz, "simpleEnum").type();
        Type simpleAnnotation = LangModelUtils.singleField(clazz, "simpleAnnotation").type();
        Type simpleRecord = LangModelUtils.singleField(clazz, "simpleRecord").type();
        Equality.assertEquality((AnnotationTarget)simpleClass, (AnnotationTarget)LangModelUtils.singleField(clazz, "simpleClass").type());
        Equality.assertEquality((AnnotationTarget)simpleInterface, (AnnotationTarget)LangModelUtils.singleField(clazz, "simpleInterface").type());
        Equality.assertEquality((AnnotationTarget)simpleEnum, (AnnotationTarget)LangModelUtils.singleField(clazz, "simpleEnum").type());
        Equality.assertEquality((AnnotationTarget)simpleAnnotation, (AnnotationTarget)LangModelUtils.singleField(clazz, "simpleAnnotation").type());
        Equality.assertEquality((AnnotationTarget)simpleRecord, (AnnotationTarget)LangModelUtils.singleField(clazz, "simpleRecord").type());
        Equality.assertInequality((AnnotationTarget)simpleClass, (AnnotationTarget)simpleInterface);
        Equality.assertInequality((AnnotationTarget)simpleClass, (AnnotationTarget)simpleEnum);
        Equality.assertInequality((AnnotationTarget)simpleClass, (AnnotationTarget)simpleAnnotation);
        Equality.assertInequality((AnnotationTarget)simpleClass, (AnnotationTarget)simpleRecord);
        Equality.assertInequality((AnnotationTarget)simpleInterface, (AnnotationTarget)simpleClass);
        Equality.assertInequality((AnnotationTarget)simpleInterface, (AnnotationTarget)simpleEnum);
        Equality.assertInequality((AnnotationTarget)simpleInterface, (AnnotationTarget)simpleAnnotation);
        Equality.assertInequality((AnnotationTarget)simpleInterface, (AnnotationTarget)simpleRecord);
        Equality.assertInequality((AnnotationTarget)simpleEnum, (AnnotationTarget)simpleClass);
        Equality.assertInequality((AnnotationTarget)simpleEnum, (AnnotationTarget)simpleInterface);
        Equality.assertInequality((AnnotationTarget)simpleEnum, (AnnotationTarget)simpleAnnotation);
        Equality.assertInequality((AnnotationTarget)simpleEnum, (AnnotationTarget)simpleRecord);
        Equality.assertInequality((AnnotationTarget)simpleAnnotation, (AnnotationTarget)simpleClass);
        Equality.assertInequality((AnnotationTarget)simpleAnnotation, (AnnotationTarget)simpleInterface);
        Equality.assertInequality((AnnotationTarget)simpleAnnotation, (AnnotationTarget)simpleEnum);
        Equality.assertInequality((AnnotationTarget)simpleAnnotation, (AnnotationTarget)simpleRecord);
        Equality.assertInequality((AnnotationTarget)simpleRecord, (AnnotationTarget)simpleClass);
        Equality.assertInequality((AnnotationTarget)simpleRecord, (AnnotationTarget)simpleInterface);
        Equality.assertInequality((AnnotationTarget)simpleRecord, (AnnotationTarget)simpleEnum);
        Equality.assertInequality((AnnotationTarget)simpleRecord, (AnnotationTarget)simpleAnnotation);
        Type simpleMethod = LangModelUtils.singleDeclaredMethod(simpleClass.asClass().declaration(), "simpleMethod").returnType();
        Type anotherMethod = LangModelUtils.singleDeclaredMethod(simpleClass.asClass().declaration(), "anotherMethod").returnType();
        Equality.assertEquality((AnnotationTarget)simpleMethod, (AnnotationTarget)anotherMethod);
        Equality.assertEquality((AnnotationTarget)anotherMethod, (AnnotationTarget)simpleMethod);
        Type simpleStaticField = LangModelUtils.singleDeclaredField(simpleClass.asClass().declaration(), "simpleStaticField").type();
        Type simpleField = LangModelUtils.singleDeclaredField(simpleClass.asClass().declaration(), "simpleField").type();
        Equality.assertEquality((AnnotationTarget)simpleStaticField, (AnnotationTarget)simpleField);
        Equality.assertEquality((AnnotationTarget)simpleField, (AnnotationTarget)simpleStaticField);
        Equality.assertInequality((AnnotationTarget)simpleEnum, (AnnotationTarget)simpleField);
        Equality.assertInequality((AnnotationTarget)simpleField, (AnnotationTarget)simpleEnum);
    }

    private static void assertEquality(AnnotationTarget a, AnnotationTarget b) {
        assert (a.equals(b));
        assert (a.hashCode() == b.hashCode());
    }

    private static void assertInequality(AnnotationTarget a, AnnotationTarget b) {
        assert (!a.equals(b));
    }
}

