/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.beanContainer;

import jakarta.enterprise.context.spi.AlterableContext;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.jboss.cdi.tck.tests.beanContainer.CustomScoped;

public class CustomContextImpl2
implements AlterableContext {
    private final ThreadLocal<Map<Contextual<?>, ContextualInstance<?>>> current = ThreadLocal.withInitial(HashMap::new);

    public Class<? extends Annotation> getScope() {
        return CustomScoped.class;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        Map<Contextual<?>, ContextualInstance<?>> store = this.current.get();
        ContextualInstance<Object> instance = store.get(contextual);
        if (instance == null && creationalContext != null) {
            instance = new ContextualInstance<Object>(contextual.create(creationalContext), creationalContext, contextual);
            store.put(contextual, instance);
        }
        return instance != null ? (T)instance.get() : null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public boolean isActive() {
        return true;
    }

    public void destroy(Contextual<?> contextual) {
        Map<Contextual<?>, ContextualInstance<?>> store = this.current.get();
        ContextualInstance<?> contextualInstance = store.remove(contextual);
        if (contextualInstance != null) {
            contextualInstance.destroy();
        }
    }

    static final class ContextualInstance<T> {
        private final T value;
        private final CreationalContext<T> creationalContext;
        private final Contextual<T> contextual;

        ContextualInstance(T instance, CreationalContext<T> creationalContext, Contextual<T> contextual) {
            this.value = instance;
            this.creationalContext = creationalContext;
            this.contextual = contextual;
        }

        T get() {
            return this.value;
        }

        void destroy() {
            this.contextual.destroy(this.value, this.creationalContext);
        }
    }
}

