/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedThreadFactory.resourcedef;

import ee.jakarta.tck.concurrent.common.context.IntContext;
import ee.jakarta.tck.concurrent.common.context.StringContext;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import jakarta.enterprise.concurrent.ManagedThreadFactoryDefinition;
import jakarta.servlet.annotation.WebServlet;
import jakarta.transaction.UserTransaction;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.testng.Assert;

@ManagedThreadFactoryDefinition.List(value={@ManagedThreadFactoryDefinition(name="java:app/concurrent/ThreadFactoryA", context="java:app/concurrent/ContextA", priority=4), @ManagedThreadFactoryDefinition(name="java:comp/concurrent/ThreadFactoryB")})
@WebServlet(value={"/ManagedThreadFactoryDefinitionServlet"})
public class ManagedThreadFactoryDefinitionServlet
extends TestServlet {
    private static final long serialVersionUID = 1L;
    private static final long MAX_WAIT_SECONDS = TimeUnit.MINUTES.toSeconds(2L);
    @Resource
    UserTransaction tx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManagedThreadFactoryDefinitionAllAttributes() throws Throwable {
        try {
            IntContext.set(161);
            StringContext.set("testManagedThreadFactoryDefinitionAllAttributes-1");
            ManagedThreadFactory threadFactory = (ManagedThreadFactory)InitialContext.doLookup("java:app/concurrent/ThreadFactoryA");
            IntContext.set(162);
            StringContext.set("testManagedThreadFactoryDefinitionAllAttributes-2");
            Thread thread1 = threadFactory.newThread(() -> {});
            Assert.assertEquals((int)thread1.getPriority(), (int)4, (String)"New threads must be created with the priority that is specified on ManagedThreadFactoryDefinition");
            LinkedBlockingQueue results = new LinkedBlockingQueue();
            threadFactory.newThread(() -> {
                results.add(Thread.currentThread().getPriority());
                results.add(StringContext.get());
                results.add(IntContext.get());
                try {
                    results.add(InitialContext.doLookup("java:app/concurrent/ContextA"));
                }
                catch (Throwable x) {
                    results.add(x);
                }
            }).start();
            Assert.assertEquals(results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)4, (String)"ManagedThreadFactory must start threads with the configured priority.");
            Assert.assertEquals(results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)"", (String)"Third-party context type StringContext must be cleared from thread per ManagedThreadFactoryDefinition and ContextServiceDefinition configuration.");
            Assert.assertEquals(results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (Object)161, (String)"Third-party context type IntContext must be propagated to thread per ManagedThreadFactoryDefinition and ContextServiceDefinition configuration based on the thread context at the time the ManagedThreadFactory was looked up.");
            Object lookupResult = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            if (lookupResult instanceof Throwable) {
                throw ((Throwable)((Object)new AssertionError())).initCause((Throwable)lookupResult);
            }
            Assert.assertTrue((boolean)(lookupResult instanceof ContextService), (String)"Application context must be propagated to thread per ManagedThreadFactoryDefinition and ContextServiceDefinition configuration.");
        }
        finally {
            IntContext.set(0);
            StringContext.set("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testManagedThreadFactoryDefinitionDefaults() throws Throwable {
        ManagedThreadFactory threadFactory = (ManagedThreadFactory)InitialContext.doLookup("java:comp/concurrent/ThreadFactoryB");
        CountDownLatch blocker = new CountDownLatch(1);
        CountDownLatch allThreadsRunning = new CountDownLatch(2);
        CompletableFuture lookupTaskResult = new CompletableFuture();
        CompletableFuture txTaskResult = new CompletableFuture();
        Runnable lookupTask = () -> {
            try {
                allThreadsRunning.countDown();
                blocker.await(MAX_WAIT_SECONDS * 5L, TimeUnit.SECONDS);
                lookupTaskResult.complete(InitialContext.doLookup("java:comp/concurrent/ContextC"));
            }
            catch (Throwable x) {
                txTaskResult.completeExceptionally(x);
            }
        };
        Runnable txTask = () -> {
            try {
                allThreadsRunning.countDown();
                UserTransaction tx = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
                int initialStatus = tx.getStatus();
                tx.begin();
                try {
                    blocker.await(MAX_WAIT_SECONDS * 5L, TimeUnit.SECONDS);
                }
                finally {
                    tx.rollback();
                }
                txTaskResult.complete(initialStatus);
            }
            catch (Throwable x) {
                txTaskResult.completeExceptionally(x);
            }
        };
        try {
            threadFactory.newThread(lookupTask).start();
            threadFactory.newThread(txTask).start();
            Assert.assertTrue((boolean)allThreadsRunning.await(MAX_WAIT_SECONDS, TimeUnit.SECONDS), (String)"ManagedThreadFactory threads must start running.");
            blocker.countDown();
            Object result = lookupTaskResult.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            if (result instanceof Throwable) {
                throw ((Throwable)((Object)new AssertionError())).initCause((Throwable)result);
            }
            Assert.assertTrue((boolean)(result instanceof ContextService), (String)"Application context must be propagated to first thread per java:comp/concurrent/ThreadFactoryB configuration.");
            result = txTaskResult.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            if (result instanceof Throwable) {
                throw ((Throwable)((Object)new AssertionError())).initCause((Throwable)result);
            }
            Assert.assertEquals(result, (Object)6, (String)"Transaction context must be cleared from async Callable task per java:comp/concurrent/ThreadFactoryB configuration.");
        }
        finally {
            IntContext.set(0);
            blocker.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testParallelStreamBackedByManagedThreadFactory() throws Throwable {
        ForkJoinPool fj = null;
        try {
            IntContext.set(1000);
            StringContext.set("testParallelStreamBackedByManagedThreadFactory-1");
            ManagedThreadFactory threadFactory = (ManagedThreadFactory)InitialContext.doLookup("java:app/concurrent/ThreadFactoryA");
            IntContext.set(2000);
            StringContext.set("testParallelStreamBackedByManagedThreadFactory-2");
            fj = new ForkJoinPool(4, (ForkJoinPool.ForkJoinWorkerThreadFactory)threadFactory, null, false);
            IntContext.set(3000);
            StringContext.set("testParallelStreamBackedByManagedThreadFactory-3");
            Future task = fj.submit(() -> Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9).parallelStream().map(num -> {
                Assert.assertEquals((String)StringContext.get(), (String)"", (String)"Third-party context type StringContext must be cleared on ForkJoin thread.");
                try {
                    Assert.assertNotNull(InitialContext.doLookup("java:app/concurrent/ContextA"), (String)"Application context must be propagated to ForkJoin thread");
                }
                catch (NamingException x) {
                    throw new CompletionException(x);
                }
                return num * Thread.currentThread().getPriority() + IntContext.get();
            }).reduce(Integer::sum));
            Optional result = (Optional)((ForkJoinTask)task).join();
            Assert.assertEquals(result.get(), (Object)9180, (String)"Third-party context type IntContext must propagated to ForkJoin threads (thousands digit should be 9) and thread priority (4) must be enforced on ForkJoin threads (hundreds/tens/ones digits must be 4x5x9=180) per configuration of the ManagedThreadFactoryDefinition and ContextServiceDefinition.");
        }
        finally {
            IntContext.set(0);
            StringContext.set(null);
            if (fj != null) {
                fj.shutdown();
            }
        }
    }
}

