/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.api.AbortedException;

import ee.jakarta.tck.concurrent.framework.ArquillianTests;
import ee.jakarta.tck.concurrent.framework.TestLogger;
import jakarta.enterprise.concurrent.AbortedException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class AbortedExceptionTests
extends ArquillianTests {
    private static final TestLogger log = TestLogger.get(AbortedExceptionTests.class);

    @Deployment(name="AbortedExceptionTests")
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackages(true, new Package[]{AbortedExceptionTests.getFrameworkPackage(), AbortedExceptionTests.class.getPackage()});
    }

    @Test
    public void AbortedExceptionNoArgTest() {
        boolean pass = false;
        try {
            throw new AbortedException();
        }
        catch (AbortedException ae) {
            log.info("AbortedException Caught as Expected");
            if (ae.getMessage() == null) {
                log.info("Received expected null message");
                pass = true;
            } else {
                log.warning("AbortedException should have had null message, actual message=" + ae.getMessage());
            }
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass);
    }

    @Test
    public void AbortedExceptionStringTest() {
        boolean pass = false;
        String expected = "thisisthedetailmessage";
        try {
            throw new AbortedException(expected);
        }
        catch (AbortedException ae) {
            log.info("AbortedException Caught as Expected");
            if (ae.getMessage().equals(expected)) {
                log.info("Received expected message");
                pass = true;
            } else {
                log.warning("Expected:" + expected + ", actual message=" + ae.getMessage());
            }
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass);
    }

    @Test
    public void AbortedExceptionThrowableTest() {
        Throwable cause;
        boolean pass1 = false;
        boolean pass2 = false;
        Throwable expected = new Throwable("thisisthethrowable");
        try {
            throw new AbortedException(expected);
        }
        catch (AbortedException ae) {
            log.info("AbortedException Caught as Expected");
            cause = ae.getCause();
            if (cause.equals(expected)) {
                log.info("Received expected cause");
                pass1 = true;
            } else {
                log.warning("Expected:" + expected + ", actual message=" + cause);
            }
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        expected = null;
        try {
            throw new AbortedException(expected);
        }
        catch (AbortedException ae) {
            log.info("AbortedException Caught as Expected");
            cause = ae.getCause();
            if (cause == null) {
                log.info("Received expected null cause");
                pass2 = true;
            } else {
                log.warning("Expected:null, actual message=" + cause);
            }
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass1);
        this.assertTrue(pass2);
    }

    @Test
    public void AbortedExceptionStringThrowableTest() {
        Throwable cause;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        String sExpected = "thisisthedetailmessage";
        Throwable tExpected = new Throwable("thisisthethrowable");
        try {
            throw new AbortedException(sExpected, tExpected);
        }
        catch (AbortedException ae) {
            log.info("AbortedException Caught as Expected");
            if (ae.getMessage().equals(sExpected)) {
                log.info("Received expected message");
                pass1 = true;
            } else {
                log.warning("Expected:" + sExpected + ", actual message=" + ae.getMessage());
            }
            cause = ae.getCause();
            if (cause.equals(tExpected)) {
                log.info("Received expected cause");
                pass2 = true;
            } else {
                log.warning("Expected:" + tExpected + ", actual message=" + cause);
            }
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        tExpected = null;
        try {
            throw new AbortedException(sExpected, tExpected);
        }
        catch (AbortedException ae) {
            log.info("AbortedException Caught as Expected");
            if (ae.getMessage().equals(sExpected)) {
                log.info("Received expected message");
                pass3 = true;
            } else {
                log.warning("Expected:" + sExpected + ", actual message=" + ae.getMessage());
            }
            cause = ae.getCause();
            if (cause == null) {
                log.info("Received expected null cause");
                pass4 = true;
            } else {
                log.warning("Expected:null, actual message=" + cause);
            }
        }
        catch (Exception e) {
            log.severe("Unexpected Exception Caught", e);
        }
        this.assertTrue(pass1);
        this.assertTrue(pass2);
        this.assertTrue(pass3);
        this.assertTrue(pass4);
    }
}

