/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedThreadFactory.context;

import ee.jakarta.tck.concurrent.common.tasks.RunnableTask;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.framework.junit.extensions.Wait;
import ee.jakarta.tck.concurrent.spec.ManagedThreadFactory.context.SecurityTestInterface;
import jakarta.ejb.EJB;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import javax.naming.InitialContext;
import org.junit.jupiter.api.Assertions;

@WebServlet(value={"/SecurityServlet"})
public class SecurityServlet
extends TestServlet {
    @EJB
    private SecurityTestInterface str;
    private static final String TEST_JNDI_EVN_ENTRY_VALUE = "hello";
    private static final String TEST_JNDI_EVN_ENTRY_JNDI_NAME = "java:comp/env/ManagedThreadFactory_test_string";
    private static final String TEST_CLASSLOADER_CLASS_NAME = SecurityServlet.class.getCanonicalName();

    public void jndiClassloaderPropagationTest(HttpServletRequest req, HttpServletResponse res) throws Exception {
        ManagedThreadFactory factory = (ManagedThreadFactory)InitialContext.doLookup("java:comp/DefaultManagedThreadFactory");
        CounterRunnableWithContext task = new CounterRunnableWithContext();
        Thread thread = factory.newThread((Runnable)task);
        thread.start();
        Wait.waitTillThreadFinish(thread);
        Assertions.assertEquals((int)task.getCount(), (int)1);
    }

    public void jndiClassloaderPropagationWithSecurityTest(HttpServletRequest req, HttpServletResponse res) throws Exception {
        req.login("javajoe", "javajoe");
        ManagedThreadFactory factory = (ManagedThreadFactory)InitialContext.doLookup("java:comp/DefaultManagedThreadFactory");
        CounterRunnableWithSecurityCheck task = new CounterRunnableWithSecurityCheck(this.str);
        Thread thread = factory.newThread((Runnable)task);
        thread.start();
        Wait.waitTillThreadFinish(thread);
        Assertions.assertEquals((int)task.getCount(), (int)1);
    }

    public static class CounterRunnableWithContext
    extends RunnableTask {
        private volatile int count = 0;

        @Override
        public int getCount() {
            return this.count;
        }

        public CounterRunnableWithContext() {
            super(SecurityServlet.TEST_JNDI_EVN_ENTRY_JNDI_NAME, SecurityServlet.TEST_JNDI_EVN_ENTRY_VALUE, TEST_CLASSLOADER_CLASS_NAME);
        }

        @Override
        public void run() {
            super.run();
            ++this.count;
        }
    }

    public static class CounterRunnableWithSecurityCheck
    implements Runnable {
        private volatile int count = 0;
        private SecurityTestInterface str;

        CounterRunnableWithSecurityCheck(SecurityTestInterface str) {
            this.str = str;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public void run() {
            try {
                Assertions.assertEquals((Object)this.str.managerMethod1(), (Object)"ok");
            }
            catch (Exception e) {
                return;
            }
            ++this.count;
        }
    }
}

