/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate;

import ee.jakarta.tck.concurrent.common.context.IntContext;
import ee.jakarta.tck.concurrent.common.context.StringContext;
import ee.jakarta.tck.concurrent.framework.TestServlet;
import ee.jakarta.tck.concurrent.spec.ContextService.contextPropagate.ContextServiceDefinitionInterface;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.naming.InitialContext;
import org.junit.jupiter.api.Assertions;

@WebServlet(value={"/ContextServiceDefinitionFromEJBServlet"})
public class ContextServiceDefinitionFromEJBServlet
extends TestServlet {
    private static final long serialVersionUID = 1L;
    private static final long MAX_WAIT_SECONDS = TimeUnit.MINUTES.toSeconds(2L);
    private ExecutorService unmanagedThreads;
    @Resource
    private UserTransaction tx;
    @EJB
    private ContextServiceDefinitionInterface contextServiceDefinitionBean;

    public void destroy() {
        this.unmanagedThreads.shutdownNow();
    }

    @Override
    public void before() throws ServletException {
        this.unmanagedThreads = Executors.newFixedThreadPool(10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContextServiceDefinitionFromEJBAllAttributes() throws Throwable {
        CompletionStage future;
        ContextService contextServiceA = (ContextService)InitialContext.doLookup("java:app/concurrent/EJBContextA");
        BiFunction<Object[], String, Object[]> fn = (results, jndiName) -> {
            try {
                results[0] = InitialContext.doLookup(jndiName);
            }
            catch (Throwable x) {
                results[0] = x;
            }
            results[1] = IntContext.get();
            results[2] = StringContext.get();
            try {
                results[3] = this.tx.getStatus();
            }
            catch (SystemException x) {
                throw new CompletionException(x);
            }
            return results;
        };
        try {
            StringContext.set("testContextServiceDefinitionFromEJBAllAttributes-1");
            IntContext.set(101);
            BiFunction contextualFunction = contextServiceA.contextualFunction(fn);
            future = CompletableFuture.completedFuture(new Object[4]).thenCombineAsync(CompletableFuture.completedFuture("java:app/concurrent/EJBContextA"), contextualFunction, (Executor)this.unmanagedThreads);
            StringContext.set("testContextServiceDefinitionFromEJBAllAttributes-2");
            IntContext.set(102);
            this.tx.begin();
            Object[] results2 = (Object[])contextualFunction.apply(new Object[4], "java:app/concurrent/EJBContextA");
            if (results2[0] instanceof Throwable) {
                throw ((Throwable)((Object)new AssertionError((Object)"Application context must be propagated to inline contextual BiFunction to perform lookup of java:app/concurrent/EJBContextA"))).initCause((Throwable)results2[0]);
            }
            Assertions.assertTrue((boolean)(results2[0] instanceof ContextService), (String)"Application context must be propagated to inline contextual BiFunction per java:app/concurrent/EJBContextA configuration.");
            Assertions.assertEquals((Object)results2[1], (Object)101, (String)"Third-party context type IntContext must be propagated to inline contextual BiFunction per java:app/concurrent/EJBContextA configuration.");
            Assertions.assertEquals((Object)results2[2], (Object)"", (String)"Third-party context type StringContext must be cleared from inline contextual BiFunction per java:app/concurrent/EJBContextA configuration.");
            Assertions.assertEquals((Object)results2[3], (Object)0, (String)"Transaction context must be left unchanged on inline contextual BiFunction per java:app/concurrent/EJBContextA configuration.");
            Assertions.assertNotNull(InitialContext.doLookup("java:app/concurrent/EJBContextA"), (String)"Previous Application context must be present after inline contextual BiFunction.");
            Assertions.assertEquals((int)IntContext.get(), (int)102, (String)"Third-party context type IntContext must be restored after inline contextual BiFunction.");
            Assertions.assertEquals((Object)StringContext.get(), (Object)"testContextServiceDefinitionFromEJBAllAttributes-2", (String)"Third-party context type StringContext must be restored after inline contextual BiFunction.");
            Assertions.assertEquals((int)this.tx.getStatus(), (int)0, (String)"Transaction context must remain on thread after inline contextual BiFunction because it is to be left unchanged per java:app/concurrent/EJBContextA configuration.");
        }
        finally {
            StringContext.set("");
            IntContext.set(0);
            if (this.tx.getStatus() != 6) {
                this.tx.rollback();
            }
        }
        Object[] results3 = (Object[])((CompletableFuture)future).get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
        if (results3[0] instanceof Throwable) {
            throw ((Throwable)((Object)new AssertionError((Object)"Application context must be propagated to async contextual BiFunction to perform lookup of java:app/concurrent/EJBContextA"))).initCause((Throwable)results3[0]);
        }
        Assertions.assertTrue((boolean)(results3[0] instanceof ContextService), (String)"Application context must be propagated to async contextual BiFunction per java:app/concurrent/EJBContextA configuration.");
        Assertions.assertEquals((Object)results3[1], (Object)101, (String)"Third-party context type IntContext must be propagated to async contextual BiFunction per java:app/concurrent/EJBContextA configuration.");
        Assertions.assertEquals((Object)results3[2], (Object)"", (String)"Third-party context type StringContext must be cleared from async contextual BiFunction per java:app/concurrent/EJBContextA configuration.");
        Assertions.assertEquals((Object)results3[3], (Object)6, (String)"Transaction context must be left unchanged on async contextual BiFunction per java:app/concurrent/EJBContextA configuration.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContextServiceDefinitionFromEJBDefaults() throws Throwable {
        ContextService contextService = this.contextServiceDefinitionBean.getContextC();
        LinkedBlockingQueue results = new LinkedBlockingQueue();
        try {
            IntContext.set(13);
            new Thread(contextService.contextualRunnable(() -> {
                results.add(IntContext.get());
                try {
                    results.add(this.contextServiceDefinitionBean.getContextC());
                }
                catch (Throwable x) {
                    results.add(x);
                }
            })).start();
        }
        finally {
            IntContext.set(0);
        }
        this.tx.begin();
        try {
            StringContext.set("testContextServiceDefinitionFromeEJBDefaults-1");
            Callable callable = contextService.contextualCallable(() -> {
                UserTransaction tran = (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
                tran.begin();
                tran.commit();
                return StringContext.get();
            });
            StringContext.set("testContextServiceDefinitionFromeEJBDefaults-2");
            Assertions.assertEquals(callable.call(), (Object)"testContextServiceDefinitionFromeEJBDefaults-1", (String)"Third-party context type StringContext must be propagated to contextual Callable.");
            Assertions.assertEquals((int)this.tx.getStatus(), (int)0, (String)"Transaction must be restored on thread after contextual proxy completes.");
        }
        finally {
            StringContext.set(null);
            this.tx.rollback();
        }
        Object result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
        Assertions.assertNotNull(result, (String)"Contextual runnable did not start on thread.");
        Assertions.assertEquals(result, (Object)13, (String)"Third-party context type IntContext must be propagated to contextual Runnable.");
        result = results.poll(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
        Assertions.assertNotNull(results, (String)"Contextual runnable did not complete on thread.");
        if (result instanceof Throwable) {
            throw ((Throwable)((Object)new AssertionError((Object)"Unable to look up java:comp name from contextual Runnable."))).initCause((Throwable)result);
        }
        Assertions.assertTrue((boolean)(result instanceof ContextService), (String)("Application context must be propagated to contextual Runnable, but instead lookup found: " + result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testContextualSupplier() throws Throwable {
        try {
            StringContext.set("testContextualSupplier-1");
            IntContext.set(61);
            ContextService contextServiceB = this.contextServiceDefinitionBean.getContextB();
            Supplier supplierB = contextServiceB.contextualSupplier(() -> new AbstractMap.SimpleEntry<Integer, String>(IntContext.get(), StringContext.get()));
            CompletableFuture futureB = CompletableFuture.supplyAsync(supplierB, this.unmanagedThreads);
            StringContext.set("testContextualSupplier-2");
            IntContext.set(62);
            Map.Entry results = (Map.Entry)futureB.get(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            Assertions.assertEquals((Integer)((Integer)results.getKey()), (Integer)0, (String)"Third-party context type IntContext must be cleared from async contextual Supplier per java:module/concurrent/ContextB configuration.");
            Assertions.assertEquals(results.getValue(), (Object)"testContextualSupplier-1", (String)"Third-party context type StringContext must be propagated to async contextual Supplier per java:module/concurrent/ContextB configuration.");
        }
        finally {
            StringContext.set(null);
            IntContext.set(0);
        }
    }
}

