/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.variablemapper;

import com.sun.ts.tests.el.common.elcontext.VarMapperELContext;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private Properties testProps = System.getProperties();

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void variableMapperTest() throws Exception {
        ValueExpression vexp5;
        ValueExpression vexp4;
        ValueExpression vexp3;
        ValueExpression vexp1;
        ValueExpression vexp2;
        StringBuffer buf = new StringBuffer();
        boolean pass = true;
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        VarMapperELContext context = new VarMapperELContext(this.testProps);
        VariableMapper varMapper = context.getVariableMapper();
        logger.log(System.Logger.Level.TRACE, "VariableMapper is " + varMapper.toString());
        if (varMapper.resolveVariable("foo") != null) {
            pass = false;
            buf.append("Expected call to resolveVariable() to unassigned variable to return null" + ELTestUtil.NL + "Instead call returned " + varMapper.resolveVariable("foo") + ELTestUtil.NL);
        }
        if ((vexp2 = varMapper.setVariable("foo", vexp1 = expFactory.createValueExpression((ELContext)context, "${bar}", String.class))) != null) {
            pass = false;
            buf.append("Expected call to setVariable() to return null for previously unassigned variable" + ELTestUtil.NL + "Instead return value was " + vexp2 + ELTestUtil.NL);
        }
        if (!(vexp3 = varMapper.resolveVariable("foo")).equals((Object)vexp1)) {
            pass = false;
            buf.append("Expected call to resolveVariable() to assigned variable to return " + vexp1.toString() + ELTestUtil.NL + "Instead call returned " + vexp3.toString() + ELTestUtil.NL);
        }
        if (!(vexp4 = varMapper.setVariable("foo", null)).equals((Object)vexp1)) {
            pass = false;
            buf.append("Expected call to resolveVariable() to assigned variable to return " + vexp1.toString() + ELTestUtil.NL + "Instead call returned " + vexp4.toString() + ELTestUtil.NL);
        }
        if ((vexp5 = varMapper.resolveVariable("foo")) != null) {
            pass = false;
            buf.append("Expected call to resolveVariable() to return null after unassignment" + ELTestUtil.NL + "Instead return value was " + vexp5 + ELTestUtil.NL);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
    }
}

