/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.auth;

import com.sun.messaging.jmq.auth.api.client.AuthenticationProtocolHandler;
import com.sun.messaging.jmq.auth.handlers.BasicAuthenticationHandler;
import com.sun.messaging.jmq.auth.handlers.DigestAuthenticationHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.auth.AuthCacheData;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.ServiceType;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import javax.security.auth.login.LoginException;

public class MQAuthenticator {
    private static boolean DEBUG = false;
    private String serviceName = null;
    private String serviceTypeStr = null;
    private Hashtable handlers = new Hashtable();
    private AuthCacheData authCacheData = new AuthCacheData();
    private AccessController ac = null;
    public static final String CMDUSER_PROPERTY = "imq.imqcmd.user";
    public static final String CMDUSER_PWD_PROPERTY = "imq.imqcmd.password";
    public static final String CMDUSER_SVC_PROPERTY = "imq.imqcmd.service";

    public MQAuthenticator(String serviceName, int serviceType) throws BrokerException {
        this.serviceName = serviceName;
        this.serviceTypeStr = ServiceType.getServiceTypeString((int)serviceType);
        this.ac = AccessController.getInstance(serviceName, serviceType);
    }

    public void authenticate(String username, String password) throws BrokerException, LoginException {
        this.authenticate(username, password, true);
    }

    public void authenticate(String username, String password, boolean logout) throws BrokerException, LoginException {
        String authType = this.ac.getAuthType();
        AuthenticationProtocolHandler hd = this.getClientAuthHandler(authType);
        if (!hd.getType().equals(authType)) {
            Object[] args = new String[]{authType, hd.getType(), hd.getClass().getName()};
            throw new BrokerException(Globals.getBrokerResources().getKString("B4078", args));
        }
        hd.init(username, password);
        int seq = 0;
        byte[] req = this.ac.getChallenge(seq, new Properties(), this.getAuthCacheData().getCacheData(), null);
        while ((req = this.ac.handleResponse(hd.handleRequest(req, seq++), seq)) != null) {
        }
        this.authCacheData.setCacheData(this.ac.getCacheData());
        this.ac.checkConnectionPermission(this.serviceName, this.serviceTypeStr);
        if (logout) {
            this.ac.logout();
        }
    }

    public void logout() {
        if (this.ac != null) {
            this.ac.logout();
        }
    }

    public AuthCacheData getAuthCacheData() {
        return this.authCacheData;
    }

    public AccessController getAccessController() {
        return this.ac;
    }

    private AuthenticationProtocolHandler getClientAuthHandler(String authType) throws BrokerException {
        AuthenticationProtocolHandler hd = (AuthenticationProtocolHandler)this.handlers.get(authType);
        if (hd != null) {
            return hd;
        }
        if (authType.equals("basic")) {
            hd = new BasicAuthenticationHandler();
            this.handlers.put(authType, hd);
        } else if (authType.equals("digest")) {
            hd = new DigestAuthenticationHandler();
            this.handlers.put(authType, hd);
        } else {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4040", authType));
        }
        return hd;
    }

    public static boolean authenticateCMDUserIfset() {
        List activesvcs;
        BrokerConfig bcfg = Globals.getConfig();
        String cmduser = bcfg.getProperty(CMDUSER_PROPERTY);
        if (cmduser == null) {
            return true;
        }
        Logger logger = Globals.getLogger();
        if (cmduser.trim().length() == 0) {
            logger.log(64, "B4027", (Object)("imq.imqcmd.user=" + cmduser));
            return false;
        }
        String cmdpwd = bcfg.getProperty(CMDUSER_PWD_PROPERTY);
        if (cmdpwd == null) {
            logger.log(64, "B4066", (Object)("imq.imqcmd.user=" + cmduser));
            return false;
        }
        String cmdsvc = bcfg.getProperty(CMDUSER_SVC_PROPERTY);
        if (cmdsvc == null) {
            cmdsvc = "admin";
        }
        if ((activesvcs = ServiceManager.getAllActiveServiceNames()) == null || !activesvcs.contains(cmdsvc)) {
            logger.log(64, "B3214", (Object)cmdsvc, (Object)("imq.imqcmd.user=" + cmduser));
            return false;
        }
        String str = ServiceManager.getServiceTypeString(cmdsvc);
        if (str == null || ServiceType.getServiceType((String)str) != 1) {
            Object[] args = new String[]{cmdsvc, str, "imq.imqcmd.user=" + cmduser};
            logger.log(64, "B3215", args);
            return false;
        }
        try {
            MQAuthenticator a = new MQAuthenticator(cmdsvc, 1);
            a.authenticate(cmduser, cmdpwd);
            if (DEBUG) {
                logger.log(64, "B1243", (Object)("imq.imqcmd.user=" + cmduser), (Object)cmdsvc);
            }
            return true;
        }
        catch (Exception e) {
            if (DEBUG) {
                logger.logStack(64, "B2000", (Object)cmduser, (Object)cmdsvc, (Throwable)e);
            } else {
                logger.log(64, "B2000", (Object)cmduser, (Object)cmdsvc);
            }
            return false;
        }
    }
}

