/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp;

import com.sun.messaging.bridge.api.StompFrameMessage;
import com.sun.messaging.bridge.api.StompProtocolHandler;
import com.sun.messaging.jmq.io.JMSPacket;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompConnectionImpl;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompDestinationImpl;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompSessionImpl;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jmq.jmsservice.JMSServiceReply;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StompSenderSession
extends StompSessionImpl {
    protected Map<String, Long> producers = new HashMap<String, Long>();

    public StompSenderSession(StompConnectionImpl stompc) throws Exception {
        super(stompc, StompProtocolHandler.StompAckMode.AUTO_ACK, false);
    }

    protected StompSenderSession(StompConnectionImpl stompc, boolean transacted) throws Exception {
        super(stompc, StompProtocolHandler.StompAckMode.AUTO_ACK, transacted);
    }

    public String toString() {
        return "[StompSenderSession@" + this.hashCode() + ", producers=" + this.producers.size() + "]";
    }

    @Override
    protected synchronized void closeProducers() {
        Iterator<Long> itr = this.producers.values().iterator();
        Long prodid = null;
        while (itr.hasNext()) {
            prodid = itr.next();
            try {
                this.jmsservice.deleteProducer(this.connectionId, this.sessionId, prodid);
            }
            catch (Exception e) {
                if (this.isClosing() && !this.getDEBUG()) continue;
                logger.logStack(16, e.getMessage(), (Throwable)e);
            }
        }
        this.producers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendStompMessage(StompFrameMessage message) throws Exception {
        this.checkSession();
        Packet pkt = new Packet();
        pkt.setPersistent(JMSService.DEFAULT_MessageDeliveryMode == JMSService.MessageDeliveryMode.PERSISTENT);
        pkt.setPriority(JMSService.DEFAULT_MessagePriority.priority());
        pkt.setExpiration(0L);
        pkt.setDeliveryTime(0L);
        this.stompconn.fillRemoteIPAndPort(pkt);
        StompDestinationImpl d = this.fromStompFrameMessage(message, pkt);
        String stompdest = d.getStompDestinationString();
        try {
            this.jmsservice.createDestination(this.connectionId, d.getDestination());
        }
        catch (JMSServiceException jmsse) {
            JMSServiceReply.Status status = jmsse.getJMSServiceReply().getStatus();
            if (status == JMSServiceReply.Status.CONFLICT) {
                if (logger.isFineLoggable() || this.stompconn.getProtocolHandler().getDEBUG()) {
                    logger.log(8, "Destination " + stompdest + " already exist");
                }
            }
            throw jmsse;
        }
        StompSenderSession stompSenderSession = this;
        synchronized (stompSenderSession) {
            Long prodid = this.producers.get(stompdest);
            if (prodid == null) {
                JMSServiceReply reply = this.jmsservice.addProducer(this.connectionId, this.sessionId, d.getDestination());
                prodid = reply.getJMQProducerID();
                this.producers.put(stompdest, prodid);
            }
            pkt.setProducerID(prodid.longValue());
        }
        pkt.prepareToSend();
        stompSenderSession = this;
        synchronized (stompSenderSession) {
            if (this.isTransacted()) {
                pkt.setTransactionID(this.getTransactionId());
            } else {
                pkt.setTransactionID(0L);
            }
            final Packet p = pkt;
            this.jmsservice.sendMessage(this.connectionId, new JMSPacket(){

                public Packet getPacket() {
                    return p;
                }
            });
        }
        if (logger.isFineLoggable() || this.stompconn.getProtocolHandler().getDEBUG()) {
            logger.log(8, "Sent message " + String.valueOf(pkt.getSysMessageID()));
        }
    }
}

