/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.LogLSN;
import java.io.Serializable;

class LogRecordHeader
implements Serializable {
    static final int SIZEOF = 32;
    int recordType = 0;
    LogLSN currentLSN = null;
    LogLSN previousLSN = null;
    LogLSN nextLSN = null;
    int recordLength = 0;

    LogRecordHeader() {
        this.currentLSN = new LogLSN();
        this.previousLSN = new LogLSN();
        this.nextLSN = new LogLSN();
    }

    LogRecordHeader(byte[] bytes, int index) {
        this.recordType = (bytes[index++] & 0xFF) + ((bytes[index++] & 0xFF) << 8) + ((bytes[index++] & 0xFF) << 16) + ((bytes[index++] & 0xFF) << 24);
        this.currentLSN = new LogLSN(bytes, index);
        this.previousLSN = new LogLSN(bytes, index += 8);
        this.nextLSN = new LogLSN(bytes, index += 8);
        index += 8;
        this.recordLength = (bytes[index++] & 0xFF) + ((bytes[index++] & 0xFF) << 8) + ((bytes[index++] & 0xFF) << 16) + ((bytes[index++] & 0xFF) << 24);
    }

    void copy(LogRecordHeader other) {
        this.recordType = other.recordType;
        this.currentLSN.copy(other.currentLSN);
        this.previousLSN.copy(other.previousLSN);
        this.nextLSN.copy(other.nextLSN);
        this.recordLength = other.recordLength;
    }

    final int toBytes(byte[] bytes, int index) {
        bytes[index++] = (byte)this.recordType;
        bytes[index++] = (byte)(this.recordType >> 8);
        bytes[index++] = (byte)(this.recordType >> 16);
        bytes[index++] = (byte)(this.recordType >> 24);
        index += this.currentLSN.toBytes(bytes, index);
        index += this.previousLSN.toBytes(bytes, index);
        index += this.nextLSN.toBytes(bytes, index);
        bytes[index++] = (byte)this.recordLength;
        bytes[index++] = (byte)(this.recordLength >> 8);
        bytes[index++] = (byte)(this.recordLength >> 16);
        bytes[index++] = (byte)(this.recordLength >> 24);
        return 32;
    }

    public final String toString() {
        return "LRH(type=" + this.recordType + ",curr=" + String.valueOf(this.currentLSN) + ",prev=" + String.valueOf(this.previousLSN) + ",next=" + String.valueOf(this.nextLSN) + ",len=" + this.recordLength + ")";
    }
}

