/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.heartbeat;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class HeartbeatInfo {
    public static final short HEARTBEAT_ALIVE = 1;
    public static final int HEARTBEAT_PROTOCOL_VERSION = 400;
    private String brokerID = null;
    private long brokerSession = 0L;
    private BrokerMQAddress brokerAddress = null;
    private String toBrokerID = null;
    private long toBrokerSession = 0L;
    private long sequence = 0L;
    private GPacket pkt = null;

    private HeartbeatInfo(GPacket pkt) {
        this.pkt = pkt;
    }

    private HeartbeatInfo() {
    }

    public static HeartbeatInfo newInstance() {
        return new HeartbeatInfo();
    }

    public static HeartbeatInfo newInstance(byte[] data) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        GPacket pkt = GPacket.getInstance();
        pkt.read((InputStream)bis);
        int ver = (Integer)pkt.getProp((Object)"protocolVersion");
        if (ver < 400) {
            throw new IOException("Protocol version not supported:" + ver);
        }
        return new HeartbeatInfo(pkt);
    }

    public GPacket getGPacket() {
        GPacket gp = GPacket.getInstance();
        gp.generateSequenceNumber(false);
        gp.setType((short)1);
        gp.setSequence(this.sequence);
        gp.putProp((Object)"protocolVersion", (Object)400);
        gp.putProp((Object)"brokerID", (Object)this.brokerID);
        gp.putProp((Object)"brokerSession", (Object)this.brokerSession);
        gp.putProp((Object)"brokerAddress", (Object)this.brokerAddress.toString());
        gp.putProp((Object)"toBrokerID", (Object)this.toBrokerID);
        gp.putProp((Object)"toBrokerSession", (Object)this.toBrokerSession);
        return gp;
    }

    public static byte[] toByteArray(GPacket pkt) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            pkt.write((OutputStream)bos);
            bos.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public void setBrokerID(String id) {
        this.brokerID = id;
    }

    public void setBrokerSession(long uid) {
        this.brokerSession = uid;
    }

    public void setBrokerAddress(BrokerMQAddress ma) {
        this.brokerAddress = ma;
    }

    public void setToBrokerID(String id) {
        this.toBrokerID = id;
    }

    public void setToBrokerSession(long uid) {
        this.toBrokerSession = uid;
    }

    public void setSequence(long s) {
        this.sequence = s;
    }

    public String getBrokerID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"brokerID");
    }

    public long getBrokerSession() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"brokerSession");
    }

    public String getToBrokerID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"toBrokerID");
    }

    public long getToBrokerSession() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"toBrokerSession");
    }

    public long getSequence() {
        assert (this.pkt != null);
        return this.pkt.getSequence();
    }

    public String toString() {
        if (this.pkt != null) {
            return "#" + this.getSequence() + " [" + this.getBrokerID() + "," + this.getBrokerSession() + "] to [" + this.getToBrokerID() + "," + this.getToBrokerSession() + "]";
        }
        return "[" + this.brokerID + "," + this.brokerSession + "] to [" + this.toBrokerID + "," + this.toBrokerSession + "]";
    }
}

