/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.ConstructorSignature;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.annotated.enhanced.jlr.MethodSignatureImpl;
import org.jboss.weld.annotated.slim.AnnotatedTypeIdentifier;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedTypeStore;
import org.jboss.weld.bean.proxy.InterceptedSubclassFactory;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.ProxyClassConstructorInjectionPointWrapper;
import org.jboss.weld.injection.producer.AbstractInstantiator;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.collections.WeldCollections;

public class SubclassedComponentInstantiator<T>
extends AbstractInstantiator<T> {
    private final ConstructorInjectionPoint<T> proxyClassConstructorInjectionPoint;
    private final Constructor<T> componentClassConstructor;

    public static <T> SubclassedComponentInstantiator<T> forSubclassedEjb(EnhancedAnnotatedType<T> componentType, EnhancedAnnotatedType<T> subclass, Bean<T> bean, BeanManagerImpl manager) {
        EnhancedAnnotatedConstructor<T> componentConstructor = Beans.getBeanConstructor(componentType);
        EnhancedAnnotatedConstructor<T> subclassConstructor = SubclassedComponentInstantiator.findMatchingConstructor(componentConstructor.getSignature(), subclass);
        ConstructorInjectionPoint<T> cip = InjectionPointFactory.instance().createConstructorInjectionPoint(bean, componentType.getJavaClass(), subclassConstructor, manager);
        return new SubclassedComponentInstantiator<T>(cip, componentConstructor.getJavaMember());
    }

    public static <T> SubclassedComponentInstantiator<T> forInterceptedDecoratedBean(EnhancedAnnotatedType<T> type, Bean<T> bean, AbstractInstantiator<T> delegate, BeanManagerImpl manager) {
        return new SubclassedComponentInstantiator<T>(type, bean, delegate.getConstructorInjectionPoint(), manager);
    }

    private static <T> EnhancedAnnotatedConstructor<T> findMatchingConstructor(ConstructorSignature componentConstructor, EnhancedAnnotatedType<T> subclass) {
        return subclass.getDeclaredEnhancedConstructor(componentConstructor);
    }

    private SubclassedComponentInstantiator(ConstructorInjectionPoint<T> proxyClassConstructorInjectionPoint, Constructor<T> componentClassConstructor) {
        this.proxyClassConstructorInjectionPoint = proxyClassConstructorInjectionPoint;
        this.componentClassConstructor = componentClassConstructor;
    }

    protected SubclassedComponentInstantiator(EnhancedAnnotatedType<T> type, Bean<T> bean, ConstructorInjectionPoint<T> originalConstructor, BeanManagerImpl manager) {
        EnhancedAnnotatedConstructor<T> constructorForEnhancedSubclass = this.initEnhancedSubclass(manager, type, bean, originalConstructor);
        this.proxyClassConstructorInjectionPoint = new ProxyClassConstructorInjectionPointWrapper<T>(bean, type.getJavaClass(), constructorForEnhancedSubclass, originalConstructor, manager);
        this.componentClassConstructor = originalConstructor.getAnnotated().getJavaMember();
    }

    protected EnhancedAnnotatedConstructor<T> initEnhancedSubclass(BeanManagerImpl manager, EnhancedAnnotatedType<T> type, Bean<?> bean, ConstructorInjectionPoint<T> originalConstructorInjectionPoint) {
        ClassTransformer transformer = manager.getServices().get(ClassTransformer.class);
        EnhancedAnnotatedType<T> enhancedSubclass = transformer.getEnhancedAnnotatedType(this.createEnhancedSubclass(type, bean, manager), ((AnnotatedTypeIdentifier)type.slim().getIdentifier()).getBdaId());
        return SubclassedComponentInstantiator.findMatchingConstructor(originalConstructorInjectionPoint.getSignature(), enhancedSubclass);
    }

    protected Class<T> createEnhancedSubclass(EnhancedAnnotatedType<T> type, Bean<?> bean, BeanManagerImpl manager) {
        Set<InterceptionModel> models = this.getInterceptionModelsForType(type, manager, bean);
        HashSet<MethodSignature> enhancedMethodSignatures = new HashSet<MethodSignature>();
        HashSet<MethodSignature> interceptedMethodSignatures = models == null ? enhancedMethodSignatures : new HashSet<MethodSignature>();
        block0: for (AnnotatedMethod annotatedMethod : Beans.getInterceptableMethods(type)) {
            enhancedMethodSignatures.add(MethodSignatureImpl.of(annotatedMethod));
            if (models == null) continue;
            for (InterceptionModel model : models) {
                if (model.getInterceptors(InterceptionType.AROUND_INVOKE, annotatedMethod.getJavaMember()).isEmpty()) continue;
                interceptedMethodSignatures.add(MethodSignatureImpl.of(annotatedMethod));
                continue block0;
            }
        }
        Set types = null;
        types = bean == null ? Collections.singleton(type.getJavaClass()) : bean.getTypes();
        return new InterceptedSubclassFactory(manager.getContextId(), type.getJavaClass(), types, bean, enhancedMethodSignatures, interceptedMethodSignatures).getProxyClass();
    }

    private Set<InterceptionModel> getInterceptionModelsForType(EnhancedAnnotatedType<T> type, BeanManagerImpl manager, Bean<?> bean) {
        if (bean != null && !manager.resolveDecorators((Set<Type>)bean.getTypes(), bean.getQualifiers()).isEmpty()) {
            return null;
        }
        SlimAnnotatedTypeStore store = manager.getServices().get(SlimAnnotatedTypeStore.class);
        HashSet<InterceptionModel> models = new HashSet<InterceptionModel>();
        WeldCollections.addIfNotNull(models, (InterceptionModel)manager.getInterceptorModelRegistry().get(type.slim()));
        for (SlimAnnotatedType slimType : store.get(type.getJavaClass())) {
            WeldCollections.addIfNotNull(models, (InterceptionModel)manager.getInterceptorModelRegistry().get(slimType));
        }
        for (InterceptionModel model : models) {
            if (!model.hasTargetClassInterceptors() || !model.getTargetClassInterceptorMetadata().isEligible(InterceptionType.AROUND_INVOKE)) continue;
            return null;
        }
        return models;
    }

    public String toString() {
        return "SubclassedComponentInstantiator for " + String.valueOf(this.proxyClassConstructorInjectionPoint.getType());
    }

    @Override
    public boolean hasInterceptorSupport() {
        return false;
    }

    @Override
    public boolean hasDecoratorSupport() {
        return false;
    }

    @Override
    public ConstructorInjectionPoint<T> getConstructorInjectionPoint() {
        return this.proxyClassConstructorInjectionPoint;
    }

    @Override
    public Constructor<T> getConstructor() {
        return this.componentClassConstructor;
    }
}

