/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.spi;

import com.ibm.jbatch.spi.ServiceInfo;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;

public class ServiceRegistry {
    private static final String sourceClass = ServiceRegistry.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);

    protected static Set<String> getAllServicePropertyNames() {
        HashSet<String> retVal = new HashSet<String>();
        retVal.add("BATCH_THREADPOOL_SERVICE");
        retVal.add("CONTAINER_ARTIFACT_FACTORY_SERVICE");
        retVal.add("DELEGATING_ARTIFACT_FACTORY_SERVICE");
        retVal.add("DELEGATING_JOBXML_LOADER_SERVICE");
        retVal.add("J2SE_MODE");
        retVal.add("JOBXML_LOADER_SERVICE");
        retVal.add("TRANSACTION_SERVICE");
        return retVal;
    }

    public static ServiceInfo getServiceInfo(String servicePropertyName) {
        String s = servicePropertyName;
        if (s == null) {
            throw new IllegalArgumentException("getServiceInfo() called with <null> property name");
        }
        if (s.equals("BATCH_THREADPOOL_SERVICE")) {
            return new ServiceInfo("BATCH_THREADPOOL_SERVICE", "com.ibm.jbatch.container.services.impl.GrowableThreadPoolServiceImpl", "com.ibm.jbatch.spi.services.IBatchThreadPoolService");
        }
        if (s.equals("CONTAINER_ARTIFACT_FACTORY_SERVICE")) {
            return new ServiceInfo("CONTAINER_ARTIFACT_FACTORY_SERVICE", "com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "com.ibm.jbatch.spi.services.IBatchArtifactFactory");
        }
        if (s.equals("DELEGATING_ARTIFACT_FACTORY_SERVICE")) {
            return new ServiceInfo("DELEGATING_ARTIFACT_FACTORY_SERVICE", "com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl", "com.ibm.jbatch.spi.services.IBatchArtifactFactory");
        }
        if (s.equals("DELEGATING_JOBXML_LOADER_SERVICE")) {
            return new ServiceInfo("DELEGATING_JOBXML_LOADER_SERVICE", "com.ibm.jbatch.container.services.impl.DelegatingJobXMLLoaderServiceImpl", "com.ibm.jbatch.spi.services.IJobXMLLoaderService");
        }
        if (s.equals("J2SE_MODE")) {
            return new ServiceInfo("J2SE_MODE", "<not.a.true.java.implementation>", "<not.a.true.java.interface>");
        }
        if (s.equals("JOBXML_LOADER_SERVICE")) {
            return new ServiceInfo("JOBXML_LOADER_SERVICE", "com.ibm.jbatch.container.services.impl.DelegatingJobXMLLoaderServiceImpl", "com.ibm.jbatch.spi.services.IJobXMLLoaderService");
        }
        if (s.equals("TRANSACTION_SERVICE")) {
            return new ServiceInfo("TRANSACTION_SERVICE", "com.ibm.jbatch.container.services.impl.BatchTransactionServiceImpl", "com.ibm.jbatch.spi.services.ITransactionManagementService");
        }
        throw new IllegalArgumentException("getServiceInfo() called with unrecognized property name: " + s);
    }

    public static Properties getSystemPropertyOverrides() {
        String PROP_PREFIX = sourceClass;
        Properties props = new Properties();
        for (String propName : ServiceRegistry.getAllServicePropertyNames()) {
            String key = PROP_PREFIX + "." + propName;
            String val = System.getProperty(key);
            if (val == null) continue;
            logger.fine("Found override property from system properties (key,value) = (" + propName + "," + val + ")");
            props.setProperty(propName, val);
        }
        return props;
    }

    public static interface ServiceInterfaceNames {
        public static final String BATCH_THREADPOOL = "com.ibm.jbatch.spi.services.IBatchThreadPoolService";
        public static final String CONTAINER_ARTIFACT_FACTORY = "com.ibm.jbatch.spi.services.IBatchArtifactFactory";
        public static final String JOBXML_LOADER = "com.ibm.jbatch.spi.services.IJobXMLLoaderService";
        public static final String TRANSACTION = "com.ibm.jbatch.spi.services.ITransactionManagementService";
    }

    public static interface ServicePropertyNames {
        public static final String BATCH_THREADPOOL_SERVICE = "BATCH_THREADPOOL_SERVICE";
        public static final String CONTAINER_ARTIFACT_FACTORY_SERVICE = "CONTAINER_ARTIFACT_FACTORY_SERVICE";
        public static final String DELEGATING_ARTIFACT_FACTORY_SERVICE = "DELEGATING_ARTIFACT_FACTORY_SERVICE";
        public static final String DELEGATING_JOBXML_LOADER_SERVICE = "DELEGATING_JOBXML_LOADER_SERVICE";
        public static final String J2SE_MODE = "J2SE_MODE";
        public static final String JOBXML_LOADER_SERVICE = "JOBXML_LOADER_SERVICE";
        public static final String TRANSACTION_SERVICE = "TRANSACTION_SERVICE";
    }

    public static interface ServiceImplClassNames {
        public static final String CONTAINER_ARTIFACT_FACTORY_CDI = "com.ibm.jbatch.container.services.impl.CDIBatchArtifactFactoryImpl";
        public static final String CONTAINER_ARTIFACT_FACTORY_WELD_SE = "com.ibm.jbatch.container.services.impl.WeldSEBatchArtifactFactoryImpl";
        public static final String DELEGATING_JOBXML_LOADER_DEFAULT = "com.ibm.jbatch.container.services.impl.DelegatingJobXMLLoaderServiceImpl";
        public static final String DELEGATING_ARTIFACT_FACTORY_DEFAULT = "com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl";
        public static final String JOBXML_LOADER_DIRECTORY = "com.ibm.jbatch.container.services.impl.DirectoryJobXMLLoaderServiceImpl";
        public static final String BATCH_THREADPOOL_BOUNDED = "com.ibm.jbatch.container.services.impl.BoundedThreadPoolServiceImpl";
        public static final String BATCH_THREADPOOL_DEFAULT = "com.ibm.jbatch.container.services.impl.GrowableThreadPoolServiceImpl";
        public static final String BATCH_THREADPOOL_GROWABLE = "com.ibm.jbatch.container.services.impl.GrowableThreadPoolServiceImpl";
        public static final String BATCH_THREADPOOL_JNDI_DELEGATING = "com.ibm.jbatch.container.services.impl.JNDIDelegatingThreadPoolServiceImpl";
        public static final String BATCH_THREADPOOL_SPI_DELEGATING = "com.ibm.jbatch.container.services.impl.SPIDelegatingThreadPoolServiceImpl";
        public static final String TRANSACTION_DEFAULT = "com.ibm.jbatch.container.services.impl.BatchTransactionServiceImpl";
    }
}

