/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wsdl.document;

import com.sun.tools.ws.api.wsdl.TWSDLExtensible;
import com.sun.tools.ws.api.wsdl.TWSDLExtension;
import com.sun.tools.ws.wsdl.document.Binding;
import com.sun.tools.ws.wsdl.document.Documentation;
import com.sun.tools.ws.wsdl.document.Import;
import com.sun.tools.ws.wsdl.document.Kinds;
import com.sun.tools.ws.wsdl.document.Message;
import com.sun.tools.ws.wsdl.document.PortType;
import com.sun.tools.ws.wsdl.document.Service;
import com.sun.tools.ws.wsdl.document.Types;
import com.sun.tools.ws.wsdl.document.WSDLConstants;
import com.sun.tools.ws.wsdl.document.WSDLDocumentVisitor;
import com.sun.tools.ws.wsdl.framework.AbstractDocument;
import com.sun.tools.ws.wsdl.framework.Defining;
import com.sun.tools.ws.wsdl.framework.Entity;
import com.sun.tools.ws.wsdl.framework.EntityAction;
import com.sun.tools.ws.wsdl.framework.ExtensibilityHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.xml.sax.Locator;

public class Definitions
extends Entity
implements Defining,
TWSDLExtensible {
    private AbstractDocument _document;
    private ExtensibilityHelper _helper;
    private Documentation _documentation;
    private String _name;
    private String _targetNsURI;
    private Types _types;
    private List<Message> _messages;
    private List<PortType> _portTypes;
    private List<Binding> _bindings;
    private List<Service> _services;
    private List<Import> _imports;
    private Set<String> _importedNamespaces;

    public Definitions(AbstractDocument document, Locator locator) {
        super(locator);
        this._document = document;
        this._bindings = new ArrayList<Binding>();
        this._imports = new ArrayList<Import>();
        this._messages = new ArrayList<Message>();
        this._portTypes = new ArrayList<PortType>();
        this._services = new ArrayList<Service>();
        this._importedNamespaces = new HashSet<String>();
        this._helper = new ExtensibilityHelper();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String s) {
        this._name = s;
    }

    @Override
    public String getTargetNamespaceURI() {
        return this._targetNsURI;
    }

    public void setTargetNamespaceURI(String s) {
        this._targetNsURI = s;
    }

    public void setTypes(Types t) {
        this._types = t;
    }

    public Types getTypes() {
        return this._types;
    }

    public void add(Message m) {
        this._document.define(m);
        this._messages.add(m);
    }

    public void add(PortType p) {
        this._document.define(p);
        this._portTypes.add(p);
    }

    public void add(Binding b) {
        this._document.define(b);
        this._bindings.add(b);
    }

    public void add(Service s) {
        this._document.define(s);
        this._services.add(s);
    }

    public void addServiceOveride(Service s) {
        this._services.add(s);
    }

    public void add(Import i) {
        this._imports.add(i);
        this._importedNamespaces.add(i.getNamespace());
    }

    public Iterator<Import> imports() {
        return this._imports.iterator();
    }

    public Iterator<Message> messages() {
        return this._messages.iterator();
    }

    public Iterator<PortType> portTypes() {
        return this._portTypes.iterator();
    }

    public Iterator<Binding> bindings() {
        return this._bindings.iterator();
    }

    public Iterator<Service> services() {
        return this._services.iterator();
    }

    @Override
    public String getNameValue() {
        return this.getName();
    }

    @Override
    public String getNamespaceURI() {
        return this.getTargetNamespaceURI();
    }

    @Override
    public QName getWSDLElementName() {
        return WSDLConstants.QNAME_DEFINITIONS;
    }

    public Documentation getDocumentation() {
        return this._documentation;
    }

    public void setDocumentation(Documentation d) {
        this._documentation = d;
    }

    @Override
    public void addExtension(TWSDLExtension e) {
        this._helper.addExtension(e);
    }

    public Iterable<TWSDLExtension> extensions() {
        return this._helper.extensions();
    }

    @Override
    public TWSDLExtensible getParent() {
        return null;
    }

    @Override
    public void withAllSubEntitiesDo(EntityAction action) {
        if (this._types != null) {
            action.perform(this._types);
        }
        for (Message message : this._messages) {
            action.perform(message);
        }
        for (PortType portType : this._portTypes) {
            action.perform(portType);
        }
        for (Binding binding : this._bindings) {
            action.perform(binding);
        }
        for (Service service : this._services) {
            action.perform(service);
        }
        for (Import anImport : this._imports) {
            action.perform(anImport);
        }
        this._helper.withAllSubEntitiesDo(action);
    }

    public void accept(WSDLDocumentVisitor visitor) throws Exception {
        visitor.preVisit(this);
        for (Import anImport : this._imports) {
            anImport.accept(visitor);
        }
        if (this._types != null) {
            this._types.accept(visitor);
        }
        for (Message message : this._messages) {
            message.accept(visitor);
        }
        for (PortType portType : this._portTypes) {
            portType.accept(visitor);
        }
        for (Binding binding : this._bindings) {
            binding.accept(visitor);
        }
        for (Service service : this._services) {
            service.accept(visitor);
        }
        this._helper.accept(visitor);
        visitor.postVisit(this);
    }

    @Override
    public void validateThis() {
    }

    public Map resolveBindings() {
        return this._document.getMap(Kinds.BINDING);
    }

    @Override
    public QName getElementName() {
        return this.getWSDLElementName();
    }
}

