/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.deployment;

import java.util.Comparator;
import org.glassfish.internal.deployment.ApplicationOrderInfo;

public class DeploymentType
implements Comparator {
    public static final String SYSTEM_PREFIX = "system-";
    public static final String USER = "user";
    public static final String INTERNAL_APP_NAME = "InternalApp";
    public static final String CONNECTOR_NAME = "Connector";
    public static final String DEFAULT_APP_NAME = "DefaultApp";
    private final String name;
    private final Class cls;
    public static final DeploymentType INTERNAL_APP = new DeploymentType("InternalApp", ApplicationOrderInfo.class){

        @Override
        public boolean isInstance(Object obj) {
            ApplicationOrderInfo appOrderInfo;
            return super.isInstance(obj) && (appOrderInfo = (ApplicationOrderInfo)obj).getApplication().getObjectType().startsWith(DeploymentType.SYSTEM_PREFIX);
        }
    };
    public static final DeploymentType DEFAULT_APP = new DeploymentType("DefaultApp", ApplicationOrderInfo.class){

        @Override
        public boolean isInstance(Object obj) {
            ApplicationOrderInfo appOrderInfo;
            return super.isInstance(obj) && (appOrderInfo = (ApplicationOrderInfo)obj).getApplication().getObjectType().equals(DeploymentType.USER);
        }
    };
    public static final DeploymentType CONNECTOR = new DeploymentType("Connector", ApplicationOrderInfo.class){

        @Override
        public boolean isInstance(Object obj) {
            ApplicationOrderInfo appOrderInfo;
            return super.isInstance(obj) && (appOrderInfo = (ApplicationOrderInfo)obj).getApplication().containsSnifferType("connector") && appOrderInfo.getApplication().isStandaloneModule();
        }
    };

    private DeploymentType(String name, Class cls) {
        this.name = name;
        this.cls = cls;
    }

    public String toString() {
        return this.name;
    }

    public boolean isInstance(Object obj) {
        return this.cls.isInstance(obj);
    }

    public Comparator getComparator() {
        return this;
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof ApplicationOrderInfo && o2 instanceof ApplicationOrderInfo) {
            return this.compare((ApplicationOrderInfo)o1, (ApplicationOrderInfo)o2);
        }
        return this.defaultCompare(o1, o2);
    }

    protected int defaultCompare(Object o1, Object o2) {
        if (o1 instanceof ApplicationOrderInfo && o2 instanceof ApplicationOrderInfo) {
            ApplicationOrderInfo o1App = (ApplicationOrderInfo)o1;
            ApplicationOrderInfo o2App = (ApplicationOrderInfo)o2;
            return o1App.getOriginalOrder() - o2App.getOriginalOrder();
        }
        return 0;
    }

    protected int compare(ApplicationOrderInfo d1, ApplicationOrderInfo d2) {
        int comp = new Integer(d1.getApplication().getDeploymentOrder()).compareTo(new Integer(d2.getApplication().getDeploymentOrder()));
        if (comp == 0) {
            return this.defaultCompare(d1, d2);
        }
        return comp;
    }
}

