/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.Weight;
import io.helidon.config.ClasspathConfigSource;
import io.helidon.config.ClasspathOverrideSource;
import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigSources;
import io.helidon.config.DirectoryConfigSource;
import io.helidon.config.FileConfigSource;
import io.helidon.config.FileOverrideSource;
import io.helidon.config.FileSystemWatcher;
import io.helidon.config.InlinedConfigSource;
import io.helidon.config.MetaConfigException;
import io.helidon.config.PollingStrategies;
import io.helidon.config.PrefixedConfigSource;
import io.helidon.config.SimpleRetryPolicy;
import io.helidon.config.UrlConfigSource;
import io.helidon.config.UrlOverrideSource;
import io.helidon.config.spi.ChangeWatcher;
import io.helidon.config.spi.ChangeWatcherProvider;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.ConfigSourceProvider;
import io.helidon.config.spi.OverrideSource;
import io.helidon.config.spi.OverrideSourceProvider;
import io.helidon.config.spi.PollingStrategy;
import io.helidon.config.spi.PollingStrategyProvider;
import io.helidon.config.spi.RetryPolicy;
import io.helidon.config.spi.RetryPolicyProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;

final class MetaProviders {
    private static final List<ConfigSourceProvider> CONFIG_SOURCE_PROVIDERS;
    private static final List<RetryPolicyProvider> RETRY_POLICY_PROVIDERS;
    private static final List<PollingStrategyProvider> POLLING_STRATEGY_PROVIDERS;
    private static final List<ChangeWatcherProvider> CHANGE_WATCHER_PROVIDERS;
    private static final List<OverrideSourceProvider> OVERRIDE_SOURCE_PROVIDERS;
    private static final Set<String> SUPPORTED_CONFIG_SOURCES;
    private static final Set<String> SUPPORTED_RETRY_POLICIES;
    private static final Set<String> SUPPORTED_POLLING_STRATEGIES;
    private static final Set<String> SUPPORTED_CHANGE_WATCHERS;
    private static final Set<String> SUPPORTED_OVERRIDE_SOURCES;

    private MetaProviders() {
    }

    static ConfigSource configSource(String type, Config config) {
        return CONFIG_SOURCE_PROVIDERS.stream().filter(provider -> provider.supports(type)).findFirst().map(provider -> (ConfigSource)provider.create(type, config)).orElseThrow(() -> new MetaConfigException("Config source of type " + type + " is not supported. Supported types: " + String.valueOf(SUPPORTED_CONFIG_SOURCES)));
    }

    static List<ConfigSource> configSources(String type, Config sourceProperties) {
        return CONFIG_SOURCE_PROVIDERS.stream().filter(provider -> provider.supports(type)).findFirst().map(provider -> provider.createMulti(type, sourceProperties)).orElseThrow(() -> new MetaConfigException("Config source of type " + type + " is not supported. Supported types: " + String.valueOf(SUPPORTED_CONFIG_SOURCES)));
    }

    static OverrideSource overrideSource(String type, Config config) {
        return OVERRIDE_SOURCE_PROVIDERS.stream().filter(provider -> provider.supports(type)).findFirst().map(provider -> (OverrideSource)provider.create(type, config)).orElseThrow(() -> new MetaConfigException("Config source of type " + type + " is not supported. Supported types: " + String.valueOf(SUPPORTED_OVERRIDE_SOURCES)));
    }

    static PollingStrategy pollingStrategy(String type, Config config) {
        return POLLING_STRATEGY_PROVIDERS.stream().filter(provider -> provider.supports(type)).findFirst().map(provider -> (PollingStrategy)provider.create(type, config)).orElseThrow(() -> new MetaConfigException("Polling strategy of type " + type + " is not supported. Supported types: " + String.valueOf(SUPPORTED_POLLING_STRATEGIES)));
    }

    static RetryPolicy retryPolicy(String type, Config config) {
        return RETRY_POLICY_PROVIDERS.stream().filter(provider -> provider.supports(type)).findFirst().map(provider -> (RetryPolicy)provider.create(type, config)).orElseThrow(() -> new MetaConfigException("Retry policy of type " + type + " is not supported. Supported types: " + String.valueOf(SUPPORTED_RETRY_POLICIES)));
    }

    public static ChangeWatcher<?> changeWatcher(String type, Config config) {
        return CHANGE_WATCHER_PROVIDERS.stream().filter(provider -> provider.supports(type)).findFirst().map(provider -> (ChangeWatcher)provider.create(type, config)).orElseThrow(() -> new MetaConfigException("Change watcher of type " + type + " is not supported. Supported types: " + String.valueOf(SUPPORTED_CHANGE_WATCHERS)));
    }

    static {
        SUPPORTED_CONFIG_SOURCES = new HashSet<String>();
        SUPPORTED_RETRY_POLICIES = new HashSet<String>();
        SUPPORTED_POLLING_STRATEGIES = new HashSet<String>();
        SUPPORTED_CHANGE_WATCHERS = new HashSet<String>();
        SUPPORTED_OVERRIDE_SOURCES = new HashSet<String>();
        CONFIG_SOURCE_PROVIDERS = HelidonServiceLoader.builder(ServiceLoader.load(ConfigSourceProvider.class)).addService((Object)new BuiltInConfigSourcesProvider()).build().asList();
        CONFIG_SOURCE_PROVIDERS.stream().map(rec$ -> ((ConfigSourceProvider)rec$).supported()).forEach(SUPPORTED_CONFIG_SOURCES::addAll);
        RETRY_POLICY_PROVIDERS = HelidonServiceLoader.builder(ServiceLoader.load(RetryPolicyProvider.class)).addService((Object)new BuiltInRetryPolicyProvider()).build().asList();
        RETRY_POLICY_PROVIDERS.stream().map(rec$ -> ((RetryPolicyProvider)rec$).supported()).forEach(SUPPORTED_RETRY_POLICIES::addAll);
        POLLING_STRATEGY_PROVIDERS = HelidonServiceLoader.builder(ServiceLoader.load(PollingStrategyProvider.class)).addService((Object)new BuiltInPollingStrategyProvider()).build().asList();
        POLLING_STRATEGY_PROVIDERS.stream().map(rec$ -> ((PollingStrategyProvider)rec$).supported()).forEach(SUPPORTED_POLLING_STRATEGIES::addAll);
        CHANGE_WATCHER_PROVIDERS = HelidonServiceLoader.builder(ServiceLoader.load(ChangeWatcherProvider.class)).addService((Object)new BuiltInChangeWatchers()).build().asList();
        CHANGE_WATCHER_PROVIDERS.stream().map(rec$ -> ((ChangeWatcherProvider)rec$).supported()).forEach(SUPPORTED_CHANGE_WATCHERS::addAll);
        OVERRIDE_SOURCE_PROVIDERS = HelidonServiceLoader.builder(ServiceLoader.load(OverrideSourceProvider.class)).addService((Object)new BuiltinOverrideSourceProvider()).build().asList();
        OVERRIDE_SOURCE_PROVIDERS.stream().map(rec$ -> ((OverrideSourceProvider)rec$).supported()).forEach(SUPPORTED_OVERRIDE_SOURCES::addAll);
    }

    @Weight(value=0.0)
    private static final class BuiltInConfigSourcesProvider
    implements ConfigSourceProvider {
        private static final String SYSTEM_PROPERTIES_TYPE = "system-properties";
        private static final String ENVIRONMENT_VARIABLES_TYPE = "environment-variables";
        private static final String CLASSPATH_TYPE = "classpath";
        private static final String FILE_TYPE = "file";
        private static final String DIRECTORY_TYPE = "directory";
        private static final String URL_TYPE = "url";
        private static final String PREFIXED_TYPE = "prefixed";
        private static final String INLINED_TYPE = "inlined";
        private static final Map<String, Function<Config, ConfigSource>> BUILT_INS = new HashMap<String, Function<Config, ConfigSource>>();

        private BuiltInConfigSourcesProvider() {
        }

        public boolean supports(String type) {
            return BUILT_INS.containsKey(type);
        }

        public ConfigSource create(String type, Config metaConfig) {
            return BUILT_INS.get(type).apply(metaConfig);
        }

        public List<ConfigSource> createMulti(String type, Config metaConfig) {
            if (CLASSPATH_TYPE.equals(type)) {
                return ClasspathConfigSource.createAll(metaConfig);
            }
            throw new ConfigException("Config source of type \"" + type + "\" does not support multiple config sources from a single configuration");
        }

        public Set<String> supported() {
            return BUILT_INS.keySet();
        }

        static {
            BUILT_INS.put(SYSTEM_PROPERTIES_TYPE, config -> ((ConfigSources.SystemPropertiesConfigSource.Builder)ConfigSources.systemProperties().config((Config)config)).build());
            BUILT_INS.put(ENVIRONMENT_VARIABLES_TYPE, config -> ConfigSources.environmentVariables());
            BUILT_INS.put(CLASSPATH_TYPE, ClasspathConfigSource::create);
            BUILT_INS.put(FILE_TYPE, FileConfigSource::create);
            BUILT_INS.put(DIRECTORY_TYPE, DirectoryConfigSource::create);
            BUILT_INS.put(URL_TYPE, UrlConfigSource::create);
            BUILT_INS.put(PREFIXED_TYPE, PrefixedConfigSource::create);
            BUILT_INS.put(INLINED_TYPE, InlinedConfigSource::create);
        }
    }

    @Weight(value=0.0)
    private static final class BuiltInRetryPolicyProvider
    implements RetryPolicyProvider {
        private static final String REPEAT_TYPE = "repeat";

        private BuiltInRetryPolicyProvider() {
        }

        public boolean supports(String type) {
            return REPEAT_TYPE.equals(type);
        }

        public RetryPolicy create(String type, Config metaConfig) {
            return SimpleRetryPolicy.create(metaConfig);
        }

        public Set<String> supported() {
            return Set.of(REPEAT_TYPE);
        }
    }

    @Weight(value=0.0)
    private static final class BuiltInPollingStrategyProvider
    implements PollingStrategyProvider {
        private static final String REGULAR_TYPE = "regular";

        private BuiltInPollingStrategyProvider() {
        }

        public boolean supports(String type) {
            return REGULAR_TYPE.equals(type);
        }

        public PollingStrategy create(String type, Config metaConfig) {
            return PollingStrategies.ScheduledBuilder.create(metaConfig).build();
        }

        public Set<String> supported() {
            return Set.of(REGULAR_TYPE);
        }
    }

    @Weight(value=0.0)
    private static final class BuiltInChangeWatchers
    implements ChangeWatcherProvider {
        private static final String FILE_WATCH = "file";

        private BuiltInChangeWatchers() {
        }

        public boolean supports(String type) {
            return FILE_WATCH.equals(type);
        }

        public ChangeWatcher<?> create(String type, Config metaConfig) {
            return FileSystemWatcher.builder().config(metaConfig).build();
        }

        public Set<String> supported() {
            return Set.of(FILE_WATCH);
        }
    }

    @Weight(value=0.0)
    private static final class BuiltinOverrideSourceProvider
    implements OverrideSourceProvider {
        private static final String FILE_TYPE = "file";
        private static final String CLASSPATH_TYPE = "classpath";
        private static final String URL_TYPE = "url";
        private static final Map<String, Function<Config, OverrideSource>> BUILT_INS = new HashMap<String, Function<Config, OverrideSource>>();

        private BuiltinOverrideSourceProvider() {
        }

        public boolean supports(String type) {
            return BUILT_INS.containsKey(type);
        }

        public OverrideSource create(String type, Config metaConfig) {
            return BUILT_INS.get(type).apply(metaConfig);
        }

        public Set<String> supported() {
            return BUILT_INS.keySet();
        }

        static {
            BUILT_INS.put(CLASSPATH_TYPE, ClasspathOverrideSource::create);
            BUILT_INS.put(FILE_TYPE, FileOverrideSource::create);
            BUILT_INS.put(URL_TYPE, UrlOverrideSource::create);
        }
    }
}

