/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.mp;

import io.helidon.common.GenericType;
import io.helidon.config.Config;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigValue;
import io.helidon.config.ConfigValues;
import io.helidon.config.MissingValueException;
import io.helidon.config.mp.MpConfigImpl;
import io.helidon.config.mp.SeConfigValue;
import io.helidon.config.spi.ConfigMapper;
import java.time.Instant;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class SeConfig
implements Config {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!\\\\),");
    private static final Pattern ESCAPED_COMMA_PATTERN = Pattern.compile("\\,", 16);
    private final Map<Config.Key, SeConfig> children = new ConcurrentHashMap<Config.Key, SeConfig>();
    private final Config mapper;
    private final Config.Key prefix;
    private final Config.Key key;
    private final Config.Key fullKey;
    private final org.eclipse.microprofile.config.Config delegate;
    private final MpConfigImpl delegateImpl;
    private final String stringKey;
    private final String stringPrefix;

    SeConfig(Config mapper, Config.Key prefix, Config.Key key, Config.Key fullKey, org.eclipse.microprofile.config.Config delegate, MpConfigImpl delegateImpl) {
        this.mapper = mapper;
        this.prefix = prefix;
        this.key = key;
        this.fullKey = fullKey;
        this.delegate = delegate;
        this.stringKey = fullKey.toString();
        this.stringPrefix = prefix.toString();
        this.delegateImpl = delegateImpl;
    }

    SeConfig(Config mapper, org.eclipse.microprofile.config.Config delegate) {
        MpConfigImpl mpConfig;
        this.mapper = mapper;
        this.key = this.prefix = Config.Key.create("");
        this.fullKey = this.prefix;
        this.delegate = delegate;
        this.stringKey = this.prefix.child(this.key).toString();
        this.stringPrefix = this.prefix.toString();
        this.delegateImpl = delegate instanceof MpConfigImpl ? (mpConfig = (MpConfigImpl)delegate) : null;
    }

    @Override
    public Instant timestamp() {
        return Instant.now();
    }

    @Override
    public Config.Key key() {
        return this.key;
    }

    @Override
    public Config root() {
        return new SeConfig(this.mapper, this.prefix, Config.Key.create(""), this.prefix, this.delegate, this.delegateImpl);
    }

    @Override
    public Config get(Config.Key key) {
        return this.children.computeIfAbsent(key, it -> new SeConfig(this.mapper, this.prefix, key, this.fullKey.child(key), this.delegate, this.delegateImpl));
    }

    @Override
    public Config detach() {
        return new SeConfig(this.mapper, this.fullKey, Config.Key.create(""), this.fullKey, this.delegate, this.delegateImpl);
    }

    @Override
    public Config.Type type() {
        boolean isObject = false;
        Iterator it = this.delegate.getPropertyNames().iterator();
        if (this.stringKey.isEmpty()) {
            if (!it.hasNext()) {
                return this.hasValue() ? Config.Type.VALUE : Config.Type.MISSING;
            }
            return Config.Type.OBJECT;
        }
        while (it.hasNext()) {
            String name = (String)it.next();
            if (name.equals(this.stringKey) || !name.startsWith(this.stringKey + ".")) continue;
            isObject = true;
            break;
        }
        if (isObject) {
            return Config.Type.OBJECT;
        }
        if (this.hasValue()) {
            return Config.Type.VALUE;
        }
        return Config.Type.MISSING;
    }

    @Override
    public boolean hasValue() {
        return this.currentValue().isPresent();
    }

    @Override
    public Stream<Config> traverse(Predicate<Config> predicate) {
        return (Stream)this.asNodeList().map(list -> list.stream().filter(predicate).map((? super T node) -> this.traverseSubNodes((Config)node, predicate)).reduce(Stream.empty(), Stream::concat)).orElseThrow(MissingValueException.createSupplier(this.key()));
    }

    @Override
    public <T> T convert(Class<T> type, String value) throws ConfigMappingException {
        try {
            return (T)this.impl().obtainConverter(type).convert(value);
        }
        catch (Exception e) {
            try {
                return this.mapper.convert(type, value);
            }
            catch (ConfigMappingException ignored) {
                throw e;
            }
        }
    }

    @Override
    public <T> ConfigValue<T> as(GenericType<T> genericType) {
        if (genericType.isClass()) {
            return this.as(genericType.rawType());
        }
        return new SeConfigValue<Object>(this, this.key, () -> this.mapper.mapper().map((Config)this, genericType));
    }

    @Override
    public <T> ConfigValue<T> as(Class<T> type) {
        if (this.type() == Config.Type.MISSING) {
            return ConfigValues.empty();
        }
        if (this.impl().getConverter(type).isPresent()) {
            return this.delegate.getOptionalValue(this.stringKey, type).map(ConfigValues::simpleValue).orElseGet(ConfigValues::empty);
        }
        return new SeConfigValue<Object>(this, this.key, () -> this.mapper.mapper().map((Config)this, type));
    }

    @Override
    public <T> ConfigValue<T> as(Function<Config, T> mapper) {
        if (this.type() == Config.Type.MISSING) {
            return ConfigValues.empty();
        }
        return ConfigValues.simpleValue(mapper.apply(this));
    }

    @Override
    public <T> ConfigValue<List<T>> asList(Class<T> type) throws ConfigMappingException {
        if (this.type() == Config.Type.MISSING) {
            return ConfigValues.empty();
        }
        if (Config.class.equals(type)) {
            return this.toNodeList();
        }
        return this.asList(this.stringKey, type);
    }

    @Override
    public <T> ConfigValue<List<T>> asList(Function<Config, T> mapper) throws ConfigMappingException {
        if (this.type() == Config.Type.MISSING) {
            return ConfigValues.empty();
        }
        return this.asNodeList().as((T it) -> it.stream().map(mapper).collect(Collectors.toList()));
    }

    @Override
    public ConfigValue<List<Config>> asNodeList() throws ConfigMappingException {
        if (this.type() == Config.Type.MISSING) {
            return ConfigValues.empty();
        }
        return this.asList(Config.class);
    }

    @Override
    public ConfigValue<Map<String, String>> asMap() throws MissingValueException {
        Config.Type nodeType = this.type();
        if (nodeType == Config.Type.MISSING || nodeType == Config.Type.VALUE) {
            return ConfigValues.empty();
        }
        HashMap children = new HashMap();
        for (String propertyName : this.delegate.getPropertyNames()) {
            if (this.stringKey.isEmpty()) {
                this.delegate.getOptionalValue(propertyName, String.class).ifPresent(it -> children.put(propertyName, it));
                continue;
            }
            if (propertyName.equals(this.stringKey) || !propertyName.startsWith(this.stringKey + ".")) continue;
            String noPrefix = this.stringPrefix.isEmpty() ? propertyName : propertyName.substring(this.stringPrefix.length() + 1);
            this.delegate.getOptionalValue(propertyName, String.class).ifPresent(it -> children.put(noPrefix, it));
        }
        return ConfigValues.simpleValue(children);
    }

    public String toString() {
        return String.valueOf((Object)this.type()) + " " + this.stringKey + " = " + (String)this.currentValue().orElse(null);
    }

    @Override
    public ConfigMapper mapper() {
        return this.mapper.mapper();
    }

    private Stream<Config> traverseSubNodes(Config config, Predicate<Config> predicate) {
        if (this.type() == Config.Type.MISSING) {
            return Stream.of(new Config[0]);
        }
        if (config.type().isLeaf()) {
            return Stream.of(config);
        }
        return (Stream)config.asNodeList().map(list -> list.stream().filter(predicate).map((? super T node) -> this.traverseSubNodes((Config)node, predicate)).reduce(Stream.of(config), Stream::concat)).orElseThrow(MissingValueException.createSupplier(this.key()));
    }

    private <T> ConfigValue<List<T>> toNodeList() {
        Config.Type nodeType = this.type();
        if (nodeType == Config.Type.MISSING || nodeType == Config.Type.VALUE) {
            return ConfigValues.empty();
        }
        LinkedList<Config> result = new LinkedList<Config>();
        HashSet<String> children = new HashSet<String>();
        for (String propertyName : this.delegate.getPropertyNames()) {
            int dot;
            String noSuffix;
            if (this.stringKey.isEmpty()) {
                noSuffix = propertyName;
                dot = noSuffix.indexOf(46);
                if (dot > 0) {
                    noSuffix = noSuffix.substring(0, dot);
                }
                children.add(noSuffix);
                continue;
            }
            if (propertyName.equals(this.stringKey) || !propertyName.startsWith(this.stringKey + ".")) continue;
            noSuffix = propertyName.substring(this.stringKey.length() + 1);
            dot = noSuffix.indexOf(46);
            if (dot > 0) {
                noSuffix = noSuffix.substring(0, dot);
            }
            children.add(noSuffix);
        }
        for (String child : children) {
            result.add(this.get(child));
        }
        return ConfigValues.simpleValue(result);
    }

    private Optional<String> currentValue() {
        return this.delegate.getOptionalValue(this.stringKey, String.class);
    }

    private MpConfigImpl impl() {
        if (null == this.delegateImpl) {
            throw new IllegalStateException("Cannot convert to arbitrary types when the MP Config is not a Helidon implementation");
        }
        return this.delegateImpl;
    }

    private <T> ConfigValue<List<T>> asList(String configKey, Class<T> typeArg) {
        return new SeConfigValue<List<T>>(this, this.key(), () -> this.toList(configKey, typeArg));
    }

    private <T> List<T> toList(String configKey, Class<T> typeArg) {
        Config config;
        Optional optionalValue = this.delegate.getOptionalValue(configKey, String.class);
        if (optionalValue.isPresent()) {
            return this.valueToList(configKey, (String)optionalValue.get(), typeArg);
        }
        String indexedConfigKey = configKey + ".0";
        optionalValue = this.delegate.getOptionalValue(indexedConfigKey, String.class);
        if (optionalValue.isPresent()) {
            LinkedList<T> result = new LinkedList<T>();
            result.add(this.convert(indexedConfigKey, (String)optionalValue.get(), typeArg));
            int i = 1;
            while ((optionalValue = this.delegate.getOptionalValue(indexedConfigKey = configKey + "." + i, String.class)).isPresent()) {
                result.add(this.convert(indexedConfigKey, (String)optionalValue.get(), typeArg));
                ++i;
            }
            return result;
        }
        if (this.get("0").type() == Config.Type.MISSING) {
            throw MissingValueException.create(this.key);
        }
        LinkedList result = new LinkedList();
        int i = 0;
        while ((config = this.get(String.valueOf(i))).type() != Config.Type.MISSING) {
            result.add(config.as((Class)typeArg).get());
            ++i;
        }
        return result;
    }

    private <T> List<T> valueToList(String configKey, String stringValue, Class<T> typeArg) {
        if (stringValue.isEmpty()) {
            return List.of();
        }
        LinkedList<T> result = new LinkedList<T>();
        for (String value : SeConfig.toArray(stringValue)) {
            result.add(this.convert(configKey, value, typeArg));
        }
        return result;
    }

    static String[] toArray(String stringValue) {
        String[] values = SPLIT_PATTERN.split(stringValue, -1);
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            values[i] = ESCAPED_COMMA_PATTERN.matcher(value).replaceAll(Matcher.quoteReplacement(","));
        }
        return values;
    }

    private <T> T convert(String key, String value, Class<T> type) {
        if (null == value) {
            return null;
        }
        if (String.class.equals(type)) {
            return (T)value;
        }
        try {
            return (T)this.impl().getConverter(type).orElseThrow(() -> new IllegalArgumentException("Did not find converter for type " + type.getName() + ", for key " + key)).convert(value);
        }
        catch (Exception e) {
            try {
                return this.mapper.convert(type, value);
            }
            catch (ConfigMappingException ignored) {
                throw e;
            }
        }
    }
}

