/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen;

import jakarta.persistence.spi.PersistenceUnitInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.TypeMirror;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnit;
import org.eclipse.persistence.internal.jpa.modelgen.visitors.ElementVisitor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.server.ServerSession;

public class MetadataMirrorFactory
extends MetadataFactory {
    private ElementVisitor<MetadataClass, MetadataClass> elementVisitor;
    private final Map<String, PersistenceUnit> persistenceUnits;
    private final Map<String, MetadataProject> metadataProjects;
    private final Map<Element, MetadataClass> roundElements = new HashMap<Element, MetadataClass>();
    private final Set<MetadataClass> roundMetadataClasses = new HashSet<MetadataClass>();
    private final Set<Element> processedElements;
    private ProcessingEnvironment processingEnv;

    protected MetadataMirrorFactory(MetadataLogger logger, ClassLoader loader) {
        super(logger, loader);
        this.persistenceUnits = new HashMap<String, PersistenceUnit>();
        this.metadataProjects = new HashMap<String, MetadataProject>();
        this.processedElements = new HashSet<Element>();
    }

    public void addPersistenceUnit(SEPersistenceUnitInfo puInfo, PersistenceUnit persistenceUnit) {
        this.persistenceUnits.put(puInfo.getPersistenceUnitName(), persistenceUnit);
    }

    public MetadataClass getMetadataClass(Element element) {
        MetadataClass metadataClass = this.roundElements.get(element);
        if (metadataClass == null) {
            if (this.isRoundElement(element)) {
                this.m_logger.getSession().getSessionLog().log(3, "processor", "Building metadata class for round element: {0}", new Object[]{element}, false);
                metadataClass = new MetadataClass((MetadataFactory)this, "");
                this.roundElements.put(element, metadataClass);
                this.roundMetadataClasses.add(metadataClass);
                element.accept(this.elementVisitor, metadataClass);
                this.addMetadataClass(metadataClass);
            } else {
                String name = element.toString();
                if (this.metadataClassExists(name)) {
                    return this.getMetadataClass(name);
                }
                if (element instanceof TypeElement || element instanceof TypeParameterElement) {
                    if (element instanceof TypeElement) {
                        this.m_logger.getSession().getSessionLog().log(3, "processor", "Building metadata class for type element: {0}", new Object[]{name}, false);
                        metadataClass = new MetadataClass((MetadataFactory)this, name);
                        this.addMetadataClass(metadataClass);
                        element.accept(this.elementVisitor, metadataClass);
                        this.addMetadataClass(metadataClass);
                    } else {
                        this.m_logger.getSession().getSessionLog().log(3, "processor", "Building type parameter element:  {0}", new Object[]{name}, false);
                        metadataClass = new MetadataClass((MetadataFactory)this, name);
                        this.addMetadataClass(metadataClass);
                        element.accept(this.elementVisitor, metadataClass);
                        this.addMetadataClass(metadataClass);
                    }
                } else {
                    metadataClass = this.getMetadataClass(element.toString());
                }
            }
        }
        return metadataClass;
    }

    public MetadataClass getMetadataClass(String className, boolean isLazy) {
        return this.getMetadataClass(className);
    }

    public MetadataClass getMetadataClass(String className) {
        if (className == null) {
            return null;
        }
        if (!this.metadataClassExists(className)) {
            this.addMetadataClass(new MetadataClass((MetadataFactory)this, className));
        }
        return (MetadataClass)this.getMetadataClasses().get(className);
    }

    public MetadataClass getMetadataClass(TypeMirror typeMirror) {
        Element element = this.processingEnv.getTypeUtils().asElement(typeMirror);
        if (element == null) {
            return this.getMetadataClass(typeMirror.toString());
        }
        return this.getMetadataClass(element);
    }

    public MetadataProject getMetadataProject(SEPersistenceUnitInfo puInfo) {
        if (!this.metadataProjects.containsKey(puInfo.getPersistenceUnitName())) {
            ServerSession session = new ServerSession(new Project(new DatabaseLogin()));
            session.setSessionLog(this.getLogger().getSession().getSessionLog());
            MetadataProject project = new MetadataProject((PersistenceUnitInfo)puInfo, (AbstractSession)session, false, false, false, false, false);
            this.metadataProjects.put(puInfo.getPersistenceUnitName(), project);
            return project;
        }
        return this.metadataProjects.get(puInfo.getPersistenceUnitName());
    }

    public Collection<PersistenceUnit> getPersistenceUnits() {
        return this.persistenceUnits.values();
    }

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnv;
    }

    public Map<Element, MetadataClass> getRoundElements() {
        return this.roundElements;
    }

    public boolean isRoundElement(Element element) {
        return this.roundElements.containsKey(element);
    }

    public boolean isRoundElement(MetadataClass cls) {
        return this.roundMetadataClasses.contains(cls);
    }

    void addProcessed(Element name) {
        this.processedElements.add(name);
    }

    boolean isProcessed(Element name) {
        return this.processedElements.contains(name);
    }

    public void resolveGenericTypes(MetadataClass child, List<String> genericTypes, MetadataClass parent, MetadataDescriptor descriptor) {
    }

    public void setEnvironments(ProcessingEnvironment processingEnvironment, RoundEnvironment roundEnvironment) {
        this.processingEnv = processingEnvironment;
        this.roundElements.clear();
        this.roundMetadataClasses.clear();
        this.processedElements.clear();
        if (this.elementVisitor == null) {
            this.elementVisitor = new ElementVisitor(this.processingEnv);
        }
        for (Element element : roundEnvironment.getRootElements()) {
            if (!element.getKind().isClass()) continue;
            boolean isGenerated = false;
            List<? extends AnnotationMirror> annotationMirrors = element.getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : annotationMirrors) {
                Name qn = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
                if (!"jakarta.annotation.Generated".equals(qn.toString()) && !"jakarta.annotation.processing.Generated".equals(qn.toString())) continue;
                isGenerated = true;
                break;
            }
            if (isGenerated) continue;
            this.roundElements.put(element, null);
        }
        for (Element element : this.roundElements.keySet()) {
            this.getMetadataClass(element);
        }
    }
}

