/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.binding;

import jakarta.enterprise.inject.Vetoed;
import jakarta.mvc.binding.BindingError;
import jakarta.mvc.binding.BindingResult;
import jakarta.mvc.binding.ParamError;
import jakarta.mvc.binding.ValidationError;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Vetoed
public class BindingResultImpl
implements BindingResult {
    private final Set<BindingError> bindingErrors = new LinkedHashSet<BindingError>();
    private final Set<ValidationError> validationErrors = new LinkedHashSet<ValidationError>();
    private boolean consumed;

    public boolean isFailed() {
        this.consumed = true;
        return this.validationErrors.size() > 0 || this.bindingErrors.size() > 0;
    }

    public List<String> getAllMessages() {
        this.consumed = true;
        return Stream.concat(this.bindingErrors.stream(), this.validationErrors.stream()).map(ParamError::getMessage).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public Set<ParamError> getAllErrors() {
        this.consumed = true;
        return Stream.concat(this.bindingErrors.stream(), this.validationErrors.stream()).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    public Set<ParamError> getErrors(String param) {
        Objects.requireNonNull(param, "Parameter name is required");
        this.consumed = true;
        return Stream.concat(this.bindingErrors.stream(), this.validationErrors.stream()).filter(paramError -> Objects.equals(paramError.getParamName(), param)).collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    public void addValidationErrors(Set<ValidationError> validationErrors) {
        this.validationErrors.addAll(validationErrors);
    }

    public void addBindingError(BindingError bindingError) {
        this.bindingErrors.add(bindingError);
    }

    public boolean hasUnconsumedErrors() {
        return !this.consumed && (!this.bindingErrors.isEmpty() || !this.validationErrors.isEmpty());
    }
}

