/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.io.FilteringObjectInputStream;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;

public class MessageManagerMonitor
extends MQMBeanReadOnly {
    private static MBeanParameterInfo[] getMessageInfoSignature;
    private static MBeanOperationInfo[] ops;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getMessageInfo(String destinationType, String destinationName, String messageID, Long startMsgIndex, Long maxNumMsgsRetrieved, Boolean getBody) throws MBeanException {
        Vector<HashMap> msgInfo = new Vector<HashMap>();
        try {
            HashMap destNameType = new HashMap();
            if (destinationName == null || destinationType == null) {
                throw new BrokerException("Destination name and type not specified");
            }
            Destination[] ds = DestinationList.getDestination(null, destinationName, destinationType.equals("q"));
            Destination d = ds[0];
            if (d == null) {
                throw new BrokerException(rb.getString("B4017", destinationName));
            }
            if (getBody == null) {
                getBody = Boolean.FALSE;
            }
            if (messageID != null) {
                d.load();
                SysMessageID sysMsgID = SysMessageID.get(messageID);
                PacketReference pr = this.getPacketReference(sysMsgID);
                if (pr == null) throw new BrokerException("Could not locate message " + messageID + " in destination " + destinationName);
                HashMap h = this.constructMessageInfo(sysMsgID, getBody, destNameType);
                msgInfo.add(h);
                return msgInfo;
            } else {
                SysMessageID[] sysMsgIDs = d.getSysMessageIDs(startMsgIndex, maxNumMsgsRetrieved);
                for (int i = 0; i < sysMsgIDs.length; ++i) {
                    HashMap h = this.constructMessageInfo(sysMsgIDs[i], getBody, destNameType);
                    msgInfo.add(h);
                }
            }
            return msgInfo;
        }
        catch (Exception e) {
            this.handleOperationException("getMessageInfo", e);
        }
        return msgInfo;
    }

    @Override
    public String getMBeanName() {
        return "MessageManagerMonitor";
    }

    @Override
    public String getMBeanDescription() {
        return "Monitoring MBean for Message Manager";
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return null;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    private HashMap constructMessageInfo(SysMessageID sysMsgID, boolean getBody, HashMap destNameType) throws BrokerException {
        Hashtable msgProps;
        HashMap<String, Object> h = new HashMap<String, Object>();
        PacketReference pr = this.getPacketReference(sysMsgID);
        Packet pkt = pr.getPacket();
        HashMap msgHeaders = pr.getHeaders();
        String corrID = pkt.getCorrelationID();
        String destType = "q";
        byte[] b = null;
        h.put("CorrelationID", corrID);
        if (corrID != null) {
            try {
                b = corrID.getBytes("UTF8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        h.put("CorrelationIDAsBytes", b);
        h.put("DeliveryMode", pkt.getPersistent() ? Integer.valueOf(2) : Integer.valueOf(1));
        h.put("DestinationName", pkt.getDestination());
        destType = pkt.getIsQueue() ? "q" : "t";
        h.put("DestinationType", destType);
        h.put("Expiration", pkt.getExpiration());
        h.put("MessageID", msgHeaders.get("JMSMessageID"));
        h.put("Priority", pkt.getPriority());
        h.put("Redelivered", pkt.getRedelivered());
        String replyToDestName = pkt.getReplyTo();
        if (replyToDestName != null) {
            Boolean isQ;
            boolean destFound = false;
            boolean isQueue = true;
            if (destNameType != null && (isQ = (Boolean)destNameType.get(replyToDestName)) != null) {
                isQueue = isQ;
                destFound = true;
            }
            if (!destFound) {
                try {
                    Destination[] ds = DestinationList.findDestination(null, replyToDestName, true);
                    Destination queue = ds[0];
                    ds = DestinationList.findDestination(null, replyToDestName, false);
                    Destination topic = ds[0];
                    if (queue != null && topic != null) {
                        String errMsg = "Cannot determine type of ReplyTo destination. There is a topic and queue with the name: " + replyToDestName;
                        throw new BrokerException(errMsg);
                    }
                    if (queue != null) {
                        destFound = true;
                        isQueue = true;
                    } else if (topic != null) {
                        destFound = true;
                        isQueue = false;
                    }
                    if (destFound) {
                        destNameType.put(replyToDestName, isQueue);
                    }
                }
                catch (Exception e) {
                    String errMsg = "Caught exception while determining ReplyTo destination type";
                    throw new BrokerException(errMsg);
                }
            }
            h.put("ReplyToDestinationName", replyToDestName);
            if (destFound) {
                destType = isQueue ? "q" : "t";
                h.put("ReplyToDestinationType", destType);
            }
        }
        h.put("Timestamp", pkt.getTimestamp());
        h.put("Type", pkt.getMessageType());
        try {
            msgProps = pr.getProperties();
        }
        catch (Exception e) {
            msgProps = null;
        }
        h.put("MessageProperties", msgProps);
        int packetType = pr.getPacket().getPacketType();
        h.put("MessageBodyType", packetType);
        if (getBody) {
            ByteBuffer bb = pr.getPacket().getMessageBodyByteBuffer();
            byte[] msgBody = null;
            if (bb.hasArray()) {
                msgBody = bb.array();
            }
            switch (packetType) {
                case 1: {
                    try {
                        String textMsg = new String(msgBody, "UTF8");
                        h.put("MessageBody", textMsg);
                        break;
                    }
                    catch (Exception e) {
                        String errMsg = "Caught exception while creating text message body";
                        throw new BrokerException(errMsg);
                    }
                }
                case 2: 
                case 4: {
                    h.put("MessageBody", msgBody);
                    break;
                }
                case 3: {
                    ByteArrayInputStream byteArrayInputStream;
                    try {
                        byteArrayInputStream = new ByteArrayInputStream(msgBody);
                        FilteringObjectInputStream objectInputStream = new FilteringObjectInputStream(byteArrayInputStream);
                        HashMap mapMsg = (HashMap)objectInputStream.readObject();
                        h.put("MessageBody", mapMsg);
                        break;
                    }
                    catch (Exception e) {
                        String errMsg = "Caught exception while creating map message body";
                        throw new BrokerException(errMsg);
                    }
                }
                case 5: {
                    ByteArrayInputStream byteArrayInputStream;
                    try {
                        byteArrayInputStream = new ByteArrayInputStream(msgBody);
                        FilteringObjectInputStream objectInputStream = new FilteringObjectInputStream(byteArrayInputStream);
                        Object objMsg = objectInputStream.readObject();
                        h.put("MessageBody", objMsg);
                        break;
                    }
                    catch (Exception e) {
                        String errMsg = "Caught exception while creating object message body";
                        throw new BrokerException(errMsg);
                    }
                }
                default: {
                    String errMsg = "Unsupported message type for GET_MESSAGES handler: " + packetType;
                    throw new BrokerException(errMsg);
                }
            }
        }
        return h;
    }

    private PacketReference getPacketReference(SysMessageID sysMsgID) {
        Globals.getDestinationList();
        return DestinationList.get(null, sysMsgID);
    }

    static {
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[6];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("destinationType", String.class.getName(), mbr.getString("MB1187"));
        mBeanParameterInfoArray[1] = new MBeanParameterInfo("destinationName", String.class.getName(), mbr.getString("MB1188"));
        mBeanParameterInfoArray[2] = new MBeanParameterInfo("messageID", String.class.getName(), "Message ID");
        mBeanParameterInfoArray[3] = new MBeanParameterInfo("startMsgIndex", Long.class.getName(), "Start Message Index");
        mBeanParameterInfoArray[4] = new MBeanParameterInfo("maxNumMsgsRetrieved", Long.class.getName(), "Maximum Number of Messages Retrieved");
        mBeanParameterInfoArray[5] = new MBeanParameterInfo("getBody", Boolean.class.getName(), "Get Body");
        getMessageInfoSignature = mBeanParameterInfoArray;
        ops = new MBeanOperationInfo[]{new MBeanOperationInfo("getMessageInfo", "Get information on messages from a destination", getMessageInfoSignature, Vector.class.getName(), 0)};
    }
}

