/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.event.Shutdown;
import jakarta.enterprise.inject.Any;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentMap;
import org.jboss.weld.Container;
import org.jboss.weld.ContainerState;
import org.jboss.weld.bootstrap.BeanDeploymentModule;
import org.jboss.weld.bootstrap.BeanDeploymentModules;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.events.BeforeShutdownImpl;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.context.ApplicationContext;
import org.jboss.weld.context.SingletonContext;
import org.jboss.weld.event.ContextEvent;
import org.jboss.weld.manager.BeanManagerImpl;

public class WeldRuntime {
    private BeanManagerImpl deploymentManager;
    private ConcurrentMap<BeanDeploymentArchive, BeanManagerImpl> bdaToBeanManagerMap;
    private String contextId;

    public WeldRuntime(String contextId, BeanManagerImpl deploymentManager, ConcurrentMap<BeanDeploymentArchive, BeanManagerImpl> bdaToBeanManagerMap) {
        this.contextId = contextId;
        this.deploymentManager = deploymentManager;
        this.bdaToBeanManagerMap = bdaToBeanManagerMap;
    }

    public BeanManagerImpl getManager(BeanDeploymentArchive beanDeploymentArchive) {
        return (BeanManagerImpl)this.bdaToBeanManagerMap.get(beanDeploymentArchive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            Environment env = Container.getEnvironment();
            if (env != null && env.automaticallyHandleStartupShutdownEvents()) {
                this.fireEventForNonWebModules((Type)((Object)Shutdown.class), new Shutdown(), Any.Literal.INSTANCE);
            }
            this.fireEventForNonWebModules((Type)((Object)Object.class), ContextEvent.APPLICATION_BEFORE_DESTROYED, BeforeDestroyed.Literal.APPLICATION);
            ((ApplicationContext)this.deploymentManager.instance().select(ApplicationContext.class, new Annotation[0]).get()).invalidate();
            ((SingletonContext)this.deploymentManager.instance().select(SingletonContext.class, new Annotation[0]).get()).invalidate();
        }
        catch (Throwable throwable) {
            this.fireEventForNonWebModules((Type)((Object)Object.class), ContextEvent.APPLICATION_DESTROYED, Destroyed.Literal.APPLICATION);
            try {
                BeforeShutdownImpl.fire(this.deploymentManager);
            }
            finally {
                Container container = Container.instance(this.contextId);
                container.setState(ContainerState.SHUTDOWN);
                container.cleanup();
            }
            throw throwable;
        }
        this.fireEventForNonWebModules((Type)((Object)Object.class), ContextEvent.APPLICATION_DESTROYED, Destroyed.Literal.APPLICATION);
        try {
            BeforeShutdownImpl.fire(this.deploymentManager);
        }
        finally {
            Container container = Container.instance(this.contextId);
            container.setState(ContainerState.SHUTDOWN);
            container.cleanup();
        }
    }

    private void fireEventForNonWebModules(Type eventType, Object event, Annotation ... qualifiers) {
        try {
            BeanDeploymentModules modules = this.deploymentManager.getServices().get(BeanDeploymentModules.class);
            if (modules != null) {
                for (BeanDeploymentModule module : modules) {
                    if (module.isWebModule()) continue;
                    module.fireEvent(eventType, event, qualifiers);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fireEventForAllModules(Type eventType, Object event, Annotation ... qualifiers) {
        try {
            BeanDeploymentModules modules = this.deploymentManager.getServices().get(BeanDeploymentModules.class);
            if (modules != null) {
                for (BeanDeploymentModule module : modules) {
                    module.fireEvent(eventType, event, qualifiers);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

