/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.ActionManager;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

class ExplorerMouseAdapter
extends MouseAdapter {
    private ActionManager actionMgr;
    private JTree tree;

    ExplorerMouseAdapter(ActionManager actionMgr, JTree tree) {
        this.tree = tree;
        this.actionMgr = actionMgr;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.doPopup(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.doPopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.doPopup(e);
    }

    private void doPopup(MouseEvent e) {
        int selRow = this.tree.getRowForLocation(e.getX(), e.getY());
        TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
        if (!e.isPopupTrigger()) {
            return;
        }
        if (selRow != -1) {
            Object obj = selPath.getLastPathComponent();
            if (!(obj instanceof ConsoleObj)) {
                return;
            }
            ConsoleObj conObj = (ConsoleObj)obj;
            this.tree.addSelectionPath(selPath);
            JPopupMenu popup = conObj.getExporerPopupMenu(this.actionMgr);
            if (popup != null) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

