/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.io.JMSPacket;
import com.sun.messaging.jmq.util.io.ClassFilter;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import jakarta.jms.JMSException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.ObjectMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;

public class DirectObjectPacket
extends DirectPacket
implements ObjectMessage {
    private byte[] messageBody = null;
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private ObjectOutputStream objectOutputStream = null;
    private ByteArrayInputStream byteArrayInputStream = null;
    private ObjectInputStream objectInputStream = null;
    private static final String _className = "com.sun.messaging.jms.ra.DirectObjectPacket";

    public DirectObjectPacket(DirectSession ds, Serializable obj) throws JMSException {
        super(ds);
        if (_logFINE) {
            Object[] params = new Object[3];
            params[0] = ds;
            params[2] = obj;
            _loggerOC.entering(_className, "constructor()", params);
        }
        if (obj != null) {
            this.setObject(obj);
        }
    }

    public DirectObjectPacket(JMSPacket jmsPacket, long consumerId, DirectSession ds) throws JMSException {
        super(jmsPacket, consumerId, ds);
        this._getMessageBodyFromPacket();
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.messageBody = null;
    }

    public Serializable getObject() throws JMSException {
        String methodName = "getObject()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName);
        }
        Serializable object = null;
        if (this.messageBody != null) {
            try {
                this.byteArrayInputStream = new ByteArrayInputStream(this.messageBody);
                this.objectInputStream = new ObjectInputStreamWithContextLoader(this.byteArrayInputStream);
                object = (Serializable)this.objectInputStream.readObject();
                return object;
            }
            catch (Exception e) {
                Throwable jmse = null;
                String eMsg = "MQJMSRA_DM4001: :Exception:ObjectMessage." + methodName + "DeSerializing object::message=" + e.getMessage();
                _loggerJM.severe(eMsg);
                jmse = e instanceof InvalidClassException || e instanceof OptionalDataException || e instanceof ClassNotFoundException ? new MessageFormatException(eMsg) : new JMSException(eMsg);
                jmse.initCause((Throwable)e);
                throw jmse;
            }
        }
        return null;
    }

    public void setObject(Serializable object) throws JMSException {
        String methodName = "setObject()";
        if (_logFINE) {
            _loggerJM.fine("MQJMSRA_DM1101: " + methodName);
        }
        this.checkForReadOnlyMessageBody(methodName);
        try {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.objectOutputStream = new ObjectOutputStream(this.byteArrayOutputStream);
            this.objectOutputStream.writeObject(object);
            this.objectOutputStream.flush();
            this.messageBody = this.byteArrayOutputStream.toByteArray();
            this.objectOutputStream.close();
            this.byteArrayOutputStream.close();
        }
        catch (Exception ex) {
            String errMsg = "MQJMSRA_DM4001: :Exception:ObjectMessage." + methodName + "object=" + String.valueOf(object) + ":message=" + ex.getMessage();
            _loggerJM.severe(errMsg);
            JMSException jmse = new JMSException(errMsg);
            jmse.initCause((Throwable)ex);
            throw jmse;
        }
    }

    @Override
    protected void _setDefaultValues() throws JMSException {
        super._setDefaultValues();
        this.pkt.setPacketType(5);
    }

    @Override
    protected void _setBodyToPacket() throws JMSException {
        if (this.messageBody != null) {
            try {
                super._setMessageBodyOfPacket(this.messageBody);
            }
            catch (Exception ex) {
                String errMsg = "MQJMSRA_DM4001: :ERROR setting ObjectMessage body:Exception=" + ex.getMessage();
                _loggerJM.severe(errMsg);
                JMSException jmse = new JMSException(errMsg);
                jmse.initCause((Throwable)ex);
                throw jmse;
            }
        }
    }

    @Override
    protected void _getMessageBodyFromPacket() throws JMSException {
        this.messageBody = super._getMessageBodyByteArray();
    }

    static class ObjectInputStreamWithContextLoader
    extends ObjectInputStream {
        ObjectInputStreamWithContextLoader(InputStream in) throws IOException, StreamCorruptedException {
            super(in);
        }

        protected Class resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
            String className = classDesc.getName();
            if (className != null && !className.isEmpty() && ClassFilter.isBlackListed(className)) {
                throw new InvalidClassException("Unauthorized deserialization attempt", classDesc.getName());
            }
            try {
                return super.resolveClass(classDesc);
            }
            catch (ClassNotFoundException e) {
                ClassLoader ctxcl = null;
                try {
                    ctxcl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException se) {
                    throw new ClassNotFoundException(e.getMessage() + "; " + se.getMessage());
                }
                if (ctxcl == null) {
                    throw e;
                }
                return Class.forName(classDesc.getName(), false, ctxcl);
            }
        }
    }
}

