/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.enterprise.container.common.spi.ManagedBeanManager;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.security.webservices.client.ClientPipeCloser;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManagerFactory;
import jakarta.transaction.TransactionManager;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import javax.swing.SwingUtilities;
import org.apache.naming.resources.DirContextURLStreamHandlerFactory;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.appclient.client.acc.AppClientContainerBuilder;
import org.glassfish.appclient.client.acc.AppClientContainerSecurityHelper;
import org.glassfish.appclient.client.acc.AppClientInfo;
import org.glassfish.appclient.client.acc.Launchable;
import org.glassfish.appclient.client.acc.ProviderContainerContractInfoImpl;
import org.glassfish.appclient.client.acc.TransformingClassLoader;
import org.glassfish.appclient.client.acc.config.AuthRealm;
import org.glassfish.appclient.client.acc.config.ClientCredential;
import org.glassfish.appclient.client.acc.config.MessageSecurityConfig;
import org.glassfish.appclient.client.acc.config.Property;
import org.glassfish.appclient.client.acc.config.TargetServer;
import org.glassfish.embeddable.client.ApplicationClientContainer;
import org.glassfish.embeddable.client.UserError;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.main.jdke.props.SystemProperties;
import org.glassfish.persistence.jpa.PersistenceUnitLoader;
import org.glassfish.persistence.jpa.ProviderContainerContractInfo;
import org.jvnet.hk2.annotations.Service;
import org.omg.CORBA.NO_PERMISSION;
import org.xml.sax.SAXException;

@Service
@PerLookup
public class AppClientContainer
implements ApplicationClientContainer {
    public static final String APPCLIENT_RETAIN_TEMP_FILES_PROPERTYNAME = "com.sun.aas.jws.retainTempFiles";
    private static final Logger logger = LogDomains.getLogger(AppClientContainer.class, (String)"jakarta.enterprise.system.container.appclient");
    private static final Logger _logger = Logger.getLogger(AppClientContainer.class.getName());
    @Inject
    private AppClientContainerSecurityHelper appClientContainerSecurityHelper;
    @Inject
    private InjectionManager injectionManager;
    @Inject
    private InvocationManager invocationManager;
    @Inject
    private ComponentEnvManager componentEnvManager;
    @Inject
    private ConnectorRuntime connectorRuntime;
    @Inject
    private ServiceLocator habitat;
    private Cleanup cleanup;
    private volatile State state;
    private TransformingClassLoader classLoader = (TransformingClassLoader)((Object)Thread.currentThread().getContextClassLoader());
    private Launchable client;
    private String componentId;

    public static Builder newBuilder(TargetServer[] targetServers) {
        return new AppClientContainerBuilder(targetServers);
    }

    private AppClientContainer() {
        this.state = State.INSTANTIATED;
    }

    void prepareSecurity(TargetServer[] targetServers, List<MessageSecurityConfig> msgSecConfigs, Properties containerProperties, ClientCredential clientCredential, CallbackHandler callerSuppliedCallbackHandler, boolean isTextAuth) throws ReflectiveOperationException, InjectionException, IOException, SAXException {
        this.appClientContainerSecurityHelper.init(targetServers, msgSecConfigs, containerProperties, clientCredential, callerSuppliedCallbackHandler, (ClassLoader)((Object)this.classLoader), this.client.getDescriptor((URLClassLoader)((Object)this.classLoader)), isTextAuth);
    }

    public void prepare(Instrumentation inst) throws Exception, UserError {
        this.completePreparation(inst);
    }

    void setClient(Launchable client) throws ClassNotFoundException {
        this.client = client;
        ClientMainClassSetting.setMainClass(client.getMainClass());
    }

    protected Class<?> loadClass(String className) throws ClassNotFoundException {
        return Class.forName(className, true, (ClassLoader)((Object)this.classLoader));
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private void completePreparation(Instrumentation inst) throws Exception, UserError {
        if (this.state != State.INSTANTIATED) {
            throw new IllegalStateException("Expected state was " + String.valueOf((Object)State.INSTANTIATED) + ", but current state was " + String.valueOf((Object)this.state));
        }
        this.client.validateDescriptor();
        ApplicationClientDescriptor desc = this.client.getDescriptor((URLClassLoader)((Object)this.classLoader));
        this.componentId = this.componentEnvManager.bindToComponentNamespace((JndiNameEnvironment)desc);
        this.cleanup = Cleanup.arrangeForShutdownCleanup(logger, this.habitat, desc);
        this.cleanup.setInjectionManager(this.injectionManager, ClientMainClassSetting.clientMainClass);
        Collection referencedPUs = desc.findReferencedPUs();
        if (referencedPUs != null && !referencedPUs.isEmpty()) {
            ProviderContainerContractInfoImpl pcci = new ProviderContainerContractInfoImpl((TransformingClassLoader)((Object)this.getClassLoader()), inst, this.client.getAnchorDir(), this.connectorRuntime);
            for (PersistenceUnitDescriptor puDesc : referencedPUs) {
                PersistenceUnitLoader pul = new PersistenceUnitLoader(puDesc, (ProviderContainerContractInfo)pcci);
                desc.addEntityManagerFactory(puDesc.getName(), pul.getEntityManagerFactory());
            }
            this.cleanup.setEMFs(pcci.emfs());
        }
        this.cleanup.setConnectorRuntime(this.connectorRuntime);
        AppClientContainer.prepareURLStreamHandling();
        SystemProperties.setProperty((String)"jakarta.xml.ws.spi.Provider", (String)"com.sun.xml.ws.spi.ProviderImpl", (boolean)true);
        ManagedBeanManager managedBeanManager = (ManagedBeanManager)this.habitat.getService(ManagedBeanManager.class, new Annotation[0]);
        managedBeanManager.loadManagedBeans(desc.getApplication());
        this.cleanup.setManagedBeanManager(managedBeanManager);
        this.resolveMainMethod();
        this.state = State.PREPARED;
    }

    public void launch(String[] args) throws UserError {
        if (this.state != State.PREPARED) {
            throw new IllegalStateException("Unexpected state. Expected " + String.valueOf((Object)State.PREPARED) + ", actual is " + String.valueOf((Object)this.state));
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this.classLoader));
        try {
            Method mainMethod = this.resolveMainMethod();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Current thread's classloader: " + String.valueOf(Thread.currentThread().getContextClassLoader()));
            }
            mainMethod.invoke(null, new Object[]{args});
            this.state = State.STARTED;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof UserError) {
                throw (UserError)e.getCause();
            }
            throw new IllegalStateException("Launch failed.", e.getCause());
        }
        catch (Exception e) {
            throw new IllegalStateException("Launch failed.", e);
        }
        finally {
            this.cleanupWhenSafe();
        }
    }

    private boolean isEDTRunning() {
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        logger.fine("Checking for EDT thread...");
        for (Map.Entry<Thread, StackTraceElement[]> entry : threads.entrySet()) {
            StackTraceElement last;
            logger.log(Level.FINE, "  {0}", entry.getKey().toString());
            StackTraceElement[] frames = entry.getValue();
            if (frames.length > 0 && (last = frames[frames.length - 1]).getClassName().equals("java.awt.EventDispatchThread") && last.getMethodName().equals("run")) {
                logger.log(Level.FINE, "Thread {0} seems to be the EDT", entry.getKey().toString());
                return true;
            }
            logger.fine("Did not recognize any thread as the EDT");
        }
        return false;
    }

    private void cleanupWhenSafe() {
        if (this.isEDTRunning()) {
            AtomicReference edt = new AtomicReference();
            try {
                SwingUtilities.invokeAndWait(() -> edt.set(Thread.currentThread()));
                ((Thread)edt.get()).join();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Waiting for Swing thread failed.", e);
            }
        }
        this.stop();
    }

    private Method resolveMainMethod() throws UserError, ReflectiveOperationException, IOException, SAXException, InjectionException {
        Class<?> mainClass = ClientMainClassSetting.getClientMainClass((ClassLoader)((Object)this.classLoader), this.injectionManager, this.invocationManager, this.componentId, this, this.client.getDescriptor((URLClassLoader)((Object)this.classLoader)));
        Method mainMethod = mainClass.getMethod("main", String[].class);
        int modifiers = mainMethod.getModifiers();
        if (!Modifier.isPublic(modifiers) || !Modifier.isStatic(modifiers)) {
            String err = MessageFormat.format(logger.getResourceBundle().getString("appclient.notPublicOrNotStatic"), null);
            throw new NoSuchMethodException(err);
        }
        if (!mainMethod.getReturnType().equals(Void.TYPE)) {
            String err = MessageFormat.format(logger.getResourceBundle().getString("appclient.notVoid"), null);
            throw new NoSuchMethodException(err);
        }
        return mainMethod;
    }

    public void stop() {
        if (this.state == State.STOPPED) {
            return;
        }
        this.cleanup.start();
        this.state = State.STOPPED;
    }

    public void setClientMainClassName(String clientMainClassName) {
        ClientMainClassSetting.setMainClassName(clientMainClassName);
    }

    public void setClientMainClass(Class<?> clientMainClass) {
        ClientMainClassSetting.setMainClass(clientMainClass);
    }

    private static void prepareURLStreamHandling() {
        URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)new DirContextURLStreamHandlerFactory());
    }

    static enum State {
        INSTANTIATED,
        PREPARED,
        STARTED,
        STOPPED;

    }

    static class ClientMainClassSetting {
        private static String clientMainClassName;
        private static Class<?> clientMainClass;
        private static boolean isInjected;

        ClientMainClassSetting() {
        }

        static void setMainClassName(String name) {
            clientMainClassName = name;
            clientMainClass = null;
        }

        static void setMainClass(Class<?> cl) {
            clientMainClass = cl;
            clientMainClassName = null;
        }

        static Class<?> getClientMainClass(ClassLoader loader, InjectionManager injectionManager, InvocationManager invocationManager, String componentId, AppClientContainer container, ApplicationClientDescriptor acDesc) throws ClassNotFoundException, UserError, InjectionException {
            if (isInjected) {
                return clientMainClass;
            }
            if (clientMainClass == null) {
                if (clientMainClassName == null) {
                    throw new IllegalStateException("neither client main class nor its class name has been set");
                }
                clientMainClass = Class.forName(clientMainClassName, true, loader);
                logger.log(Level.FINE, "Loaded client main class {0}", clientMainClassName);
            }
            ComponentInvocation ci = new ComponentInvocation(componentId, ComponentInvocation.ComponentInvocationType.APP_CLIENT_INVOCATION, (Object)container, acDesc.getApplication().getAppName(), acDesc.getModuleName());
            invocationManager.preInvoke(ci);
            clientMainClass = ClientMainClassSetting.injectMainClass(injectionManager, acDesc, container);
            isInjected = true;
            return clientMainClass;
        }

        private static Class<?> injectMainClass(InjectionManager injectionManager, ApplicationClientDescriptor acDesc, AppClientContainer container) throws UserError, InjectionException {
            int retriesLeft = Integer.getInteger("org.glassfish.appclient.acc.maxLoginRetries", 3);
            while (true) {
                try {
                    injectionManager.injectClass(clientMainClass, (JndiNameEnvironment)acDesc);
                    return clientMainClass;
                }
                catch (InjectionException e) {
                    if (container.appClientContainerSecurityHelper.isLoginCancelled()) {
                        throw new UserError(logger.getResourceBundle().getString("appclient.userCanceledAuth"));
                    }
                    if (ClientMainClassSetting.isCausedByCorbaNoPermission(e)) {
                        container.appClientContainerSecurityHelper.clearClientSecurityContext();
                        if (retriesLeft == 0) {
                            throw new UserError(logger.getResourceBundle().getString("appclient.noPermission"));
                        }
                        --retriesLeft;
                        continue;
                    }
                    if (e.getCause() instanceof NamingException) {
                        String message = ClientMainClassSetting.toMessage((NamingException)e.getCause());
                        throw new UserError(message, (Throwable)e);
                    }
                    throw e;
                }
                break;
            }
        }

        private static String toMessage(NamingException e) {
            String expl = e.getExplanation();
            return MessageFormat.format(logger.getResourceBundle().getString("appclient.RemoteAuthError"), expl);
        }

        private static boolean isCausedByCorbaNoPermission(Throwable t) {
            while (t != null) {
                if (t instanceof NO_PERMISSION) {
                    return true;
                }
                t = t.getCause();
            }
            return false;
        }
    }

    private static class Cleanup
    implements Runnable {
        private AppClientInfo appClientInfo = null;
        private boolean cleanedUp = false;
        private InjectionManager injectionMgr = null;
        private ApplicationClientDescriptor appClient = null;
        private Class cls = null;
        private final Logger logger;
        private Thread cleanupThread = null;
        private Collection<EntityManagerFactory> emfs = null;
        private final ServiceLocator habitat;
        private ConnectorRuntime connectorRuntime;
        private ManagedBeanManager managedBeanMgr;

        static Cleanup arrangeForShutdownCleanup(Logger logger, ServiceLocator habitat, ApplicationClientDescriptor appDesc) {
            Cleanup cu = new Cleanup(logger, habitat, appDesc);
            cu.enable();
            return cu;
        }

        private Cleanup(Logger logger, ServiceLocator habitat, ApplicationClientDescriptor appDesc) {
            this.logger = logger;
            this.habitat = habitat;
            this.appClient = appDesc;
        }

        void setAppClientInfo(AppClientInfo info) {
            this.appClientInfo = info;
        }

        void setInjectionManager(InjectionManager injMgr, Class cls) {
            this.injectionMgr = injMgr;
            this.cls = cls;
        }

        void setManagedBeanManager(ManagedBeanManager mgr) {
            this.managedBeanMgr = mgr;
        }

        void setEMFs(Collection<EntityManagerFactory> emfs) {
            this.emfs = emfs;
        }

        void setConnectorRuntime(ConnectorRuntime connectorRuntime) {
            this.connectorRuntime = connectorRuntime;
        }

        void enable() {
            this.cleanupThread = new Thread((Runnable)this, "Cleanup");
            Runtime.getRuntime().addShutdownHook(this.cleanupThread);
        }

        void disable() {
            Runtime.getRuntime().removeShutdownHook(this.cleanupThread);
        }

        void start() {
            this.disable();
            this.run();
        }

        @Override
        public void run() {
            this.logger.fine("Clean-up starting");
            _logger.fine("Clean-up starting");
            this.cleanUp();
            this.logger.fine("Clean-up complete");
            _logger.fine("Clean-up complete");
        }

        void cleanUp() {
            if (!this.cleanedUp) {
                this.cleanupManagedBeans();
                this.cleanupEMFs();
                this.cleanupInfo();
                this.cleanupInjection();
                this.cleanupServiceReferences();
                this.cleanupTransactions();
                this.cleanupConnectorRuntime();
                this.cleanedUp = true;
            }
        }

        private void cleanupEMFs() {
            try {
                if (this.emfs != null) {
                    for (EntityManagerFactory emf : this.emfs) {
                        emf.close();
                    }
                    this.emfs.clear();
                    this.emfs = null;
                }
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "cleanupEMFs", t);
            }
        }

        private void cleanupInfo() {
            try {
                if (this.appClientInfo != null) {
                    this.appClientInfo.close();
                }
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "cleanupInfo", t);
            }
        }

        private void cleanupInjection() {
            try {
                if (this.injectionMgr != null) {
                    this.injectionMgr.invokeClassPreDestroy(this.cls, (JndiNameEnvironment)this.appClient);
                    this.injectionMgr = null;
                }
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "cleanupInjection", t);
            }
        }

        private void cleanupManagedBeans() {
            try {
                if (this.managedBeanMgr != null) {
                    this.managedBeanMgr.unloadManagedBeans(this.appClient.getApplication());
                }
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "cleanupManagedBeans", t);
            }
        }

        private void cleanupServiceReferences() {
            try {
                if (this.appClient != null && this.appClient.getServiceReferenceDescriptors() != null) {
                    for (Object desc : this.appClient.getServiceReferenceDescriptors()) {
                        ClientPipeCloser.getInstance().cleanupClientPipe((ServiceReferenceDescriptor)desc);
                    }
                }
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "cleanupServiceReferences", t);
            }
        }

        private void cleanupTransactions() {
            try {
                TransactionManager txmgr;
                ServiceHandle inhabitant = this.habitat.getServiceHandle(TransactionManager.class, new Annotation[0]);
                if (inhabitant != null && inhabitant.isActive() && ((txmgr = (TransactionManager)inhabitant.getService()).getStatus() == 0 || txmgr.getStatus() == 1)) {
                    txmgr.rollback();
                }
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "cleanupTransactions", t);
            }
        }

        private void cleanupConnectorRuntime() {
            try {
                if (this.connectorRuntime != null) {
                    this.connectorRuntime.cleanUpResourcesAndShutdownAllActiveRAs();
                    this.connectorRuntime = null;
                }
            }
            catch (Throwable t) {
                this.logger.log(Level.SEVERE, "cleanupConnectorRuntime", t);
            }
        }
    }

    public static interface Builder {
        public AppClientContainer newContainer(URI var1) throws Exception, UserError;

        public AppClientContainer newContainer(URI var1, CallbackHandler var2, String var3, String var4) throws Exception, UserError;

        public AppClientContainer newContainer(URI var1, CallbackHandler var2, String var3, String var4, boolean var5) throws Exception, UserError;

        public AppClientContainer newContainer(Class var1) throws Exception, UserError;

        public TargetServer[] getTargetServers();

        public Builder addMessageSecurityConfig(MessageSecurityConfig var1);

        public List<MessageSecurityConfig> getMessageSecurityConfig();

        public Builder authRealm(String var1);

        public AuthRealm getAuthRealm();

        public Builder clientCredentials(String var1, char[] var2);

        public ClientCredential getClientCredential();

        public Builder clientCredentials(String var1, char[] var2, String var3);

        public Builder containerProperties(Properties var1);

        public Builder containerProperties(List<Property> var1);

        public Properties getContainerProperties();

        public Builder logger(Logger var1);

        public Logger getLogger();

        public Builder sendPassword(boolean var1);

        public boolean getSendPassword();
    }
}

