/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms;

import com.sun.messaging.bridge.api.FaultInjection;
import com.sun.messaging.bridge.api.MessageTransformer;
import com.sun.messaging.bridge.service.jms.AutoDestination;
import com.sun.messaging.bridge.service.jms.EventListener;
import com.sun.messaging.bridge.service.jms.EventNotifier;
import com.sun.messaging.bridge.service.jms.JMSBridge;
import com.sun.messaging.bridge.service.jms.Link;
import com.sun.messaging.bridge.service.jms.PooledConnection;
import com.sun.messaging.bridge.service.jms.Refable;
import com.sun.messaging.bridge.service.jms.SharedConnection;
import com.sun.messaging.bridge.service.jms.resources.JMSBridgeResources;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.XAConnectionFactory;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DMQ {
    private Logger _logger = null;
    private Refable _cf = null;
    private Object _dest = null;
    private MessageProducer _producer = null;
    private Session _session = null;
    private Connection _conn = null;
    private Properties _dmqAttrs = null;
    private Properties _dmqProps = null;
    private JMSBridge _parent = null;
    private boolean _stayConnected = true;
    private long _timeToLive = 0L;
    private int _maxSendAttempts = 1;
    private long _sendInterval = 5000L;
    private DMQState _state = DMQState.UNINITIALIZED;
    private String _name = null;
    private boolean _connException = false;
    private String _providerName = null;
    private EventNotifier _notifier = null;
    private MessageTransformer<Message, Message> _msgTransformer = null;
    private FaultInjection _fi = FaultInjection.getInjection();
    private static JMSBridgeResources _jbr = JMSBridge.getJMSBridgeResources();

    public synchronized void init(Properties dmqAttrs, Properties dmqProps, JMSBridge parent) throws Exception {
        String cn;
        this._dmqAttrs = dmqAttrs;
        this._dmqProps = dmqProps;
        this._parent = parent;
        this._notifier = parent._notifier;
        if (this._dest == null || this._cf == null) {
            throw new IllegalStateException("DMQ information unknown !");
        }
        if (this._logger == null) {
            throw new IllegalStateException("No logger set for dmq " + String.valueOf(this));
        }
        if (this._cf instanceof XAConnectionFactory) {
            JMSBridgeResources jMSBridgeResources = JMSBridge.getJMSBridgeResources();
            JMSBridge.getJMSBridgeResources();
            throw new IllegalArgumentException(jMSBridgeResources.getKString("BSJ4004", "XAConnectionFactory"));
        }
        Integer.parseInt(this._dmqAttrs.getProperty("connect-attempts", "-1"));
        Long.parseLong(this._dmqAttrs.getProperty("connect-attempt-interval-in-seconds", "5"));
        String val = this._dmqAttrs.getProperty("stay-connected", "true");
        this._stayConnected = Boolean.parseBoolean(val);
        val = this._dmqAttrs.getProperty("time-to-live-in-millis", "0");
        this._timeToLive = Long.parseLong(val);
        val = this._dmqAttrs.getProperty("send-attempts", "3");
        this._maxSendAttempts = Integer.parseInt(val);
        if (this._maxSendAttempts <= 0) {
            this._maxSendAttempts = 1;
        }
        val = this._dmqAttrs.getProperty("send-attempt-interval-in-seconds", "5");
        this._sendInterval = Long.parseLong(val) * 1000L;
        if (this._sendInterval < 0L) {
            this._sendInterval = 0L;
        }
        if ((cn = this._dmqAttrs.getProperty("message-transformer-class")) != null) {
            this._msgTransformer = (MessageTransformer)Class.forName(cn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        this._state = DMQState.STOPPED;
    }

    public boolean isEnabled() {
        return Boolean.parseBoolean(this._dmqAttrs.getProperty("enabled", "true"));
    }

    public synchronized void start(boolean doReconnect) throws Exception {
        if (this._state == DMQState.UNINITIALIZED) {
            JMSBridgeResources jMSBridgeResources = JMSBridge.getJMSBridgeResources();
            JMSBridge.getJMSBridgeResources();
            throw new IllegalStateException(jMSBridgeResources.getKString("BSJ4005", this.toString()));
        }
        if (this._state == DMQState.STARTED) {
            this._logger.log(Level.INFO, JMSBridge.getJMSBridgeResources().getString("BSJ1000", this.toString()));
            return;
        }
        this._state = DMQState.STARTING;
        try {
            if (this._stayConnected) {
                this.initJMS(doReconnect);
            }
            this._state = DMQState.STARTED;
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, JMSBridge.getJMSBridgeResources().getKString("BSJ3000", this.toString(), e.getMessage()), e);
            try {
                this.stop();
            }
            catch (Throwable t) {
                this._logger.log(Level.WARNING, JMSBridge.getJMSBridgeResources().getKString("BSJ2000", this.toString()), t);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Throwable {
        this._notifier.notifyEvent(EventListener.EventType.DMQ_STOP, this);
        DMQ dMQ = this;
        synchronized (dMQ) {
            this._state = DMQState.STOPPING;
            this.closeJMS();
            this._state = DMQState.STOPPED;
        }
    }

    private void initJMS() throws Exception {
        this.initJMS(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initJMS(boolean doReconnect) throws Exception {
        this._connException = false;
        String val = this._dmqAttrs.getProperty("clientid");
        if (this._stayConnected || val != null) {
            Object[] param = new String[]{"DMQ", val == null ? "" : "[ClientID=" + val + "]", this.toString()};
            this._logger.log(Level.INFO, _jbr.getString("BSJ1001", param));
            EventListener l = new EventListener(this);
            try {
                this._notifier.addEventListener(EventListener.EventType.DMQ_STOP, l);
                this._notifier.addEventListener(EventListener.EventType.BRIDGE_STOP, l);
                this._conn = JMSBridge.openConnection(this._cf, this._parent.getCFAttributes(this._cf), "DMQ", this, l, this._logger, doReconnect);
            }
            finally {
                this._notifier.removeEventListener(l);
            }
            if (val != null) {
                this._conn.setClientID(val);
            }
        } else {
            this._conn = this._parent.obtainConnection(this._cf, "DMQ", this, doReconnect);
        }
        this._conn.setExceptionListener(new ExceptionListener(){

            public void onException(JMSException exception) {
                DMQ.this._logger.log(Level.WARNING, _jbr.getKString("BSJ2001", this.toString()), exception);
                DMQ.this._connException = true;
                if (DMQ.this._conn instanceof PooledConnection) {
                    ((PooledConnection)DMQ.this._conn).invalid();
                } else if (DMQ.this._conn instanceof SharedConnection) {
                    ((SharedConnection)DMQ.this._conn).invalid();
                }
            }
        });
        try {
            ConnectionMetaData md = this._conn.getMetaData();
            this._providerName = md.getJMSProviderName();
        }
        catch (Exception e) {
            this._providerName = null;
            this._logger.log(Level.WARNING, () -> String.format("Unable to get JMSProvider from conn %s in dmq %s: %s", this._conn, this, e.getMessage()));
        }
        this._session = this._conn.createSession(false, 1);
        if (this._dest instanceof Destination) {
            this._producer = this._session.createProducer((Destination)this._dest);
        } else if (this._dest instanceof AutoDestination) {
            AutoDestination ad = (AutoDestination)this._dest;
            this._producer = ad.isQueue() ? this._session.createProducer((Destination)this._session.createQueue(ad.getName())) : this._session.createProducer((Destination)this._session.createTopic(ad.getName()));
        } else {
            throw new IllegalArgumentException("Unknown destination type: " + this._dest.getClass().getName() + " in dmq " + String.valueOf(this));
        }
    }

    private synchronized void closeJMS() {
        this._connException = false;
        if (this._conn == null) {
            return;
        }
        if (this._conn instanceof SharedConnection || this._conn instanceof PooledConnection) {
            try {
                this._parent.returnConnection(this._conn, this._cf);
            }
            catch (Throwable t) {
                this.logWarning(_jbr.getKString("BSJ2002", this._conn, this.toString()), t);
            }
            return;
        }
        try {
            this._logger.log(Level.INFO, _jbr.getString("BSJ1075", this._conn.getClass().getName() + "@" + Integer.toHexString(this._conn.hashCode()), this.toString()));
            this._conn.close();
        }
        catch (Throwable t) {
            this._logger.log(Level.WARNING, _jbr.getKString("BSJ2003", this._conn, this.toString()), t);
        }
    }

    private void logWarning(String msg, Throwable t) {
        if (this._state == DMQState.STOPPING || this._state == DMQState.STOPPED) {
            this._logger.log(Level.WARNING, () -> String.format("%s: %s", msg, t.getMessage()));
        } else {
            this._logger.log(Level.WARNING, msg, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendMessage(Message m, String mid, DMQReason reason, Throwable ex, Link l) throws Exception {
        if (this._state == DMQState.STOPPING || this._state == DMQState.STOPPED) {
            throw new JMSException(_jbr.getKString("BSJ4006", this.toString()));
        }
        if (this._connException) {
            this.closeJMS();
            this.initJMS();
        } else if (!this._stayConnected) {
            this.initJMS();
        }
        ObjectMessage om = this._session.createObjectMessage();
        if (mid != null) {
            try {
                om.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_SOURCE_MESSAGEID.toString(), mid);
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Exception in setting JMSMessageID to DMQ message from message " + String.valueOf(m) + " for link " + String.valueOf(l), e);
            }
        }
        long timestamp = 0L;
        try {
            timestamp = m.getJMSTimestamp();
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "Exception in getting JMSTimestamp from message " + String.valueOf(m) + " for link " + String.valueOf(l), e);
        }
        if (timestamp != 0L) {
            try {
                om.setLongProperty(DMQProperty.JMS_SUN_JMSBRIDGE_SOURCE_TIMESTAMP.toString(), timestamp);
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Exception in setting source timestamp to DMQ message from message " + String.valueOf(m) + " for link " + String.valueOf(l), e);
            }
        }
        String val = null;
        try {
            val = m.getJMSCorrelationID();
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "Exception in getting JMSCorrelationID from message " + String.valueOf(m) + " for link " + String.valueOf(l), e);
        }
        if (val != null) {
            try {
                om.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_SOURCE_CORRELATIONID.toString(), val);
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Exception in setting source correlation id to DMQ message from message " + String.valueOf(m) + " for link " + String.valueOf(l), e);
            }
        }
        val = null;
        try {
            val = m.getJMSType();
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "Exception in getting JMSType from message " + String.valueOf(m) + " for " + String.valueOf(l), e);
        }
        if (val != null) {
            try {
                om.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_SOURCE_JMSTYPE.toString(), val);
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Exception in setting source JMS type to DMQ message from message " + String.valueOf(m) + " for link " + String.valueOf(l), e);
            }
        }
        Enumeration en = null;
        try {
            en = m.getPropertyNames();
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "Exception in getting PropertyNames from message " + String.valueOf(m) + " in " + String.valueOf(l), e);
        }
        String key = null;
        Object value = null;
        while (en != null && en.hasMoreElements()) {
            key = (String)en.nextElement();
            value = m.getObjectProperty(key);
            try {
                om.setObjectProperty(key, value);
            }
            catch (Exception e) {
                Object[] eparam = new String[]{key + "=" + String.valueOf(value), mid, l.toString()};
                this._logger.log(Level.WARNING, _jbr.getKString("BSJ4007", eparam), e);
            }
        }
        try {
            om.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_SOURCE_DESTINATION.toString(), l.getSourceDestinationName());
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "Exception in setting source destination to DMQ message for message " + String.valueOf(m) + " in " + String.valueOf(l), e);
        }
        try {
            om.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_TARGET_DESTINATION.toString(), l.getTargetDestinationName());
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "Exception in setting target destination " + l.getTargetDestinationName() + " to DMQ message for message " + String.valueOf(m) + " in " + String.valueOf(l), e);
        }
        if (l.getTargetCurrentDestinationName() != null) {
            try {
                om.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_TARGET_CURRENT_DESTINATION.toString(), l.getTargetCurrentDestinationName());
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Exception in setting target current destination " + l.getTargetCurrentDestinationName() + " to DMQ message for message " + String.valueOf(m) + " in " + String.valueOf(l), e);
            }
        }
        try {
            om.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_SOURCE_PROVIDER.toString(), l.getSourceProviderName());
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "Exception in setting source provider to DMQ message for message " + String.valueOf(m) + " in " + String.valueOf(l), e);
        }
        try {
            om.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_TARGET_PROVIDER.toString(), l.getTargetProviderName());
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "Exception in setting target provider to DMQ message for message " + String.valueOf(m) + " in " + String.valueOf(l), e);
        }
        try {
            om.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_DMQ_REASON.toString(), reason.toString());
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "Exception in setting dmq reason " + String.valueOf((Object)reason) + " to DMQ message for message " + String.valueOf(m) + " in " + String.valueOf(l), e);
        }
        if (ex != null && ex.getMessage() != null) {
            try {
                om.setStringProperty(DMQProperty.JMS_SUN_JMSBRIDGE_DMQ_EXCEPTION.toString(), ex.getMessage());
            }
            catch (Exception e) {
                this._logger.log(Level.WARNING, "Exception in setting dmq reason " + String.valueOf((Object)reason) + " to DMQ message for message " + String.valueOf(m) + " in " + String.valueOf(l), e);
            }
        }
        try {
            om.setLongProperty(DMQProperty.JMS_SUN_JMSBRIDGE_DMQ_TIMESTAMP.toString(), System.currentTimeMillis());
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "Exception in setting dmq timestamp to DMQ message for message " + String.valueOf(m) + " in " + String.valueOf(l), e);
        }
        int deliveryMode = 2;
        try {
            deliveryMode = m.getJMSDeliveryMode();
        }
        catch (Exception e) {
            deliveryMode = 2;
            this._logger.log(Level.WARNING, "Exception in getting JMSDeliveryMode: " + e.getMessage() + " for message " + String.valueOf(m) + " in " + String.valueOf(l), e);
        }
        int priority = 4;
        try {
            priority = m.getJMSPriority();
        }
        catch (Exception e) {
            priority = 4;
            this._logger.log(Level.WARNING, "Exception in getting JMSPriority: " + e.getMessage() + " for message " + String.valueOf(m) + " in " + String.valueOf(l), e);
        }
        boolean sent = false;
        int attempts = 0;
        EventListener el = new EventListener(this);
        this._notifier.addEventListener(EventListener.EventType.DMQ_STOP, el);
        this._notifier.addEventListener(EventListener.EventType.BRIDGE_STOP, el);
        Message msgToSend = m;
        try {
            do {
                Object[] eparam;
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException(_jbr.getKString("BSJ4038", mid, this.toString()));
                }
                if (attempts > 0 && this._sendInterval > 0L) {
                    Thread.sleep(this._sendInterval);
                }
                try {
                    if (this._connException) {
                        this.closeJMS();
                        this.initJMS();
                    } else if (!this._stayConnected) {
                        this.initJMS();
                    }
                    if (attempts == 0) {
                        Object[] eparam2;
                        if (this._msgTransformer != null) {
                            this._msgTransformer.init(this._session, "JMS");
                            try {
                                msgToSend = this._msgTransformer.transform(m, true, null, l.getSourceProviderName(), l.getTargetProviderName(), this._dmqProps);
                                if (this._fi.FAULT_INJECTION) {
                                    HashMap<String, String> p = new HashMap<String, String>();
                                    p.put("dmqName", this._name);
                                    this._fi.setLogger(this._logger);
                                    this._fi.checkFaultAndThrowException("dmq.transform.2", p, "jakarta.jms.JMSException", true);
                                }
                            }
                            catch (Exception e) {
                                msgToSend = m;
                                eparam = new String[]{"MessageTransformer", mid, l.toString()};
                                this._logger.log(Level.WARNING, _jbr.getKString("BSJ2004", eparam), e);
                            }
                        }
                        boolean truncate = true;
                        if (msgToSend instanceof Serializable) {
                            truncate = false;
                            try {
                                om.setObject((Serializable)msgToSend);
                            }
                            catch (Exception e) {
                                truncate = true;
                                eparam2 = new String[]{"ObjectMessage.setObject()", mid, l.toString()};
                                this._logger.log(Level.WARNING, _jbr.getKString("BSJ2004", eparam2), e);
                            }
                        }
                        if (truncate) {
                            try {
                                om.setBooleanProperty(DMQProperty.JMS_SUN_JMSBRIDGE_DMQ_BODY_TRUNCATED.toString(), Boolean.TRUE.booleanValue());
                            }
                            catch (Exception e) {
                                this._logger.log(Level.WARNING, "Exception in setting DMQ body-truncated property for DMQ message " + String.valueOf(m) + "in " + String.valueOf(l), e);
                            }
                            try {
                                om.setObject((Serializable)((Object)msgToSend.toString()));
                            }
                            catch (Exception e) {
                                eparam2 = new String[]{"ObjectMessage.setObject()", mid, l.toString()};
                                this._logger.log(Level.WARNING, _jbr.getKString("BSJ2005", eparam2), e);
                            }
                        }
                    }
                    if (this._fi.FAULT_INJECTION) {
                        HashMap<String, String> p = new HashMap<String, String>();
                        p.put("dmqName", this._name);
                        this._fi.setLogger(this._logger);
                        this._fi.checkFaultAndThrowException("dmq.send.1", p, "jakarta.jms.JMSException", true);
                    }
                    this._producer.send((Message)om, deliveryMode, priority, this._timeToLive);
                    sent = true;
                }
                catch (Throwable t) {
                    this._connException = true;
                    eparam = new String[]{mid, this.toString(), l.toString(), ++attempts + "(" + this._sendInterval + ")"};
                    this._logger.log(Level.SEVERE, _jbr.getKString("BSJ3001", eparam), t);
                }
            } while (!sent && attempts <= this._maxSendAttempts && !el.hasEventOccurred());
        }
        finally {
            this._notifier.removeEventListener(el);
            if (!this._stayConnected) {
                this.closeJMS();
            }
        }
    }

    static String format(String headerName, HeaderFunction header, Message msg, String mid, Link l) {
        try {
            return "\t" + headerName + "=" + String.valueOf(header.getFrom(msg)) + "\n";
        }
        catch (Throwable t) {
            return "\tUnable to get " + headerName + " header from message " + mid + " for " + String.valueOf(l) + ": " + t.getMessage() + "\n";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logMessage(Message msg, String mid, Link l, Logger logger) {
        StringBuilder buf = new StringBuilder();
        try {
            buf.append("Logging message going to DMQ for ").append(l);
            buf.append('\n');
            buf.append("\tJMS Headers:");
            buf.append('\n');
            buf.append(DMQ.format("JMSMessageID", Message::getJMSMessageID, msg, mid, l));
            buf.append(DMQ.format("JMSDestination", Message::getJMSDestination, msg, mid, l));
            buf.append(DMQ.format("JMSTimestamp", Message::getJMSTimestamp, msg, mid, l));
            buf.append(DMQ.format("JMSExpiration", Message::getJMSExpiration, msg, mid, l));
            buf.append(DMQ.format("JMSDeliveryMode", Message::getJMSDeliveryMode, msg, mid, l));
            buf.append(DMQ.format("JMSCorrelationID", Message::getJMSCorrelationID, msg, mid, l));
            buf.append(DMQ.format("JMSPriority", Message::getJMSPriority, msg, mid, l));
            buf.append(DMQ.format("JMSRedelivered", Message::getJMSRedelivered, msg, mid, l));
            buf.append(DMQ.format("JMSReplyTo", Message::getJMSReplyTo, msg, mid, l));
            buf.append(DMQ.format("JMSType", Message::getJMSType, msg, mid, l));
            buf.append('\n');
            buf.append("\tJMS Properties:");
            buf.append('\n');
            Enumeration en = null;
            try {
                en = msg.getPropertyNames();
            }
            catch (Throwable t) {
                buf.append("Unable to get PropertyNames from message " + mid + " for " + String.valueOf(l) + ": " + t.getMessage());
            }
            buf.append('\n');
            String key = null;
            while (en != null && en.hasMoreElements()) {
                key = (String)en.nextElement();
                try {
                    buf.append("\t" + key + "=" + String.valueOf(msg.getObjectProperty(key)));
                }
                catch (Throwable t) {
                    buf.append("Unable to get property " + key + " value from message " + mid + " for " + String.valueOf(l) + ": " + t.getMessage());
                }
                buf.append('\n');
            }
            buf.append('\n');
            buf.append("\tMessage.toString:");
            buf.append('\n');
            try {
                buf.append("\ttoString=" + String.valueOf(msg));
            }
            catch (Throwable t) {
                buf.append("\tUnable to get Message.toString() from message " + mid + " for " + String.valueOf(l) + ": " + t.getMessage());
            }
        }
        finally {
            logger.log(Level.INFO, buf.toString());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("dmq(").append(this.getName()).append(")[");
        sb.append(this._cf.getRef()).append("::");
        sb.append(this.getDestinationName());
        sb.append(']');
        return sb.toString();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getProviderName() {
        String pn = this._providerName;
        if (pn != null) {
            return pn;
        }
        return this._cf.getRefed().getClass().getName();
    }

    public String getDestinationName() {
        try {
            if (this._dest instanceof Queue) {
                return "queue:" + ((Queue)this._dest).getQueueName();
            }
            if (this._dest instanceof Topic) {
                return "topic:" + ((Topic)this._dest).getTopicName();
            }
            return this._dest.toString();
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "Exception in get destination name for dmq " + String.valueOf(this), e);
            return this._dest.toString();
        }
    }

    public void setConnectionFactory(Refable cf) {
        this._cf = cf;
    }

    public void setDestination(Object dest) {
        this._dest = dest;
    }

    public Object getDestination() {
        return this._dest;
    }

    public void setLogger(Logger l) {
        this._logger = l;
    }

    private static enum DMQState {
        UNINITIALIZED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }

    public static enum DMQProperty {
        JMS_SUN_JMSBRIDGE_SOURCE_MESSAGEID,
        JMS_SUN_JMSBRIDGE_SOURCE_TIMESTAMP,
        JMS_SUN_JMSBRIDGE_SOURCE_CORRELATIONID,
        JMS_SUN_JMSBRIDGE_SOURCE_JMSTYPE,
        JMS_SUN_JMSBRIDGE_SOURCE_DESTINATION,
        JMS_SUN_JMSBRIDGE_TARGET_DESTINATION,
        JMS_SUN_JMSBRIDGE_TARGET_CURRENT_DESTINATION,
        JMS_SUN_JMSBRIDGE_SOURCE_PROVIDER,
        JMS_SUN_JMSBRIDGE_TARGET_PROVIDER,
        JMS_SUN_JMSBRIDGE_DMQ_REASON,
        JMS_SUN_JMSBRIDGE_DMQ_EXCEPTION,
        JMS_SUN_JMSBRIDGE_DMQ_TIMESTAMP,
        JMS_SUN_JMSBRIDGE_DMQ_BODY_TRUNCATED;

    }

    public static enum DMQReason {
        MESSAGE_EXPIRED,
        TRANSFORMER_FAILURE,
        FIRST_TRANSFORMER_NOTRANSFER,
        FIRST_TRANSFORMER_BRANCHTO,
        FIRST_TRANSFORMER_AS_SOURCE_CHANGE,
        SEND_FAILURE,
        COMMIT_FAILURE,
        ACK_FAILURE;

    }

    @FunctionalInterface
    static interface HeaderFunction {
        public Object getFrom(Message var1) throws Exception;
    }
}

