/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.payload;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.Payload;

public abstract class PayloadFilesManager {
    private static final System.Logger LOG = System.getLogger(PayloadFilesManager.class.getName());
    private static final String XFER_DIR_PREFIX = "xfer-";
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(PayloadFilesManager.class);
    private final File targetDir;
    private final ActionReport report;
    private final ActionReportHandler reportHandler;
    protected final Map<File, Long> dirTimestamps = new HashMap<File, Long>();

    private PayloadFilesManager(File targetDir, ActionReport report, ActionReportHandler reportHandler) {
        this.targetDir = targetDir;
        this.report = report;
        this.reportHandler = reportHandler;
    }

    private PayloadFilesManager(File targetDir, ActionReport report) {
        this(targetDir, report, null);
    }

    protected File getTargetDir() {
        return this.targetDir;
    }

    protected URI getParentURI(Payload.Part part) throws UnsupportedEncodingException {
        File parentFile = this.getTargetDir();
        URI parentFileURI = parentFile.toURI();
        Properties partProps = part.getProperties();
        Object parentPathFromPart = partProps.getProperty("file-xfer-root");
        if (parentPathFromPart != null) {
            File xferRootFile;
            if (!((String)parentPathFromPart).endsWith(File.separator)) {
                parentPathFromPart = (String)parentPathFromPart + File.separator;
            }
            parentFile = (xferRootFile = new File((String)parentPathFromPart)).isAbsolute() ? xferRootFile : new File(parentFile, (String)parentPathFromPart);
            parentFileURI = URI.create(parentFile.toURI().toASCIIString() + (parentFile.exists() ? "" : "/"));
        }
        return parentFileURI;
    }

    protected abstract void postExtract(File var1);

    protected URI getOutputFileURI(Payload.Part part, String name) throws IOException {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        URI targetURI = this.getParentURI(part).resolve(name);
        return targetURI;
    }

    private File removeFile(Payload.Part part) throws IOException {
        File result = this.removeFileWithoutConsumingPartBody(part);
        this.consumePartBody(part);
        return result;
    }

    private File removeFileWithoutConsumingPartBody(Payload.Part part) throws IOException {
        File targetFile = new File(this.getOutputFileURI(part, part.getName()));
        if (targetFile.exists()) {
            boolean isRemovalRecursive;
            boolean bl = isRemovalRecursive = targetFile.isDirectory() && part.isRecursive();
            if (isRemovalRecursive ? FileUtils.whack(targetFile) : targetFile.delete()) {
                LOG.log(System.Logger.Level.DEBUG, "Deleted {0}{1} as requested", targetFile.getAbsolutePath(), isRemovalRecursive ? " recursively" : "");
                this.reportDeletionSuccess();
            } else {
                LOG.log(System.Logger.Level.DEBUG, "File {0} ({1}) requested for deletion exists but was not able to be deleted", part.getName(), targetFile.getAbsolutePath());
                this.reportDeletionFailure(part.getName(), strings.getLocalString("payload.deleteFailedOnFile", "Requested deletion of {0} failed; the file was found but the deletion attempt failed - no reason is available"));
            }
        } else {
            LOG.log(System.Logger.Level.DEBUG, "File {0} ({1}) requested for deletion does not exist.", part.getName(), targetFile.getAbsolutePath());
            this.reportDeletionFailure(part.getName(), new FileNotFoundException(targetFile.getAbsolutePath()));
        }
        return targetFile;
    }

    private File replaceFile(Payload.Part part) throws IOException {
        this.removeFileWithoutConsumingPartBody(part);
        return this.extractFile(part, part.getName());
    }

    private void consumePartBody(Payload.Part part) throws FileNotFoundException, IOException {
        try (InputStream is = part.getInputStream();){
            is.readAllBytes();
        }
    }

    private void processReport(Payload.Part part) throws Exception {
        if (this.reportHandler == null) {
            this.consumePartBody(part);
        } else {
            this.reportHandler.handleReport(part.getInputStream());
        }
    }

    private File extractFile(Payload.Part part, String outputName) throws IOException {
        try {
            long lastModified;
            File extractedFile = new File(this.getOutputFileURI(part, outputName));
            File immediateParent = extractedFile.getParentFile();
            if (!immediateParent.exists() && !immediateParent.mkdirs()) {
                LOG.log(System.Logger.Level.WARNING, strings.getLocalString("payload.mkdirsFailed", "Attempt to create directories for {0} failed; no further information is available. Continuing.", immediateParent));
            }
            if (extractedFile.exists()) {
                if (!extractedFile.delete() && !extractedFile.isDirectory()) {
                    LOG.log(System.Logger.Level.WARNING, strings.getLocalString("payload.overwrite", "Overwriting previously-uploaded file because the attempt to delete it failed: {0}", extractedFile));
                } else {
                    LOG.log(System.Logger.Level.DEBUG, "Deleted pre-existing file {0} before extracting transferred file", extractedFile);
                }
            }
            if (outputName.endsWith("/") && !extractedFile.exists() && !extractedFile.mkdir()) {
                LOG.log(System.Logger.Level.WARNING, strings.getLocalString("payload.mkdirsFailed", "Attempt to create directories for {0} failed; no further information is available. Continuing.", extractedFile));
            }
            if (!extractedFile.isDirectory()) {
                try (InputStream is = part.getInputStream();){
                    FileUtils.copy(is, extractedFile);
                }
            }
            part.setExtracted(extractedFile);
            String lastModifiedString = part.getProperties().getProperty("last-modified");
            long l = lastModified = lastModifiedString == null ? System.currentTimeMillis() : Long.parseLong(lastModifiedString);
            if (!extractedFile.setLastModified(lastModified)) {
                LOG.log(System.Logger.Level.WARNING, strings.getLocalString("payload.setLatModifiedFailed", "Attempt to set lastModified for {0} failed; no further information is available.  Continuing.", extractedFile));
            }
            if (extractedFile.isDirectory()) {
                this.dirTimestamps.put(extractedFile, lastModified);
            }
            this.postExtract(extractedFile);
            LOG.log(System.Logger.Level.DEBUG, "Extracted transferred entry {0} of size {1} B to {2}", part.getName(), extractedFile.length(), extractedFile);
            this.reportExtractionSuccess();
            return extractedFile;
        }
        catch (IOException e) {
            this.reportExtractionFailure(part.getName(), e);
            throw new IOException(e.getMessage(), e);
        }
    }

    public Map<File, Properties> processPartsExtended(Payload.Inbound inboundPayload) throws Exception {
        if (inboundPayload == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<File, Properties> result = new LinkedHashMap<File, Properties>();
        boolean isReportProcessed = false;
        Payload.Part possibleUnrecognizedReportPart = null;
        StringBuilder uploadedEntryNames = new StringBuilder();
        Iterator partIt = inboundPayload.parts();
        while (partIt.hasNext()) {
            Payload.Part part = (Payload.Part)partIt.next();
            DataRequestType drt = DataRequestType.getType(part);
            if (drt != null) {
                result.put(drt.processPart(this, part, part.getName()), part.getProperties());
                isReportProcessed |= drt == DataRequestType.REPORT;
                uploadedEntryNames.append(part.getName()).append(" ");
                continue;
            }
            if (isReportProcessed || possibleUnrecognizedReportPart != null) continue;
            possibleUnrecognizedReportPart = part;
        }
        if (!isReportProcessed && possibleUnrecognizedReportPart != null) {
            DataRequestType.REPORT.processPart(this, possibleUnrecognizedReportPart, possibleUnrecognizedReportPart.getName());
            isReportProcessed = true;
        }
        this.postProcessParts();
        return result;
    }

    public List<File> processParts(Payload.Inbound inboundPayload) throws Exception {
        return new ArrayList<File>(this.processPartsExtended(inboundPayload).keySet());
    }

    protected abstract void postProcessParts();

    private void reportExtractionSuccess() {
        this.reportSuccess();
    }

    private void reportSuccess() {
        if (this.report != null) {
            this.report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }

    private void reportDeletionSuccess() {
        this.reportSuccess();
    }

    private void reportDeletionFailure(String partName, String msg) {
        this.reportFailure(partName, msg, null);
    }

    private void reportDeletionFailure(String partName, Exception e) {
        this.reportFailure(partName, strings.getLocalString("payload.errDeleting", "Error deleting file {0}", partName), e);
    }

    private void reportFailure(String partName, String formattedMessage, Exception e) {
        if (this.report != null) {
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setMessage(formattedMessage);
            this.report.setFailureCause((Throwable)e);
        }
    }

    private void reportExtractionFailure(String partName, Exception e) {
        this.reportFailure(partName, strings.getLocalString("payload.errExtracting", "Error extracting transferred file {0}", partName), e);
    }

    private static File createTempFolder(File parent, String prefix) throws IOException {
        File result = File.createTempFile(prefix, "", parent);
        try {
            if (!result.delete()) {
                throw new IOException(strings.getLocalString("payload.command.errorDeletingTempFile", "Unknown error deleting temporary file {0}", result.getAbsolutePath()));
            }
            if (!result.mkdir()) {
                throw new IOException(strings.getLocalString("payload.command.errorCreatingDir", "Unknown error creating directory {0}", result.getAbsolutePath()));
            }
            LOG.log(System.Logger.Level.DEBUG, "Created temporary upload folder {0}", result.getAbsolutePath());
            return result;
        }
        catch (Exception e) {
            throw new IOException(strings.getLocalString("payload.command.errorCreatingXferFolder", "Error creating temporary file transfer folder"), e);
        }
    }

    private static File createTempFolder(File parent) throws IOException {
        return PayloadFilesManager.createTempFolder(parent, XFER_DIR_PREFIX);
    }

    public static interface ActionReportHandler {
        public void handleReport(InputStream var1) throws Exception;
    }

    private static enum DataRequestType {
        FILE_TRANSFER("file-xfer"){

            @Override
            protected File processPart(PayloadFilesManager pfm, Payload.Part part, String partName) throws Exception {
                return pfm.extractFile(part, partName);
            }
        }
        ,
        FILE_REMOVAL("file-remove"){

            @Override
            protected File processPart(PayloadFilesManager pfm, Payload.Part part, String partName) throws Exception {
                return pfm.removeFile(part);
            }
        }
        ,
        FILE_REPLACEMENT("file-replace"){

            @Override
            protected File processPart(PayloadFilesManager pfm, Payload.Part part, String partName) throws Exception {
                return pfm.replaceFile(part);
            }
        }
        ,
        REPORT("report"){

            @Override
            protected File processPart(PayloadFilesManager pfm, Payload.Part part, String partName) throws Exception {
                pfm.processReport(part);
                return null;
            }
        };

        private final String dataRequestType;

        private DataRequestType(String type) {
            this.dataRequestType = type;
        }

        protected abstract File processPart(PayloadFilesManager var1, Payload.Part var2, String var3) throws Exception;

        private static DataRequestType getType(Payload.Part part) {
            String targetDataRequestType = part.getProperties().getProperty("data-request-type");
            for (DataRequestType candidateType : DataRequestType.values()) {
                if (!candidateType.dataRequestType.equals(targetDataRequestType)) continue;
                return candidateType;
            }
            return null;
        }
    }

    public static class Temp
    extends PayloadFilesManager {
        private boolean isCleanedUp = false;

        public Temp(File parentDir, ActionReport report) throws IOException {
            super(PayloadFilesManager.createTempFolder(parentDir), report);
        }

        public Temp(ActionReport report) throws IOException {
            this(new File(System.getProperty("java.io.tmpdir")), report);
        }

        public Temp() throws IOException {
            this(null);
        }

        public void cleanup() {
            if (!this.isCleanedUp) {
                FileUtils.whack(this.targetDir);
                this.isCleanedUp = true;
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.cleanup();
        }

        @Override
        protected void postExtract(File extractedFile) {
            extractedFile.deleteOnExit();
        }

        @Override
        protected void postProcessParts() {
        }
    }

    public static class Perm
    extends PayloadFilesManager {
        public Perm(File targetDir, ActionReport report) {
            this(targetDir, report, null);
        }

        public Perm(File targetDir, ActionReport report, ActionReportHandler reportHandler) {
            super(targetDir != null ? targetDir : new File(System.getProperty("user.dir")), report, reportHandler);
        }

        public Perm(ActionReport report) {
            this(report, null);
        }

        public Perm(ActionReport report, ActionReportHandler reportHandler) {
            super(new File(System.getProperty("user.dir")), report, reportHandler);
        }

        public Perm() {
            this((ActionReportHandler)null);
        }

        public Perm(ActionReportHandler reportHandler) {
            this(null, reportHandler);
        }

        @Override
        protected void postExtract(File extractedFile) {
        }

        @Override
        protected void postProcessParts() {
            for (Map.Entry entry : this.dirTimestamps.entrySet()) {
                Date when = new Date((Long)entry.getValue());
                LOG.log(System.Logger.Level.DEBUG, "Setting lastModified for {0} explicitly to {1}", entry.getKey(), when);
                if (((File)entry.getKey()).setLastModified((Long)entry.getValue())) continue;
                LOG.log(System.Logger.Level.WARNING, strings.getLocalString("payload.setLatModifiedFailed", "Attempt to set lastModified for {0} failed; no further information is available. Continuing.", ((File)entry.getKey()).getAbsoluteFile()));
            }
        }
    }
}

