/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl;

import com.sun.enterprise.admin.servermgmt.xml.stringsubs.ModeType;
import java.io.File;

public class ModeProcessor {
    private static final System.Logger LOG = System.getLogger(ModeProcessor.class.getName());

    static String processModeType(ModeType modeType, String input) {
        if (modeType == null || input == null || input.isEmpty()) {
            return input;
        }
        switch (modeType) {
            case FORWARD: {
                input = input.replace("\\", "/");
                break;
            }
            case DOUBLE: {
                input = input.replace("\\", "\\\\");
                input = input.replace(":", "\\:");
                break;
            }
            case POLICY: {
                input = input.replace(File.separator, "${/}");
                break;
            }
            default: {
                LOG.log(System.Logger.Level.WARNING, "No processing defined for {0} mode", new Object[]{modeType});
            }
        }
        return input;
    }
}

