/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.AdministeredObjectDefinitionDescriptor;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.config.AdminObjectResource;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=AdministeredObjectDefinitionDescriptor.class)
public class AdministeredObjectDefinitionDeployer
implements ResourceDeployer<AdministeredObjectDefinitionDescriptor> {
    private static final Logger LOG = LogDomains.getLogger(AdministeredObjectDefinitionDeployer.class, (String)"jakarta.enterprise.resource.resourceadapter");
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;

    public void deployResource(AdministeredObjectDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
    }

    public void deployResource(AdministeredObjectDefinitionDescriptor resource) throws Exception {
        SimpleJndiName jndiName = ConnectorsUtil.deriveResourceName((String)resource.getResourceId(), (SimpleJndiName)resource.getJndiName(), (JavaEEResourceType)resource.getResourceType());
        MyAdministeredObjectResource adminObjectResource = new MyAdministeredObjectResource(resource, jndiName);
        this.getDeployer(adminObjectResource).deployResource((Object)adminObjectResource);
    }

    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private ResourceDeployer getDeployer(Object resource) {
        return ((ResourceManagerFactory)this.resourceManagerFactoryProvider.get()).getResourceDeployer(resource);
    }

    private AdministeredObjectProperty convertProperty(String name, String value) {
        return new AdministeredObjectProperty(this, name, value);
    }

    public void undeployResource(AdministeredObjectDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
    }

    public void undeployResource(AdministeredObjectDefinitionDescriptor resource) throws Exception {
        SimpleJndiName jndiName = ConnectorsUtil.deriveResourceName((String)resource.getResourceId(), (SimpleJndiName)resource.getJndiName(), (JavaEEResourceType)resource.getResourceType());
        LOG.log(Level.FINE, "AdministeredObjectDefinitionDeployer.undeployResource() : resource-name [{0}]", jndiName);
        MyAdministeredObjectResource adminObjectResource = new MyAdministeredObjectResource(resource, jndiName);
        this.getDeployer(adminObjectResource).undeployResource((Object)adminObjectResource);
    }

    public void enableResource(AdministeredObjectDefinitionDescriptor resource) throws Exception {
        throw new UnsupportedOperationException("enable() not supported for administered-object-definition type");
    }

    public void disableResource(AdministeredObjectDefinitionDescriptor resource) throws Exception {
        throw new UnsupportedOperationException("disable() not supported for administered-object-definition type");
    }

    public boolean handles(Object resource) {
        return resource instanceof AdministeredObjectDefinitionDescriptor;
    }

    class MyAdministeredObjectResource
    extends FakeConfigBean
    implements AdminObjectResource {
        private final AdministeredObjectDefinitionDescriptor desc;
        private final SimpleJndiName name;

        public MyAdministeredObjectResource(AdministeredObjectDefinitionDescriptor desc, SimpleJndiName name) {
            super(AdministeredObjectDefinitionDeployer.this);
            this.desc = desc;
            this.name = name;
        }

        public String getObjectType() {
            return "user";
        }

        public void setObjectType(String value) throws PropertyVetoException {
        }

        public String getIdentity() {
            return this.name.toString();
        }

        public String getResAdapter() {
            return this.desc.getResourceAdapter();
        }

        public void setResAdapter(String value) throws PropertyVetoException {
        }

        public String getDescription() {
            return this.desc.getDescription();
        }

        public void setDescription(String value) throws PropertyVetoException {
        }

        public String getJndiName() {
            return this.name.toString();
        }

        public void setJndiName(String value) throws PropertyVetoException {
        }

        public String getResType() {
            return this.desc.getInterfaceName();
        }

        public void setResType(String value) throws PropertyVetoException {
        }

        public String getClassName() {
            return this.desc.getClassName();
        }

        public void setClassName(String value) throws PropertyVetoException {
        }

        public String getEnabled() {
            return "true";
        }

        public void setEnabled(String value) throws PropertyVetoException {
        }

        public List<Property> getProperty() {
            Properties p = this.desc.getProperties();
            ArrayList<Property> administeredObjectProperties = new ArrayList<Property>();
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                if (key.startsWith("org.glassfish.admin-object.")) continue;
                String value = (String)entry.getValue();
                AdministeredObjectProperty dp = AdministeredObjectDefinitionDeployer.this.convertProperty(key, value);
                administeredObjectProperties.add(dp);
            }
            return administeredObjectProperties;
        }

        public Property getProperty(String name) {
            String value = this.desc.getProperty(name);
            return new AdministeredObjectProperty(AdministeredObjectDefinitionDeployer.this, name, value);
        }

        public String getPropertyValue(String name) {
            return this.desc.getProperty(name);
        }

        public String getPropertyValue(String name, String defaultValue) {
            String value = this.desc.getProperty(name);
            return value == null ? defaultValue : value;
        }

        public void injectedInto(Object o) {
        }

        public String getDeploymentOrder() {
            return null;
        }

        public void setDeploymentOrder(String value) {
        }

        public Property addProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Property lookupProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Property removeProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Property removeProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String toString() {
            return super.toString() + "[identity=" + this.getIdentity() + "]";
        }
    }

    class AdministeredObjectProperty
    extends FakeConfigBean
    implements Property {
        private String name;
        private String value;
        private String description;

        AdministeredObjectProperty(AdministeredObjectDefinitionDeployer this$0, String name, String value) {
            super(this$0);
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) throws PropertyVetoException {
            this.name = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) throws PropertyVetoException {
            this.value = value;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String value) throws PropertyVetoException {
            this.description = value;
        }

        public void injectedInto(Object o) {
        }
    }

    abstract class FakeConfigBean
    implements ConfigBeanProxy {
        FakeConfigBean(AdministeredObjectDefinitionDeployer this$0) {
        }

        public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) {
            throw new UnsupportedOperationException();
        }

        public ConfigBeanProxy getParent() {
            return null;
        }

        public <T extends ConfigBeanProxy> T getParent(Class<T> tClass) {
            return null;
        }

        public <T extends ConfigBeanProxy> T createChild(Class<T> tClass) throws TransactionFailure {
            return null;
        }
    }
}

