/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro.virtualthreads;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.concurro.ContextServiceImpl;
import org.glassfish.concurro.ManagedThreadFactoryImpl;
import org.glassfish.concurro.internal.ManagedFutureTask;
import org.glassfish.concurro.internal.ThreadExpiredException;
import org.glassfish.concurro.spi.ContextHandle;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class VirtualThreadsManagedThreadFactory
extends ManagedThreadFactoryImpl {
    final Map<Thread, Long> startTimes = new ConcurrentHashMap<Thread, Long>();
    private static final System.Logger loggerForRunnableWithContext = System.getLogger(RunnableWithContext.class.getName());

    public VirtualThreadsManagedThreadFactory(String name) {
        super(name);
    }

    public VirtualThreadsManagedThreadFactory(String name, ContextServiceImpl contextService) {
        super(name, contextService);
    }

    @Override
    protected Thread createThread(Runnable taskToRun, ContextHandle contextHandleForSetup) {
        RunnableWithContext taskToRunWithContext = new RunnableWithContext(taskToRun, contextHandleForSetup);
        return Thread.ofVirtual().unstarted(taskToRunWithContext);
    }

    @Override
    protected void shutdown(Thread t) {
        if (t != null) {
            t.interrupt();
        }
    }

    public void taskStarting(Thread t, ManagedFutureTask task) {
        if (t != null) {
            this.startTimes.put(t, System.currentTimeMillis());
        }
    }

    @Override
    public void taskDone(Thread t) {
        if (t != null) {
            this.startTimes.remove(t);
        }
    }

    public boolean isTaskHung(Thread thread, long now) {
        Long startTime = this.startTimes.get(thread);
        if (startTime == null) {
            return false;
        }
        return now - startTime > this.getHungTaskThreshold();
    }

    private final class RunnableWithContext
    implements Runnable {
        private final Runnable nestedRunnable;
        private final ContextHandle contextHandleForSetup;
        private final System.Logger logger = loggerForRunnableWithContext;

        public RunnableWithContext(Runnable nestedRunnable, ContextHandle contextHandleForSetup) {
            this.nestedRunnable = nestedRunnable;
            this.contextHandleForSetup = contextHandleForSetup;
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            block8: {
                ContextHandle handle = null;
                try {
                    if (this.contextHandleForSetup != null) {
                        handle = VirtualThreadsManagedThreadFactory.this.getContextSetupProvider().setup(this.contextHandleForSetup);
                    }
                    this.nestedRunnable.run();
                    if (handle == null) break block8;
                }
                catch (ThreadExpiredException ex) {
                    block9: {
                        this.logger.log(System.Logger.Level.INFO, ex.toString());
                        if (handle == null) break block9;
                        VirtualThreadsManagedThreadFactory.this.getContextSetupProvider().reset(handle);
                    }
                    VirtualThreadsManagedThreadFactory.this.removeThread(Thread.currentThread());
                }
                catch (Throwable t) {
                    block10: {
                        this.logger.log(System.Logger.Level.ERROR, VirtualThreadsManagedThreadFactory.this.getName(), t);
                        if (handle == null) break block10;
                        VirtualThreadsManagedThreadFactory.this.getContextSetupProvider().reset(handle);
                        {
                            catch (Throwable throwable) {
                                if (handle != null) {
                                    VirtualThreadsManagedThreadFactory.this.getContextSetupProvider().reset(handle);
                                }
                                VirtualThreadsManagedThreadFactory.this.removeThread(Thread.currentThread());
                                throw throwable;
                            }
                        }
                    }
                    VirtualThreadsManagedThreadFactory.this.removeThread(Thread.currentThread());
                }
                VirtualThreadsManagedThreadFactory.this.getContextSetupProvider().reset(handle);
            }
            VirtualThreadsManagedThreadFactory.this.removeThread(Thread.currentThread());
        }
    }
}

