/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.ForeignKeyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.OverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.JoinTableMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class AssociationOverrideMetadata
extends OverrideMetadata {
    private ForeignKeyMetadata m_foreignKey;
    private JoinTableMetadata m_joinTable;
    private List<JoinColumnMetadata> m_joinColumns = new ArrayList<JoinColumnMetadata>();

    public AssociationOverrideMetadata() {
        super("<association-override>");
    }

    public AssociationOverrideMetadata(MetadataAnnotation associationOverride, MetadataAccessor accessor) {
        super(associationOverride, accessor);
        for (Object joinColumn : associationOverride.getAttributeArray("joinColumns")) {
            this.m_joinColumns.add(new JoinColumnMetadata((MetadataAnnotation)joinColumn, accessor));
        }
        if (associationOverride.hasAttribute("foreignKey")) {
            this.m_foreignKey = new ForeignKeyMetadata(associationOverride.getAttributeAnnotation("foreignKey"), accessor);
        }
        this.m_joinTable = new JoinTableMetadata(associationOverride.getAttributeAnnotation("joinTable"), accessor);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof AssociationOverrideMetadata) {
            AssociationOverrideMetadata associationOverride = (AssociationOverrideMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_joinColumns, associationOverride.getJoinColumns())) {
                return false;
            }
            if (!this.valuesMatch(this.m_foreignKey, associationOverride.getForeignKey())) {
                return false;
            }
            return this.valuesMatch(this.m_joinTable, associationOverride.getJoinTable());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_foreignKey != null ? this.m_foreignKey.hashCode() : 0);
        result = 31 * result + (this.m_joinTable != null ? this.m_joinTable.hashCode() : 0);
        result = 31 * result + (this.m_joinColumns != null ? this.m_joinColumns.hashCode() : 0);
        return result;
    }

    @Override
    public String getIgnoreMappedSuperclassContext() {
        return "metadata_warning_ignore_mapped_superclass_association_override";
    }

    public ForeignKeyMetadata getForeignKey() {
        return this.m_foreignKey;
    }

    public List<JoinColumnMetadata> getJoinColumns() {
        return this.m_joinColumns;
    }

    public JoinTableMetadata getJoinTable() {
        return this.m_joinTable;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_joinTable, accessibleObject);
        this.initXMLObject(this.m_foreignKey, accessibleObject);
        this.initXMLObjects(this.m_joinColumns, accessibleObject);
    }

    public void setForeignKey(ForeignKeyMetadata foreignKey) {
        this.m_foreignKey = foreignKey;
    }

    public void setJoinColumns(List<JoinColumnMetadata> joinColumns) {
        this.m_joinColumns = joinColumns;
    }

    public void setJoinTable(JoinTableMetadata joinTable) {
        this.m_joinTable = joinTable;
    }
}

