/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import jakarta.json.stream.JsonGenerator;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.oxm.record.JsonRecord;

public class JsonGeneratorRecord
extends JsonRecord<JsonRecord.Level> {
    private JsonGenerator jsonGenerator;
    private String rootKeyName;

    public JsonGeneratorRecord(JsonGenerator generator, String rootKeyName) {
        this.jsonGenerator = generator;
        this.rootKeyName = rootKeyName;
    }

    @Override
    protected void startRootObject() {
        super.startRootObject();
        this.position.setKeyName(this.rootKeyName);
        this.setComplex(this.position, true);
    }

    @Override
    protected void finishLevel() {
        if (!this.position.isCollection || !this.position.isEmptyCollection() || this.position.getKeyName() != null) {
            this.jsonGenerator.writeEnd();
        }
        super.finishLevel();
    }

    @Override
    protected void startRootLevelCollection() {
        if (this.rootKeyName != null) {
            this.jsonGenerator.writeStartArray(this.rootKeyName);
        } else {
            this.jsonGenerator.writeStartArray();
        }
    }

    @Override
    public void endCollection() {
        this.finishLevel();
    }

    @Override
    protected void setComplex(JsonRecord.Level level, boolean complex) {
        boolean isAlreadyComplex = level.isComplex;
        super.setComplex(level, complex);
        if (complex && !isAlreadyComplex) {
            JsonRecord.Level parentLevel = level.parentLevel;
            if (parentLevel != null && parentLevel.isCollection && parentLevel.isEmptyCollection()) {
                parentLevel.setEmptyCollection(false);
            }
            if (parentLevel != null && parentLevel.isCollection && !parentLevel.isEmptyCollection() || level.keyName == null) {
                this.jsonGenerator.writeStartObject();
            } else {
                this.jsonGenerator.writeStartObject(level.keyName);
            }
        }
    }

    @Override
    protected void startEmptyCollection() {
        if (this.position.parentLevel != null && this.position.parentLevel.getSkipCount() > 0) {
            this.jsonGenerator.writeStartArray();
        } else {
            this.jsonGenerator.writeStartArray(this.position.keyName);
        }
    }

    @Override
    protected void writeEmptyCollection(JsonRecord.Level level, String keyName) {
        this.jsonGenerator.writeStartArray(keyName);
        this.jsonGenerator.writeEnd();
    }

    @Override
    protected void addValueToObject(JsonRecord.Level level, String keyName, Object value, QName schemaType) {
        if (value == "null") {
            this.jsonGenerator.writeNull(keyName);
        } else if (value instanceof Integer) {
            this.jsonGenerator.write(keyName, ((Integer)value).intValue());
        } else if (value instanceof BigDecimal) {
            this.jsonGenerator.write(keyName, (BigDecimal)value);
        } else if (value instanceof BigInteger) {
            this.jsonGenerator.write(keyName, (BigInteger)value);
        } else if (value instanceof Boolean) {
            this.jsonGenerator.write(keyName, ((Boolean)value).booleanValue());
        } else if (value instanceof Character) {
            this.jsonGenerator.write(keyName, (int)((Character)value).charValue());
        } else if (value instanceof Double) {
            this.jsonGenerator.write(keyName, ((Double)value).doubleValue());
        } else if (value instanceof Float) {
            this.jsonGenerator.write(keyName, (double)((Float)value).floatValue());
        } else if (value instanceof Long) {
            this.jsonGenerator.write(keyName, ((Long)value).longValue());
        } else if (value instanceof String) {
            this.jsonGenerator.write(keyName, (String)value);
        } else {
            ConversionManager conversionManager = this.getConversionManager();
            String convertedValue = conversionManager.convertObject(value, CoreClassConstants.STRING, schemaType);
            Class theClass = conversionManager.javaType(schemaType);
            if ((schemaType == null || theClass == null) && CoreClassConstants.NUMBER.isAssignableFrom(value.getClass())) {
                BigDecimal convertedNumberValue = ((ConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, CoreClassConstants.BIGDECIMAL, schemaType);
                this.jsonGenerator.write(keyName, convertedNumberValue);
            } else {
                this.jsonGenerator.write(keyName, convertedValue);
            }
        }
    }

    @Override
    protected void addValueToArray(JsonRecord.Level level, Object value, QName schemaType) {
        if (value == "null") {
            this.jsonGenerator.writeNull();
        } else if (value instanceof Integer) {
            this.jsonGenerator.write(((Integer)value).intValue());
        } else if (value instanceof BigDecimal) {
            this.jsonGenerator.write((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            this.jsonGenerator.write((BigInteger)value);
        } else if (value instanceof Boolean) {
            this.jsonGenerator.write(((Boolean)value).booleanValue());
        } else if (value instanceof Character) {
            this.jsonGenerator.write((int)((Character)value).charValue());
        } else if (value instanceof Double) {
            this.jsonGenerator.write(((Double)value).doubleValue());
        } else if (value instanceof Float) {
            this.jsonGenerator.write((double)((Float)value).floatValue());
        } else if (value instanceof Long) {
            this.jsonGenerator.write(((Long)value).longValue());
        } else if (value instanceof String) {
            this.jsonGenerator.write((String)value);
        } else {
            ConversionManager conversionManager = this.getConversionManager();
            String convertedValue = conversionManager.convertObject(value, CoreClassConstants.STRING, schemaType);
            Class theClass = conversionManager.javaType(schemaType);
            if ((schemaType == null || theClass == null) && CoreClassConstants.NUMBER.isAssignableFrom(value.getClass())) {
                BigDecimal convertedNumberValue = ((ConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value, CoreClassConstants.BIGDECIMAL, schemaType);
                this.jsonGenerator.write(convertedNumberValue);
            } else {
                this.jsonGenerator.write(convertedValue);
            }
        }
    }
}

