/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.runtimeexceptiontests;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import jakarta.jms.IllegalStateException;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.InvalidClientIDException;
import jakarta.jms.InvalidClientIDRuntimeException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidDestinationRuntimeException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.InvalidSelectorRuntimeException;
import jakarta.jms.JMSException;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.JMSSecurityRuntimeException;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.MessageNotWriteableRuntimeException;
import jakarta.jms.ResourceAllocationRuntimeException;
import jakarta.jms.TransactionInProgressRuntimeException;
import jakarta.jms.TransactionRolledBackException;
import jakarta.jms.TransactionRolledBackRuntimeException;
import java.util.Properties;

public class Client
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.core20.runtimeexceptiontests.Client";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
    }

    public void cleanup() throws Exception {
    }

    public void transactionRolledBackRuntimeExceptionTest1() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Serious";
            String reason = "Rollback operation not allowed.";
            TestUtil.logMsg((String)"Test TransactionRolledBackRuntimeException(String, String)");
            TransactionRolledBackRuntimeException exceptionToTest = new TransactionRolledBackRuntimeException(reason, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (TransactionRolledBackRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("transactionRolledBackRuntimeExceptionTest1 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("transactionRolledBackRuntimeExceptionTest1 Failed");
        }
    }

    public void transactionRolledBackRuntimeExceptionTest2() throws Exception {
        boolean pass = true;
        try {
            String reason = "Rollback operation not allowed.";
            TestUtil.logMsg((String)"Test TransactionRolledBackRuntimeException(String)");
            TransactionRolledBackRuntimeException exceptionToTest = new TransactionRolledBackRuntimeException(reason);
            try {
                throw exceptionToTest;
            }
            catch (TransactionRolledBackRuntimeException e) {
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("transactionRolledBackRuntimeExceptionTest2 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("transactionRolledBackRuntimeExceptionTest2 Failed");
        }
    }

    public void transactionRolledBackRuntimeExceptionTest3() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Serious";
            String reason = "Rollback operation not allowed.";
            TransactionRolledBackException exception = new TransactionRolledBackException(reason);
            TestUtil.logMsg((String)"Test TransactionRolledBackRuntimeException(String, String, Throwable)");
            TransactionRolledBackRuntimeException exceptionToTest = new TransactionRolledBackRuntimeException(reason, errorCode, (Throwable)exception);
            try {
                throw exceptionToTest;
            }
            catch (TransactionRolledBackRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
                if (!exceptionToTest.getCause().equals((Object)exception)) {
                    TestUtil.logErr((String)("Incorrect cause " + String.valueOf(exceptionToTest.getCause())));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("transactionRolledBackRuntimeExceptionTest1 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("transactionRolledBackRuntimeExceptionTest3 Failed");
        }
    }

    public void transactionInProgressRuntimeExceptionTest1() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Serious";
            String reason = "Transaction already in progress.";
            TestUtil.logMsg((String)"Test TransactionInProgressRuntimeException(String, String)");
            TransactionInProgressRuntimeException exceptionToTest = new TransactionInProgressRuntimeException(reason, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (TransactionInProgressRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("transactionInProgressRuntimeExceptionTest1 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("transactionInProgressRuntimeExceptionTest1 Failed");
        }
    }

    public void transactionInProgressRuntimeExceptionTest2() throws Exception {
        boolean pass = true;
        try {
            String reason = "Transaction already in progress.";
            TestUtil.logMsg((String)"Test TransactionInProgressRuntimeException(String)");
            TransactionInProgressRuntimeException exceptionToTest = new TransactionInProgressRuntimeException(reason);
            try {
                throw exceptionToTest;
            }
            catch (TransactionInProgressRuntimeException e) {
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("transactionInProgressRuntimeExceptionTest2 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("transactionInProgressRuntimeExceptionTest2 Failed");
        }
    }

    public void transactionInProgressRuntimeExceptionTest3() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Serious";
            String reason = "Transaction already in progress.";
            TransactionInProgressRuntimeException exception = new TransactionInProgressRuntimeException(reason);
            TestUtil.logMsg((String)"Test TransactionInProgressRuntimeException(String, String, Throwable)");
            TransactionInProgressRuntimeException exceptionToTest = new TransactionInProgressRuntimeException(reason, errorCode, (Throwable)exception);
            try {
                throw exceptionToTest;
            }
            catch (TransactionInProgressRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
                if (!exceptionToTest.getCause().equals((Object)exception)) {
                    TestUtil.logErr((String)("Incorrect cause " + String.valueOf(exceptionToTest.getCause())));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("transactionInProgressRuntimeExceptionTest3 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("transactionInProgressRuntimeExceptionTest3 Failed");
        }
    }

    public void resourceAllocationRuntimeExceptionTest1() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Serious";
            String reason = "Resource allocation failure due to no more resources available.";
            TestUtil.logMsg((String)"Test ResourceAllocationRuntimeException(String, String)");
            ResourceAllocationRuntimeException exceptionToTest = new ResourceAllocationRuntimeException(reason, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (ResourceAllocationRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("resourceAllocationRuntimeExceptionTest1 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("resourceAllocationRuntimeExceptionTest1 Failed");
        }
    }

    public void resourceAllocationRuntimeExceptionTest2() throws Exception {
        boolean pass = true;
        try {
            String reason = "Resource allocation failure due to no more resources available.";
            TestUtil.logMsg((String)"Test ResourceAllocationRuntimeException(String)");
            ResourceAllocationRuntimeException exceptionToTest = new ResourceAllocationRuntimeException(reason);
            try {
                throw exceptionToTest;
            }
            catch (ResourceAllocationRuntimeException e) {
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("resourceAllocationRuntimeExceptionTest2 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("resourceAllocationRuntimeExceptionTest2 Failed");
        }
    }

    public void resourceAllocationRuntimeExceptionTest3() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Serious";
            String reason = "Resource allocation failure due to no more resources available.";
            TransactionRolledBackException exception = new TransactionRolledBackException(reason);
            TestUtil.logMsg((String)"Test ResourceAllocationRuntimeException(String, String, Throwable)");
            ResourceAllocationRuntimeException exceptionToTest = new ResourceAllocationRuntimeException(reason, errorCode, (Throwable)exception);
            try {
                throw exceptionToTest;
            }
            catch (ResourceAllocationRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
                if (!exceptionToTest.getCause().equals((Object)exception)) {
                    TestUtil.logErr((String)("Incorrect cause " + String.valueOf(exceptionToTest.getCause())));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("resourceAllocationRuntimeExceptionTest1 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("resourceAllocationRuntimeExceptionTest3 Failed");
        }
    }

    public void messageNotWriteableRuntimeExceptionTest1() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Serious";
            String reason = "Writing operation not allowed.";
            TestUtil.logMsg((String)"Test MessageNotWriteableRuntimeException(String, String)");
            MessageNotWriteableRuntimeException exceptionToTest = new MessageNotWriteableRuntimeException(reason, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (MessageNotWriteableRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("messageNotWriteableRuntimeExceptionTest1 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("messageNotWriteableRuntimeExceptionTest1 Failed");
        }
    }

    public void messageNotWriteableRuntimeExceptionTest2() throws Exception {
        boolean pass = true;
        try {
            String reason = "Writing operation not allowed.";
            TestUtil.logMsg((String)"Test MessageNotWriteableRuntimeException(String)");
            MessageNotWriteableRuntimeException exceptionToTest = new MessageNotWriteableRuntimeException(reason);
            try {
                throw exceptionToTest;
            }
            catch (MessageNotWriteableRuntimeException e) {
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("messageNotWriteableRuntimeExceptionTest2 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("messageNotWriteableRuntimeExceptionTest2 Failed");
        }
    }

    public void messageNotWriteableRuntimeExceptionTest3() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Serious";
            String reason = "Writing operation not allowed.";
            MessageNotWriteableException exception = new MessageNotWriteableException(reason);
            TestUtil.logMsg((String)"Test MessageNotWriteableRuntimeException(String, String, Throwable)");
            MessageNotWriteableRuntimeException exceptionToTest = new MessageNotWriteableRuntimeException(reason, errorCode, (Throwable)exception);
            try {
                throw exceptionToTest;
            }
            catch (MessageNotWriteableRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
                if (!exceptionToTest.getCause().equals((Object)exception)) {
                    TestUtil.logErr((String)("Incorrect cause " + String.valueOf(exceptionToTest.getCause())));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("messageNotWriteableRuntimeExceptionTest1 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("messageNotWriteableRuntimeExceptionTest3 Failed");
        }
    }

    public void messageFormatRuntimeExceptionTest1() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Urgent";
            String reason = "Cannot convert from int to char";
            TestUtil.logMsg((String)"Test MessageFormatRuntimeException(String, String)");
            MessageFormatRuntimeException exceptionToTest = new MessageFormatRuntimeException(reason, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (MessageFormatRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("messageFormatRuntimeExceptionTest1 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("messageFormatRuntimeExceptionTest1 Failed");
        }
    }

    public void messageFormatRuntimeExceptionTest2() throws Exception {
        boolean pass = true;
        try {
            String reason = "Cannot convert from int to char";
            TestUtil.logMsg((String)"Test MessageFormatRuntimeException(String)");
            MessageFormatRuntimeException exceptionToTest = new MessageFormatRuntimeException(reason);
            try {
                throw exceptionToTest;
            }
            catch (MessageFormatRuntimeException e) {
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("messageFormatRuntimeExceptionTest2 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("messageFormatRuntimeExceptionTest2 Failed");
        }
    }

    public void messageFormatRuntimeExceptionTest3() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Urgent";
            String reason = "Cannot convert from int to char";
            MessageFormatException exception = new MessageFormatException(reason);
            TestUtil.logMsg((String)"Test MessageFormatRuntimeException(String, String, Throwable)");
            MessageFormatRuntimeException exceptionToTest = new MessageFormatRuntimeException(reason, errorCode, (Throwable)exception);
            try {
                throw exceptionToTest;
            }
            catch (MessageFormatRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
                if (!exceptionToTest.getCause().equals((Object)exception)) {
                    TestUtil.logErr((String)("Incorrect cause " + String.valueOf(exceptionToTest.getCause())));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("messageFormatRuntimeExceptionTest3 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("messageFormatRuntimeExceptionTest3 Failed");
        }
    }

    public void jmsSecurityRuntimeExceptionTest1() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Urgent";
            String reason = "Cannot find the user.";
            TestUtil.logMsg((String)"Test JMSSecurityRuntimeException(String, String)");
            JMSSecurityRuntimeException exceptionToTest = new JMSSecurityRuntimeException(reason, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (JMSSecurityRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("jmsSecurityRuntimeExceptionTest1 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jmsSecurityRuntimeExceptionTest1 Failed");
        }
    }

    public void jmsSecurityRuntimeExceptionTest2() throws Exception {
        boolean pass = true;
        try {
            String reason = "Cannot find the user.";
            TestUtil.logMsg((String)"Test JMSSecurityRuntimeException(String)");
            JMSSecurityRuntimeException exceptionToTest = new JMSSecurityRuntimeException(reason);
            try {
                throw exceptionToTest;
            }
            catch (JMSSecurityRuntimeException e) {
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("jmsSecurityRuntimeExceptionTest2 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jmsSecurityRuntimeExceptionTest2 Failed");
        }
    }

    public void jmsSecurityRuntimeExceptionTest3() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Urgent";
            String reason = "Cannot find the user.";
            JMSSecurityException exception = new JMSSecurityException(reason);
            TestUtil.logMsg((String)"Test JMSSecurityRuntimeException(String, String, Throwable)");
            JMSSecurityRuntimeException exceptionToTest = new JMSSecurityRuntimeException(reason, errorCode, (Throwable)exception);
            try {
                throw exceptionToTest;
            }
            catch (JMSSecurityRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
                if (!exceptionToTest.getCause().equals((Object)exception)) {
                    TestUtil.logErr((String)("Incorrect cause " + String.valueOf(exceptionToTest.getCause())));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("jmsSecurityRuntimeExceptionTest3 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jmsSecurityRuntimeExceptionTest3 Failed");
        }
    }

    public void jmsRuntimeExceptionTest1() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Warning";
            String reason = "Not a JMS operation";
            TestUtil.logMsg((String)"Test JMSRuntimeException(String, String)");
            JMSRuntimeException exceptionToTest = new JMSRuntimeException(reason, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (JMSRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("jmsRuntimeExceptionTest1 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jmsRuntimeExceptionTest1 Failed");
        }
    }

    public void jmsRuntimeExceptionTest2() throws Exception {
        boolean pass = true;
        try {
            String reason = "Not a JMS operation";
            TestUtil.logMsg((String)"Test JMSRuntimeException(String)");
            JMSRuntimeException exceptionToTest = new JMSRuntimeException(reason);
            try {
                throw exceptionToTest;
            }
            catch (JMSRuntimeException e) {
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("jmsRuntimeExceptionTest2 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jmsRuntimeExceptionTest2 Failed");
        }
    }

    public void jmsRuntimeExceptionTest3() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Warning";
            String reason = "Not a JMS operation";
            JMSException exception = new JMSException(reason);
            TestUtil.logMsg((String)"Test JMSRuntimeException(String, String, Throwable)");
            JMSRuntimeException exceptionToTest = new JMSRuntimeException(reason, errorCode, (Throwable)exception);
            try {
                throw exceptionToTest;
            }
            catch (JMSRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
                if (!exceptionToTest.getCause().equals((Object)exception)) {
                    TestUtil.logErr((String)("Incorrect cause " + String.valueOf(exceptionToTest.getCause())));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("jmsRuntimeExceptionTest3 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jmsRuntimeExceptionTest3 Failed");
        }
    }

    public void invalidSelectorRuntimeExceptionTest1() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Urgent";
            String reason = "unknown variable";
            TestUtil.logMsg((String)"Test InvalidSelectorRuntimeException(String, String)");
            InvalidSelectorRuntimeException exceptionToTest = new InvalidSelectorRuntimeException(reason, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (InvalidSelectorRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("invalidSelectorRuntimeExceptionTest1 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("invalidSelectorRuntimeExceptionTest1 Failed");
        }
    }

    public void invalidSelectorRuntimeExceptionTest2() throws Exception {
        boolean pass = true;
        try {
            String reason = "unknown variable";
            TestUtil.logMsg((String)"Test InvalidSelectorRuntimeException(String)");
            InvalidSelectorRuntimeException exceptionToTest = new InvalidSelectorRuntimeException(reason);
            try {
                throw exceptionToTest;
            }
            catch (InvalidSelectorRuntimeException e) {
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("invalidSelectorRuntimeExceptionTest2 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("invalidSelectorRuntimeExceptionTest2 Failed");
        }
    }

    public void invalidSelectorRuntimeExceptionTest3() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Urgent";
            String reason = "unknown variable";
            InvalidSelectorException exception = new InvalidSelectorException(reason);
            TestUtil.logMsg((String)"Test InvalidSelectorRuntimeException(String, String, Throwable)");
            InvalidSelectorRuntimeException exceptionToTest = new InvalidSelectorRuntimeException(reason, errorCode, (Throwable)exception);
            try {
                throw exceptionToTest;
            }
            catch (InvalidSelectorRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
                if (!exceptionToTest.getCause().equals((Object)exception)) {
                    TestUtil.logErr((String)("Incorrect cause " + String.valueOf(exceptionToTest.getCause())));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("invalidSelectorRuntimeExceptionTest3 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("invalidSelectorRuntimeExceptionTest3 Failed");
        }
    }

    public void invalidDestinationRuntimeExceptionTest1() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Urgent";
            String reason = "Destination is Null";
            TestUtil.logMsg((String)"Test InvalidDestinationRuntimeException(String, String)");
            InvalidDestinationRuntimeException exceptionToTest = new InvalidDestinationRuntimeException(reason, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (InvalidDestinationRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("invalidDestinationRuntimeExceptionTest1 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("invalidDestinationRuntimeExceptionTest1 Failed");
        }
    }

    public void invalidDestinationRuntimeExceptionTest2() throws Exception {
        boolean pass = true;
        try {
            String reason = "Destination is Null";
            TestUtil.logMsg((String)"Test InvalidDestinationRuntimeException(String)");
            InvalidDestinationRuntimeException exceptionToTest = new InvalidDestinationRuntimeException(reason);
            try {
                throw exceptionToTest;
            }
            catch (InvalidDestinationRuntimeException e) {
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("invalidDestinationRuntimeExceptionTest2 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("invalidDestinationRuntimeExceptionTest2 Failed");
        }
    }

    public void invalidDestinationRuntimeExceptionTest3() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Urgent";
            String reason = "Destination is Null";
            InvalidDestinationException exception = new InvalidDestinationException(reason);
            TestUtil.logMsg((String)"Test InvalidDestinationRuntimeException(String, String, Throwable)");
            InvalidDestinationRuntimeException exceptionToTest = new InvalidDestinationRuntimeException(reason, errorCode, (Throwable)exception);
            try {
                throw exceptionToTest;
            }
            catch (InvalidDestinationRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
                if (!exceptionToTest.getCause().equals((Object)exception)) {
                    TestUtil.logErr((String)("Incorrect cause " + String.valueOf(exceptionToTest.getCause())));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("invalidDestinationRuntimeExceptionTest3 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("invalidDestinationRuntimeExceptionTest3 Failed");
        }
    }

    public void invalidClientIDRuntimeExceptionTest1() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Urgent";
            String reason = "Duplicate Client ID";
            TestUtil.logMsg((String)"Test InvalidClientIDRuntimeException(String, String)");
            InvalidClientIDRuntimeException exceptionToTest = new InvalidClientIDRuntimeException(reason, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (InvalidClientIDRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("invalidClientIDRuntimeExceptionTest1 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("invalidClientIDRuntimeExceptionTest1 Failed");
        }
    }

    public void invalidClientIDRuntimeExceptionTest2() throws Exception {
        boolean pass = true;
        try {
            String reason = "Duplicate Client ID";
            TestUtil.logMsg((String)"Test InvalidClientIDRuntimeException(String)");
            InvalidClientIDRuntimeException exceptionToTest = new InvalidClientIDRuntimeException(reason);
            try {
                throw exceptionToTest;
            }
            catch (InvalidClientIDRuntimeException e) {
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("invalidClientIDRuntimeExceptionTest2 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("invalidClientIDRuntimeExceptionTest2 Failed");
        }
    }

    public void invalidClientIDRuntimeExceptionTest3() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Urgent";
            String reason = "Duplicate Client ID";
            InvalidClientIDException exception = new InvalidClientIDException(reason);
            TestUtil.logMsg((String)"Test InvalidClientIDRuntimeException(String, String, Throwable)");
            InvalidClientIDRuntimeException exceptionToTest = new InvalidClientIDRuntimeException(reason, errorCode, (Throwable)exception);
            try {
                throw exceptionToTest;
            }
            catch (InvalidClientIDRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
                if (!exceptionToTest.getCause().equals((Object)exception)) {
                    TestUtil.logErr((String)("Incorrect cause " + String.valueOf(exceptionToTest.getCause())));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("invalidClientIDRuntimeExceptionTest3 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("invalidClientIDRuntimeExceptionTest3 Failed");
        }
    }

    public void illegalStateRuntimeExceptionTest1() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Urgent";
            String reason = "The operation is illegal.";
            TestUtil.logMsg((String)"Test IllegalStateRuntimeException(String, String)");
            IllegalStateRuntimeException exceptionToTest = new IllegalStateRuntimeException(reason, errorCode);
            try {
                throw exceptionToTest;
            }
            catch (IllegalStateRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("IllegalStateRuntimeExceptionTest1 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("IllegalStateRuntimeExceptionTest1 Failed");
        }
    }

    public void illegalStateRuntimeExceptionTest2() throws Exception {
        boolean pass = true;
        try {
            String reason = "The operation is illegal.";
            TestUtil.logMsg((String)"Test IllegalStateRuntimeException(String)");
            IllegalStateRuntimeException exceptionToTest = new IllegalStateRuntimeException(reason);
            try {
                throw exceptionToTest;
            }
            catch (IllegalStateRuntimeException e) {
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("illegalStateRuntimeExceptionTest2 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("IllegalStateRuntimeExceptionTest2 Failed");
        }
    }

    public void illegalStateRuntimeExceptionTest3() throws Exception {
        boolean pass = true;
        try {
            String errorCode = "Urgent";
            String reason = "The operation is illegal.";
            IllegalStateException exception = new IllegalStateException(reason);
            TestUtil.logMsg((String)"Test IllegalStateRuntimeException(String, String, Throwable)");
            IllegalStateRuntimeException exceptionToTest = new IllegalStateRuntimeException(reason, errorCode, (Throwable)exception);
            try {
                throw exceptionToTest;
            }
            catch (IllegalStateRuntimeException e) {
                if (!exceptionToTest.getErrorCode().equals(errorCode)) {
                    TestUtil.logErr((String)("Incorrect ErrorCode " + exceptionToTest.getErrorCode()));
                    pass = false;
                }
                if (!exceptionToTest.getMessage().equals(reason)) {
                    TestUtil.logErr((String)("Incorrect reason " + exceptionToTest.getMessage()));
                    pass = false;
                }
                if (!exceptionToTest.getCause().equals((Object)exception)) {
                    TestUtil.logErr((String)("Incorrect cause " + String.valueOf(exceptionToTest.getCause())));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("illegalStateRuntimeExceptionTest3 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("illegalStateRuntimeExceptionTest3 Failed");
        }
    }
}

