/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.linkbuilder;

import ee.jakarta.tck.ws.rs.api.rs.core.linkbuilder.Resource;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriBuilderException;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -4301370250466608838L;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void buildNoArgTest() throws JAXRSCommonClient.Fault {
        Link link = JAXRSClientIT.builderFromResource("get").build(new Object[0]);
        Assertions.assertTrue((link != null ? 1 : 0) != 0, (String)"#build should return an instance");
        Assertions.assertTrue((link.getUri().toASCIIString().length() > 0 ? 1 : 0) != 0, (String)"Link is empty");
        JAXRSClientIT.logMsg("#build() finished building a link and returned the instance");
    }

    @Test
    public void buildNoArgsThrowsUriBuilderExceptionTest() throws JAXRSCommonClient.Fault {
        Link.Builder builder = Link.fromUri((String)"http://:@");
        try {
            Link link = builder.build(new Object[0]);
            Assertions.assertTrue((boolean)false, (String)("No exception has been thrown for link " + link));
        }
        catch (UriBuilderException e) {
            JAXRSClientIT.logMsg("#build() throw UriBuilderException as expected");
        }
    }

    @Test
    public void buildObjectsTest() throws JAXRSCommonClient.Fault {
        URI path3;
        StringBuilder path1 = new StringBuilder().append("p1");
        ByteArrayInputStream path2 = new ByteArrayInputStream("p2".getBytes(Charset.defaultCharset())){

            public String toString() {
                return "p2";
            }
        };
        try {
            path3 = new URI("p3");
        }
        catch (URISyntaxException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        String expected = "<" + JAXRSClientIT.url() + "p1/p2/p3>";
        Link.Builder builder = Link.fromUri((String)(JAXRSClientIT.url() + "{x1}/{x2}/{x3}"));
        Link link = builder.build(new Object[]{path1, path2, path3});
        Assertions.assertTrue((link != null ? 1 : 0) != 0, (String)"#build should return an instance");
        Assertions.assertTrue((boolean)link.toString().equals(expected), (String)("Link " + link + " differs from expected " + expected));
        JAXRSClientIT.logMsg("#build() finished building a link and returned the instance", link);
    }

    @Test
    public void buildThrowsIAEWhenSuppliedJustOneValueOutOfThreeTest() throws JAXRSCommonClient.Fault {
        Link.Builder linkBuilder = Link.fromUri((String)(JAXRSClientIT.url() + "{x1}/{x2}/{x3}"));
        try {
            Link link = linkBuilder.build(new Object[]{"p"});
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown when value is not supplied, link=", link.toString());
        }
        catch (IllegalArgumentException iae) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected when a value has not been supplied");
        }
    }

    @Test
    public void buildObjectsThrowsUriBuilderExceptionTest() throws JAXRSCommonClient.Fault {
        Link.Builder builder = Link.fromUri((String)"http://:@");
        try {
            Link link = builder.build(new Object[]{"aaa"});
            Assertions.assertTrue((boolean)false, (String)("No exception has been thrown for link " + link));
        }
        catch (UriBuilderException e) {
            JAXRSClientIT.logMsg("#build(someNonURIObjects) throw UriBuilderException as expected");
        }
    }

    @Test
    public void paramTest() throws JAXRSCommonClient.Fault {
        String[] params = new String[]{"param1", "param2"};
        String[] values = new String[]{"param1value1", "param1value2"};
        Link.Builder builder = RuntimeDelegate.getInstance().createLinkBuilder().uri(JAXRSClientIT.url());
        builder = builder.param(params[0], values[0]).param(params[1], values[1]);
        Link link = builder.build(new Object[0]);
        JAXRSClientIT.assertParams(link, params, values);
        JAXRSClientIT.logMsg("#param set correct parameters");
    }

    @Test
    public void paramThrowsExceptionWhenNullNameTest() throws JAXRSCommonClient.Fault {
        Link.Builder builder = RuntimeDelegate.getInstance().createLinkBuilder().uri(JAXRSClientIT.url());
        try {
            builder.param((String)null, "value");
            throw new JAXRSCommonClient.Fault("No exception has been thrown when null name");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("#param throws IllegalArgumentException as expected");
            return;
        }
    }

    @Test
    public void paramThrowsExceptionWhenNullValueTest() throws JAXRSCommonClient.Fault {
        Link.Builder builder = RuntimeDelegate.getInstance().createLinkBuilder().uri(JAXRSClientIT.url());
        try {
            builder.param((String)null, "value");
            throw new JAXRSCommonClient.Fault("No exception has been thrown when null name");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("#param throws IllegalArgumentException as expected");
            return;
        }
    }

    @Test
    public void relTest() throws JAXRSCommonClient.Fault {
        String[] names = new String[]{"name1", "name2"};
        Link.Builder builder = RuntimeDelegate.getInstance().createLinkBuilder().uri(JAXRSClientIT.url());
        for (String name : names) {
            Link link = builder.rel(name).build(new Object[0]);
            Assertions.assertTrue((boolean)link.getRel().contains(name), (String)("Rel " + name + " not found in " + link));
        }
        JAXRSClientIT.logMsg("#rel added expected relations");
    }

    @Test
    public void relMoreNamesTest() throws JAXRSCommonClient.Fault {
        String[] names = new String[]{"name1", "name2"};
        Link.Builder builder = RuntimeDelegate.getInstance().createLinkBuilder().uri(JAXRSClientIT.url());
        for (String name : names) {
            builder = builder.rel(name);
        }
        Link link = builder.build(new Object[0]);
        String search = JaxrsUtil.iterableToString(" ", names);
        Assertions.assertTrue((boolean)link.getRel().contains(search), (String)("rel " + search + " not found in " + link));
        JAXRSClientIT.logMsg("#rel added expected relations");
    }

    @Test
    public void titleTest() throws JAXRSCommonClient.Fault {
        String[] titles = new String[]{"tiTle1", "titlE2", "titLe3"};
        Link.Builder builder = RuntimeDelegate.getInstance().createLinkBuilder().uri(JAXRSClientIT.url());
        for (String title : titles) {
            builder = builder.title(title);
            Link link = builder.build(new Object[0]);
            Assertions.assertTrue((boolean)link.getTitle().equals(title), (String)("Title " + title + " not found in " + link));
        }
        JAXRSClientIT.logMsg("#title set expected title");
    }

    @Test
    public void typeTest() throws JAXRSCommonClient.Fault {
        String[] types = new String[]{"type1", "type2", "type3"};
        Link.Builder builder = RuntimeDelegate.getInstance().createLinkBuilder().uri(JAXRSClientIT.url());
        for (String type : types) {
            Link link = builder.type(type).build(new Object[0]);
            Assertions.assertTrue((boolean)link.getType().equals(type), (String)("type " + type + " not found in " + link));
        }
        JAXRSClientIT.logMsg("#type set correct types");
    }

    @Test
    public void uriUriTest() throws JAXRSCommonClient.Fault {
        URI uri = this.uri("get");
        Link.Builder builder = RuntimeDelegate.getInstance().createLinkBuilder().uri(uri);
        Link link = builder.build(new Object[0]);
        Assertions.assertTrue((boolean)link.toString().contains(uri.toASCIIString()), (String)("uri(URI) " + uri + " not used in " + link));
        JAXRSClientIT.logMsg("#uri(URI) affected link", link, "as expected");
    }

    @Test
    public void uriStringTest() throws JAXRSCommonClient.Fault {
        Link.Builder builder = RuntimeDelegate.getInstance().createLinkBuilder().uri(JAXRSClientIT.url());
        Link link = builder.build(new Object[0]);
        Assertions.assertTrue((boolean)link.toString().contains(JAXRSClientIT.url()), (String)("uri(String) " + JAXRSClientIT.url() + " not used in " + link));
        JAXRSClientIT.logMsg("#uri(String) affected link", link, "as expected");
    }

    @Test
    public void uriStringThrowsIAETest() throws JAXRSCommonClient.Fault {
        try {
            RuntimeDelegate.getInstance().createLinkBuilder().uri((String)null).build(new Object[0]);
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown for uri(null)");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("#uri(nonUriString) throws IllegalArgumentException as expected");
        }
    }

    @Test
    public void uriBuilderTest() throws JAXRSCommonClient.Fault {
        String segment = "goto/label/ten/";
        Link link = Link.fromUri((URI)this.uri(segment)).build(new Object[0]);
        UriBuilder uriBuilder = link.getUriBuilder();
        Link.Builder linkBuilder = RuntimeDelegate.getInstance().createLinkBuilder().uriBuilder(uriBuilder);
        String sBuilder = uriBuilder.build(new Object[0]).toASCIIString();
        String sFromBuilder = linkBuilder.build(new Object[0]).getUri().toASCIIString();
        JAXRSClientIT.assertContains(sFromBuilder, sBuilder, new Object[]{"Original builder", sBuilder, "not found in #fromUriBuilder", sFromBuilder});
        JAXRSClientIT.logMsg("#fromUriBuilder", sFromBuilder, "contains the original", sBuilder);
    }

    @Test
    public void baseUriURITest() throws JAXRSCommonClient.Fault {
        URI uri = null;
        try {
            uri = new URI(JAXRSClientIT.url());
        }
        catch (URISyntaxException use) {
            JAXRSClientIT.fault(use);
        }
        Link.Builder linkBuilder = RuntimeDelegate.getInstance().createLinkBuilder();
        linkBuilder = linkBuilder.baseUri(uri);
        URI createdUri = linkBuilder.uri("/a/b/c").build(new Object[0]).getUri();
        JAXRSClientIT.logMsg("Created URI", createdUri.toASCIIString());
        this.assertContains(createdUri.toASCIIString(), uri.toASCIIString());
    }

    @Test
    public void baseUriIsNotJustBaseURITest() throws JAXRSCommonClient.Fault {
        URI uri = this.uri("something");
        Link.Builder linkBuilder = RuntimeDelegate.getInstance().createLinkBuilder();
        linkBuilder = linkBuilder.baseUri(uri);
        URI createdUri = linkBuilder.uri("/a/b/c").build(new Object[0]).getUri();
        JAXRSClientIT.logMsg("Created URI", createdUri.toASCIIString());
        Assertions.assertFalse((boolean)createdUri.toASCIIString().contains(uri.toASCIIString()), (String)("Base Uri " + uri.toASCIIString() + " is not a base uri built as " + createdUri.toASCIIString()));
        this.assertContains(createdUri.toASCIIString(), JAXRSClientIT.url());
    }

    @Test
    public void baseUriIsIgnoredURITest() throws JAXRSCommonClient.Fault {
        String ignored = "http://ignored.com";
        URI ignoredUri = null;
        try {
            ignoredUri = new URI(ignored);
        }
        catch (URISyntaxException e) {
            JAXRSClientIT.fault(ignored);
        }
        URI uri = this.uri("something");
        Link.Builder linkBuilder = RuntimeDelegate.getInstance().createLinkBuilder();
        linkBuilder = linkBuilder.uri(uri);
        linkBuilder = linkBuilder.baseUri(ignoredUri);
        URI createdUri = linkBuilder.build(new Object[0]).getUri();
        JAXRSClientIT.logMsg("Created URI", createdUri.toASCIIString());
        Assertions.assertFalse((boolean)createdUri.toASCIIString().contains(ignored), (String)("Base Uri " + ignored + " is not ignored, though " + uri.toASCIIString() + " is absolute"));
        this.assertContains(createdUri.toASCIIString(), JAXRSClientIT.url());
        JAXRSClientIT.logMsg("The base uri", ignored, "has been ignored as expected");
    }

    @Test
    public void baseUriStringTest() throws JAXRSCommonClient.Fault {
        URI uri = null;
        try {
            uri = new URI(JAXRSClientIT.url());
        }
        catch (URISyntaxException use) {
            JAXRSClientIT.fault(use);
        }
        Link.Builder linkBuilder = RuntimeDelegate.getInstance().createLinkBuilder();
        linkBuilder = linkBuilder.baseUri(uri.toASCIIString());
        URI createdUri = linkBuilder.uri("/a/b/c").build(new Object[0]).getUri();
        JAXRSClientIT.logMsg("Created URI", createdUri.toASCIIString());
        this.assertContains(createdUri.toASCIIString(), uri.toASCIIString());
    }

    @Test
    public void baseUriStringThrowsIAETest() throws JAXRSCommonClient.Fault {
        Link.Builder linkBuilder = RuntimeDelegate.getInstance().createLinkBuilder();
        try {
            linkBuilder.baseUri("?:!@#$%^&*()");
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException iae) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected");
        }
    }

    @Test
    public void baseUriIsNotJustBaseStringTest() throws JAXRSCommonClient.Fault {
        URI uri = this.uri("something");
        Link.Builder linkBuilder = RuntimeDelegate.getInstance().createLinkBuilder();
        linkBuilder = linkBuilder.baseUri(uri.toASCIIString());
        URI createdUri = linkBuilder.uri("/a/b/c").build(new Object[0]).getUri();
        JAXRSClientIT.logMsg("Created URI", createdUri.toASCIIString());
        Assertions.assertFalse((boolean)createdUri.toASCIIString().contains(uri.toASCIIString()), (String)("Base Uri " + uri.toASCIIString() + " is not a base uri built as " + createdUri.toASCIIString()));
        this.assertContains(createdUri.toASCIIString(), JAXRSClientIT.url());
    }

    @Test
    public void baseUriIsIgnoredStringTest() throws JAXRSCommonClient.Fault {
        String ignored = "http://ignored.com";
        URI uri = this.uri("something");
        Link.Builder linkBuilder = RuntimeDelegate.getInstance().createLinkBuilder();
        linkBuilder = linkBuilder.uri(uri);
        linkBuilder = linkBuilder.baseUri(ignored);
        URI createdUri = linkBuilder.build(new Object[0]).getUri();
        JAXRSClientIT.logMsg("Created URI", createdUri.toASCIIString());
        Assertions.assertFalse((boolean)createdUri.toASCIIString().contains(ignored), (String)("Base Uri " + ignored + " is not ignored, though " + uri.toASCIIString() + "is absolute"));
        this.assertContains(createdUri.toASCIIString(), JAXRSClientIT.url());
        JAXRSClientIT.logMsg("The base uri", ignored, "has been ignored as expected");
    }

    @Test
    public void buildRelativizedTest() throws JAXRSCommonClient.Fault {
        String relative = "a/b/c";
        URI underlay = this.uri(relative);
        URI respect = this.uri("");
        Link.Builder linkBuilder = RuntimeDelegate.getInstance().createLinkBuilder();
        linkBuilder = linkBuilder.uri(underlay);
        Link link = linkBuilder.buildRelativized(respect, new Object[0]);
        Assertions.assertFalse((boolean)link.toString().contains(JAXRSClientIT.url()), (String)("Found unexpected absolute path " + JAXRSClientIT.url()));
        this.assertContains(link.toString(), relative);
        JAXRSClientIT.logMsg("Absolute", JAXRSClientIT.url(), "has not been found as expected in link", link.toString());
    }

    @Test
    public void buildRelativizedDoesNotSharePrefixTest() throws JAXRSCommonClient.Fault {
        String relative = "a/b/c";
        String prefix = "ssh";
        URI underlay = null;
        URI respect = null;
        try {
            underlay = new URI(JAXRSClientIT.url() + relative);
            respect = new URI(JAXRSClientIT.url().replace("http", prefix));
        }
        catch (URISyntaxException e) {
            JAXRSClientIT.fault(e);
        }
        Link.Builder linkBuilder = RuntimeDelegate.getInstance().createLinkBuilder();
        linkBuilder = linkBuilder.uri(underlay);
        Link link = linkBuilder.buildRelativized(respect, new Object[0]);
        Link build = linkBuilder.build(new Object[]{respect});
        this.assertContains(link.toString(), relative);
        this.assertContains(link.toString(), JAXRSClientIT.url());
        this.assertContains(link.toString(), build.getUri().toASCIIString());
        JAXRSClientIT.logMsg("When a prefix is not shared, the methods is equivalent to build() as expected");
    }

    @Test
    public void buildRelativizedThrowsIAEWhenNotSuppliedValuesTest() throws JAXRSCommonClient.Fault {
        Link.Builder linkBuilder = Link.fromUri((String)(JAXRSClientIT.url() + "{x1}/{x2}/{x3}"));
        URI respect = null;
        try {
            respect = new URI(JAXRSClientIT.url());
        }
        catch (URISyntaxException e) {
            JAXRSClientIT.fault(e);
        }
        try {
            Link link = linkBuilder.buildRelativized(respect, new Object[0]);
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown when value is not supplied, link=", link.toString());
        }
        catch (IllegalArgumentException iae) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected when a value has not been supplied");
        }
    }

    @Test
    public void buildRelativizedThrowsIAEWhenSuppliedJustOneValueOutOfThreeTest() throws JAXRSCommonClient.Fault {
        Link.Builder linkBuilder = Link.fromUri((String)(JAXRSClientIT.url() + "{x1}/{x2}/{x3}"));
        URI respect = null;
        try {
            respect = new URI(JAXRSClientIT.url());
        }
        catch (URISyntaxException e) {
            JAXRSClientIT.fault(e);
        }
        try {
            Link link = linkBuilder.buildRelativized(respect, new Object[]{"p"});
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown when value is not supplied, link=", link.toString());
        }
        catch (IllegalArgumentException iae) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected when a value has not been supplied");
        }
    }

    @Test
    public void buildRelativizedThrowsIAEWhenSuppliedValueIsNullTest() throws JAXRSCommonClient.Fault {
        Link.Builder linkBuilder = Link.fromUri((String)(JAXRSClientIT.url() + "{x1}/{x2}/{x3}"));
        URI respect = null;
        try {
            respect = new URI(JAXRSClientIT.url());
        }
        catch (URISyntaxException e) {
            JAXRSClientIT.fault(e);
        }
        try {
            Link link = linkBuilder.buildRelativized(respect, new Object[]{null});
            JAXRSClientIT.fault("IllegalArgumentException has not been thrown when value is not supplied, link=", link.toString());
        }
        catch (IllegalArgumentException iae) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected when a supplied value is null");
        }
    }

    @Test
    public void buildRelativizedThrowsUriBuilderExceptionTest() throws JAXRSCommonClient.Fault {
        Link.Builder linkBuilder = RuntimeDelegate.getInstance().createLinkBuilder();
        URI respect = null;
        try {
            respect = new URI(JAXRSClientIT.url());
        }
        catch (URISyntaxException e) {
            JAXRSClientIT.fault(e);
        }
        try {
            Link link = linkBuilder.uri("http://@").buildRelativized(respect, new Object[0]);
            JAXRSClientIT.fault("UriBuilderException has not been thrown, link=", link.toString());
        }
        catch (UriBuilderException iae) {
            JAXRSClientIT.logMsg("UriBuilderException has been thrown as expected");
        }
    }

    @Test
    public void linkLinkTest() throws JAXRSCommonClient.Fault {
        String title = "Ttttlll";
        String rel = "RlrL";
        String[] params = new String[]{"Param1", "parAM2", "paRam3"};
        String[] values = new String[]{"vAlUe", "ValuEe", "VVallue"};
        Link.Builder lb = RuntimeDelegate.getInstance().createLinkBuilder();
        lb = lb.baseUri(JAXRSClientIT.url()).title(title).rel(rel).type("text/xml");
        for (int i = 0; i != params.length; ++i) {
            lb = lb.param(params[i], values[i]);
        }
        Link link = lb.build(new Object[0]);
        Link.Builder lb2 = RuntimeDelegate.getInstance().createLinkBuilder();
        lb2 = lb2.link(link);
        link = lb2.build(new Object[0]);
        JAXRSClientIT.assertContains(link.getRel(), rel, new Object[]{"link(Link) does not pass relation"});
        JAXRSClientIT.assertContains(link.getTitle(), title, new Object[]{"link(Link) does noot pass title"});
        JAXRSClientIT.assertContains(link.getType(), "text/xml", new Object[]{"link(Link) does not pass type"});
        JAXRSClientIT.assertParams(link, params, values);
        this.assertContains(link.toString(), JAXRSClientIT.url());
        JAXRSClientIT.logMsg("parameters and underlaying URI were copied as expected to a new link", link);
    }

    @Test
    public void linkStringTest() throws JAXRSCommonClient.Fault {
        String title = "Ttttlll";
        String rel = "RlrL";
        String[] params = new String[]{"Param1", "parAM2", "paRam3"};
        String[] values = new String[]{"vAlUe", "ValuEe", "VVallue"};
        StringBuilder sb = new StringBuilder().append("<").append(JAXRSClientIT.url()).append(">;").append("rel=\"").append(rel).append("\";");
        for (int i = 0; i != params.length; ++i) {
            sb = sb.append(params[i]).append("=\"").append(values[i]).append("\";");
        }
        sb = sb.append("title=\"").append(title).append("\";");
        sb = sb.append("type=\"").append("text/xml").append("\"");
        String originalLink = sb.toString();
        Link.Builder lb = RuntimeDelegate.getInstance().createLinkBuilder();
        lb = lb.link(originalLink);
        Link link = lb.build(new Object[0]);
        JAXRSClientIT.assertContains(link.getRel(), rel, new Object[]{"link(Link) does not pass relation"});
        JAXRSClientIT.assertContains(link.getTitle(), title, new Object[]{"link(Link) does noot pass title"});
        JAXRSClientIT.assertContains(link.getType(), "text/xml", new Object[]{"link(Link) does not pass type"});
        JAXRSClientIT.assertParams(link, params, values);
        this.assertContains(link.toString(), JAXRSClientIT.url());
        JAXRSClientIT.logMsg("parameters and underlaying URI were copied as expected to a new link", link);
    }

    @Test
    public void linkStringThrowsIAETest() throws JAXRSCommonClient.Fault {
        Link.Builder lb = RuntimeDelegate.getInstance().createLinkBuilder();
        try {
            lb.link("<>>");
            JAXRSClientIT.fault("IllegalArgumentException has not been throw when invalid uri");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected");
        }
    }

    protected static Link.Builder builderFromResource(String method) {
        Link.Builder builder = Link.fromMethod(Resource.class, (String)method);
        return builder;
    }

    private static void assertParams(Link link, String[] params, String[] values) throws JAXRSCommonClient.Fault {
        Map map = link.getParams();
        for (int i = 0; i != params.length; ++i) {
            String list = (String)map.get(params[i]);
            JAXRSClientIT.assertContains(list, values[i], new Object[]{"Link.getParams", map, "does not contain", values[i]});
            JAXRSClientIT.logMsg("Found", values[i], "in map", map, "as expected");
        }
    }

    protected void assertContains(String string, String substring) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((boolean)string.toLowerCase().contains(substring.toLowerCase()), (String)(string + " does not contain expected " + substring));
        JAXRSClientIT.logMsg("Found expected", substring);
    }

    protected URI uri(String method) throws JAXRSCommonClient.Fault {
        URI uri = null;
        try {
            uri = new URI(JAXRSClientIT.url() + "resource/" + method);
        }
        catch (URISyntaxException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        return uri;
    }

    protected static String url() {
        return "http://oracle.com:888/";
    }
}

