/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.jsonwritertests;

import ee.jakarta.tck.jsonp.api.common.TestResult;
import ee.jakarta.tck.jsonp.api.jsonwritertests.Writer;
import ee.jakarta.tck.jsonp.common.JSONP_Util;
import ee.jakarta.tck.jsonp.common.MyBufferedWriter;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import jakarta.json.JsonWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClientTests {
    private static final Logger LOGGER = Logger.getLogger(ClientTests.class.getName());

    @Test
    public void jsonWriterTest1() {
        try {
            LOGGER.info("Create sample JsonObject for testing");
            JsonObject myJsonObject1 = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Write the JsonObject 'myJsonObject1' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((java.io.Writer)sWriter);){
                writer.writeObject(myJsonObject1);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String contents = sWriter.toString();
            LOGGER.info("Dump contents of JsonWriter as a String");
            LOGGER.info("JsonWriterContents=" + contents);
            LOGGER.info("Read the JsonObject back into 'myJsonObject2' using a JsonReader");
            JsonReader reader = Json.createReader((Reader)new StringReader(contents));
            JsonObject myJsonObject2 = (JsonObject)reader.read();
            LOGGER.info("Compare myJsonObject1 and myJsonObject2 for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonObjects((JsonObject)myJsonObject1, (JsonObject)myJsonObject2), (String)"jsonWriterTest1 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonWriterTest1 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonWriterTest2() {
        try {
            LOGGER.info("Create sample JsonObject for testing");
            JsonObject myJsonObject1 = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Write the JsonObject 'myJsonObject1' out to a JsonWriter");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonWriter writer = Json.createWriter((OutputStream)baos);
            writer.writeObject(myJsonObject1);
            LOGGER.info("Close JsonWriter");
            baos.close();
            writer.close();
            LOGGER.info("Save contents of the JsonWriter as a String");
            String actJsonObjectText = baos.toString("UTF-8");
            LOGGER.info("Dump contents of JsonWriter as a String");
            LOGGER.info("JsonWriterContents=" + actJsonObjectText);
            LOGGER.info("Compare expected JsonObject text with actual JsonObject text for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)"{\"firstName\":\"John\",\"lastName\":\"Smith\",\"age\":25,\"elderly\":false,\"patriot\":true,\"address\":{\"streetAddress\":\"21 2nd Street\",\"city\":\"New York\",\"state\":\"NY\",\"postalCode\":\"10021\"},\"phoneNumber\":[{\"type\":\"home\",\"number\":\"212 555-1234\"},{\"type\":\"cell\",\"number\":\"646 555-4567\"}],\"objectOfFooBar\":{\"objectFooBar\":{\"foo\":\"bar\"},\"arrayFooBar\":[\"foo\",\"bar\"]},\"arrayOfFooBar\":[{\"foo\":\"bar\"},[\"foo\",\"bar\"]]}", (String)actJsonObjectText), (String)"jsonWriterTest2 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonWriterTest2 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonWriterTest3() {
        try {
            JsonArray myJsonArray2;
            LOGGER.info("Create sample JsonArray for testing");
            JsonArray myJsonArray1 = JSONP_Util.createSampleJsonArray();
            LOGGER.info("Write the JsonArray 'myJsonArray1' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((java.io.Writer)sWriter);){
                writer.writeArray(myJsonArray1);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String contents = sWriter.toString();
            LOGGER.info("Dump contents of JsonWriter as a String");
            LOGGER.info("JsonWriterContents=" + contents);
            LOGGER.info("Read the JsonArray back into 'myJsonArray2' using a JsonReader");
            try (JsonReader reader = Json.createReader((Reader)new StringReader(contents));){
                myJsonArray2 = (JsonArray)reader.read();
                LOGGER.info("Close JsonReader");
            }
            LOGGER.info("Compare myJsonArray1 and myJsonArray2 for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonArrays((JsonArray)myJsonArray1, (JsonArray)myJsonArray2), (String)"jsonWriterTest3 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonWriterTest3 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonWriterTest4() {
        try {
            LOGGER.info("Create sample JsonArray for testing");
            JsonArray myJsonArray1 = JSONP_Util.createSampleJsonArray();
            LOGGER.info("Write the JsonArray 'myJsonArray1' out to a JsonWriter");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonWriter writer = Json.createWriter((OutputStream)baos);
            writer.writeArray(myJsonArray1);
            LOGGER.info("Close JsonWriter");
            baos.close();
            writer.close();
            LOGGER.info("Save contents of the JsonWriter as a String");
            String actJsonArrayText = baos.toString("UTF-8");
            LOGGER.info("Dump contents of JsonWriter as a String");
            LOGGER.info("JsonWriterContents=" + actJsonArrayText);
            LOGGER.info("Compare expected JsonArray text with actual JsonArray text for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)"[{\"name1\":\"value1\",\"name2\":\"value2\"},true,false,null,100,200,\"string\",123456789,123456789,{\"name3\":\"value3\",\"name4\":\"value4\"},true,false,null,[2,4],{\"objectFooBar\":{\"foo\":\"bar\"},\"arrayFooBar\":[\"foo\",\"bar\"]},[{\"foo\":\"bar\"},[\"foo\",\"bar\"]]]", (String)actJsonArrayText), (String)"jsonWriterTest4 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonWriterTest4 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonWriterTest5() {
        try {
            LOGGER.info("Create sample JsonObject for testing");
            JsonObject myJsonObject1 = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Write the JsonObject 'myJsonObject1' out to a JsonWriter");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonWriter writer = Json.createWriterFactory((Map)JSONP_Util.getEmptyConfig()).createWriter((OutputStream)baos, JSONP_Util.UTF_16BE);
            writer.writeObject(myJsonObject1);
            LOGGER.info("Close JsonWriter");
            baos.close();
            writer.close();
            LOGGER.info("Save contents of the JsonWriter as a String");
            String actJsonObjectText = JSONP_Util.removeWhitespace((String)baos.toString("UTF-16BE"));
            LOGGER.info("Dump contents of JsonWriter as a String");
            LOGGER.info("JsonWriterContents=" + actJsonObjectText);
            LOGGER.info("Compare expected JsonObject text with actual JsonObject text for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)"{\"firstName\":\"John\",\"lastName\":\"Smith\",\"age\":25,\"elderly\":false,\"patriot\":true,\"address\":{\"streetAddress\":\"21 2nd Street\",\"city\":\"New York\",\"state\":\"NY\",\"postalCode\":\"10021\"},\"phoneNumber\":[{\"type\":\"home\",\"number\":\"212 555-1234\"},{\"type\":\"cell\",\"number\":\"646 555-4567\"}],\"objectOfFooBar\":{\"objectFooBar\":{\"foo\":\"bar\"},\"arrayFooBar\":[\"foo\",\"bar\"]},\"arrayOfFooBar\":[{\"foo\":\"bar\"},[\"foo\",\"bar\"]]}", (String)actJsonObjectText), (String)"jsonWriterTest5 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonWriterTest5 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonWriterTest6() {
        try {
            LOGGER.info("Create a configuration with PRETT_PRINTING enabled.");
            Map config = JSONP_Util.getPrettyPrintingConfig();
            LOGGER.info("Create sample JsonArray for testing");
            JsonArray myJsonArray1 = JSONP_Util.createSampleJsonArray();
            LOGGER.info("Write the JsonArray 'myJsonArray1' out to a JsonWriter");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonWriter writer = Json.createWriterFactory((Map)config).createWriter((OutputStream)baos, JSONP_Util.UTF_8);
            writer.writeArray(myJsonArray1);
            LOGGER.info("Close JsonWriter");
            baos.close();
            writer.close();
            LOGGER.info("Save contents of the JsonWriter as a String");
            String actJsonArrayText = JSONP_Util.removeWhitespace((String)baos.toString("UTF-8"));
            LOGGER.info("Dump contents of JsonWriter as a String");
            LOGGER.info("JsonWriterContents=" + actJsonArrayText);
            LOGGER.info("Compare expected JsonArray text with actual JsonArray text for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)"[{\"name1\":\"value1\",\"name2\":\"value2\"},true,false,null,100,200,\"string\",123456789,123456789,{\"name3\":\"value3\",\"name4\":\"value4\"},true,false,null,[2,4],{\"objectFooBar\":{\"foo\":\"bar\"},\"arrayFooBar\":[\"foo\",\"bar\"]},[{\"foo\":\"bar\"},[\"foo\",\"bar\"]]]", (String)actJsonArrayText), (String)"jsonWriterTest6 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonWriterTest6 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonWriterTest7() {
        try {
            LOGGER.info("Create sample JsonObject for testing");
            JsonObject myJsonObject1 = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Write the JsonObject 'myJsonObject1' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((java.io.Writer)sWriter);){
                writer.write((JsonStructure)myJsonObject1);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String contents = sWriter.toString();
            LOGGER.info("Dump contents of JsonWriter as a String");
            LOGGER.info("JsonWriterContents=" + contents);
            LOGGER.info("Read the JsonObject back into 'myJsonObject2' using a JsonReader");
            JsonReader reader = Json.createReader((Reader)new StringReader(contents));
            JsonObject myJsonObject2 = (JsonObject)reader.read();
            LOGGER.info("Compare myJsonObject1 and myJsonObject2 for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonObjects((JsonObject)myJsonObject1, (JsonObject)myJsonObject2), (String)"jsonWriterTest7 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonWriterTest7 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonWriterTest8() {
        try {
            LOGGER.info("Create sample JsonArray for testing");
            JsonArray myJsonArray1 = JSONP_Util.createSampleJsonArray();
            LOGGER.info("Write the JsonArray 'myJsonArray1' out to a JsonWriter");
            StringWriter sWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((java.io.Writer)sWriter);){
                writer.write((JsonStructure)myJsonArray1);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String contents = sWriter.toString();
            LOGGER.info("Dump contents of JsonWriter as a String");
            LOGGER.info("JsonWriterContents=" + contents);
            LOGGER.info("Read the JsonArray back into 'myJsonArray2' using a JsonReader");
            JsonReader reader = Json.createReader((Reader)new StringReader(contents));
            JsonArray myJsonArray2 = (JsonArray)reader.read();
            LOGGER.info("Compare myJsonArray1 and myJsonArray2 for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonArrays((JsonArray)myJsonArray1, (JsonArray)myJsonArray2), (String)"jsonWriterTest8 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonWriterTest8 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonWriterUTFEncodedTests() {
        String actJson;
        JsonWriter writer;
        ByteArrayOutputStream baos;
        boolean pass = true;
        LOGGER.info("Create expected JSON text with no whitespace for use in comparsion");
        String expJson = "{\"object\":{\"string\":\"string\",\"number\":1,\"true\":true,\"false\":false,\"null\":null},\"array\":[\"string\",1,true,false,null]}";
        try {
            LOGGER.info("-----------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createWriterFactory(Map<String,?>).createWriter(OutputStream, Charset) as UTF-8]");
            LOGGER.info("-----------------------------------------------------------------------------------------------");
            LOGGER.info("Create JsonWriter using UTF-8 encoding");
            baos = new ByteArrayOutputStream();
            writer = Json.createWriterFactory((Map)JSONP_Util.getEmptyConfig()).createWriter((OutputStream)baos, JSONP_Util.UTF_8);
            JSONP_Util.writeJsonObjectFromString((JsonWriter)writer, (String)expJson);
            LOGGER.info("Generated Output=" + baos.toString("UTF-8"));
            LOGGER.info("Read the JSON text back from OutputStream using UTF-8 encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-8"));
            if (!JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing generation to UTF-8 encoding: " + e);
        }
        try {
            LOGGER.info("------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createWriterFactory(Map<String,?>).createWriter(OutputStream, Charset) as UTF-16]");
            LOGGER.info("------------------------------------------------------------------------------------------------");
            LOGGER.info("Create JsonWriter using UTF-16 encoding");
            baos = new ByteArrayOutputStream();
            writer = Json.createWriterFactory((Map)JSONP_Util.getEmptyConfig()).createWriter((OutputStream)baos, JSONP_Util.UTF_16);
            JSONP_Util.writeJsonObjectFromString((JsonWriter)writer, (String)expJson);
            LOGGER.info("Generated Output=" + baos.toString("UTF-16"));
            LOGGER.info("Read the JSON text back from OutputStream using UTF-16 encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-16"));
            if (!JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing generation to UTF-16 encoding: " + e);
        }
        try {
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createWriterFactory(Map<String,?>).createWriter(OutputStream, Charset) as UTF-16LE]");
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("Create JsonWriter using UTF-16LE encoding");
            baos = new ByteArrayOutputStream();
            writer = Json.createWriterFactory((Map)JSONP_Util.getEmptyConfig()).createWriter((OutputStream)baos, JSONP_Util.UTF_16LE);
            JSONP_Util.writeJsonObjectFromString((JsonWriter)writer, (String)expJson);
            LOGGER.info("Generated Output=" + baos.toString("UTF-16LE"));
            LOGGER.info("Read the JSON text back from OutputStream using UTF-16LE encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-16LE"));
            if (!JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing generation to UTF-16LE encoding: " + e);
        }
        try {
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createWriterFactory(Map<String,?>).createWriter(OutputStream, Charset) as UTF-16BE]");
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("Create JsonWriter using UTF-16BE encoding");
            baos = new ByteArrayOutputStream();
            writer = Json.createWriterFactory((Map)JSONP_Util.getEmptyConfig()).createWriter((OutputStream)baos, JSONP_Util.UTF_16BE);
            JSONP_Util.writeJsonObjectFromString((JsonWriter)writer, (String)expJson);
            LOGGER.info("Generated Output=" + baos.toString("UTF-16BE"));
            LOGGER.info("Read the JSON text back from OutputStream using UTF-16BE encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-16BE"));
            if (!JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing generation to UTF-16BE encoding: " + e);
        }
        try {
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createWriterFactory(Map<String,?>).createWriter(OutputStream, Charset) as UTF-32LE]");
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("Create JsonWriter using UTF-32LE encoding");
            baos = new ByteArrayOutputStream();
            writer = Json.createWriterFactory((Map)JSONP_Util.getEmptyConfig()).createWriter((OutputStream)baos, JSONP_Util.UTF_32LE);
            JSONP_Util.writeJsonObjectFromString((JsonWriter)writer, (String)expJson);
            LOGGER.info("Generated Output=" + baos.toString("UTF-32LE"));
            LOGGER.info("Read the JSON text back from OutputStream using UTF-32LE encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-32LE"));
            if (!JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing generation to UTF-32LE encoding: " + e);
        }
        try {
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("TEST CASE [Json.createWriterFactory(Map<String,?>).createWriter(OutputStream, Charset) as UTF-32BE]");
            LOGGER.info("--------------------------------------------------------------------------------------------------");
            LOGGER.info("Create JsonWriter using UTF-32BE encoding");
            baos = new ByteArrayOutputStream();
            writer = Json.createWriterFactory((Map)JSONP_Util.getEmptyConfig()).createWriter((OutputStream)baos, JSONP_Util.UTF_32BE);
            JSONP_Util.writeJsonObjectFromString((JsonWriter)writer, (String)expJson);
            LOGGER.info("Generated Output=" + baos.toString("UTF-32BE"));
            LOGGER.info("Read the JSON text back from OutputStream using UTF-32BE encoding removing whitespace");
            actJson = JSONP_Util.removeWhitespace((String)baos.toString("UTF-32BE"));
            if (!JSONP_Util.assertEqualsJsonText((String)expJson, (String)actJson)) {
                pass = false;
            }
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Exception occurred testing generation to UTF-32BE encoding: " + e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonWriterUTFEncodedTests Failed");
    }

    @Test
    public void jsonWriterWithConfigTest1() {
        try {
            LOGGER.info("Create a configuration with PRETT_PRINTING enabled.");
            Map config = JSONP_Util.getPrettyPrintingConfig();
            LOGGER.info("Create sample JsonObject for testing");
            JsonObject myJsonObject1 = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Write the JsonObject 'myJsonObject1' out to a JsonWriter");
            StringWriter swriter = new StringWriter();
            try (JsonWriter writer = Json.createWriterFactory((Map)config).createWriter((java.io.Writer)swriter);){
                writer.writeObject(myJsonObject1);
                LOGGER.info("Close JsonWriter");
            }
            LOGGER.info("Save contents of the JsonWriter as a String");
            String actJsonObjectText = JSONP_Util.removeWhitespace((String)swriter.toString());
            LOGGER.info("Dump contents of JsonWriter as a String");
            LOGGER.info("JsonWriterContents=" + actJsonObjectText);
            LOGGER.info("Compare expected JsonObject text with actual JsonObject text for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)"{\"firstName\":\"John\",\"lastName\":\"Smith\",\"age\":25,\"elderly\":false,\"patriot\":true,\"address\":{\"streetAddress\":\"21 2nd Street\",\"city\":\"New York\",\"state\":\"NY\",\"postalCode\":\"10021\"},\"phoneNumber\":[{\"type\":\"home\",\"number\":\"212 555-1234\"},{\"type\":\"cell\",\"number\":\"646 555-4567\"}],\"objectOfFooBar\":{\"objectFooBar\":{\"foo\":\"bar\"},\"arrayFooBar\":[\"foo\",\"bar\"]},\"arrayOfFooBar\":[{\"foo\":\"bar\"},[\"foo\",\"bar\"]]}", (String)actJsonObjectText), (String)"jsonWriterWithConfigTest1 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonWriterWithConfigTest1 Failed: ", (Throwable)e);
        }
    }

    @Test
    public void jsonWriterWithConfigTest2() {
        try {
            LOGGER.info("Create a configuration with PRETT_PRINTING enabled.");
            Map config = JSONP_Util.getPrettyPrintingConfig();
            LOGGER.info("Create sample JsonArray for testing");
            JsonArray myJsonArray1 = JSONP_Util.createSampleJsonArray();
            LOGGER.info("Write the JsonArray 'myJsonArray1' out to a JsonWriter");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonWriter writer = Json.createWriterFactory((Map)config).createWriter((OutputStream)baos);
            writer.writeArray(myJsonArray1);
            LOGGER.info("Close JsonWriter");
            baos.close();
            writer.close();
            LOGGER.info("Save contents of the JsonWriter as a String");
            String actJsonArrayText = JSONP_Util.removeWhitespace((String)baos.toString("UTF-8"));
            LOGGER.info("Dump contents of JsonWriter as a String");
            LOGGER.info("JsonWriterContents=" + actJsonArrayText);
            LOGGER.info("Compare expected JsonArray text with actual JsonArray text for equality");
            Assertions.assertTrue((boolean)JSONP_Util.assertEqualsJsonText((String)"[{\"name1\":\"value1\",\"name2\":\"value2\"},true,false,null,100,200,\"string\",123456789,123456789,{\"name3\":\"value3\",\"name4\":\"value4\"},true,false,null,[2,4],{\"objectFooBar\":{\"foo\":\"bar\"},\"arrayFooBar\":[\"foo\",\"bar\"]},[{\"foo\":\"bar\"},[\"foo\",\"bar\"]]]", (String)actJsonArrayText), (String)"jsonWriterWithConfigTest2 Failed");
        }
        catch (Exception e) {
            Assertions.fail((String)"jsonWriterWithConfigTest2 Failed: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jsonWriterExceptionTests() {
        JsonObject jsonObject;
        StringWriter sWriter;
        JsonObject jsonObject2;
        StringWriter sWriter2;
        JsonArray jsonArray;
        boolean pass = true;
        JsonWriter writer = null;
        try {
            LOGGER.info("Create sample JsonArray for testing");
            jsonArray = JSONP_Util.createSampleJsonArray();
            LOGGER.info("Create JsonWriter, write something and close it");
            sWriter2 = new StringWriter();
            writer = Json.createWriter((java.io.Writer)sWriter2);
            writer.writeArray(jsonArray);
            writer.close();
            LOGGER.info("IllegalStateException if writer.close() already called before writer.writeArray(JsonArray)");
            writer.writeArray(jsonArray);
            pass = false;
            LOGGER.warning("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            LOGGER.info("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Create sample JsonArray for testing");
            jsonArray = JSONP_Util.createSampleJsonArray();
            LOGGER.info("Create JsonWriter and write out array");
            sWriter2 = new StringWriter();
            writer = Json.createWriter((java.io.Writer)sWriter2);
            writer.writeArray(jsonArray);
            LOGGER.info("IllegalStateException if writer.writeArray(JsonArray) called after writer.writeArray(JsonArray)");
            writer.writeArray(jsonArray);
            pass = false;
            LOGGER.warning("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            LOGGER.info("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        try {
            LOGGER.info("Create sample JsonArray for testing");
            jsonArray = JSONP_Util.createSampleJsonArray();
            LOGGER.info("Create sample JsonObject for testing");
            jsonObject2 = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Create JsonWriter and write out array");
            sWriter = new StringWriter();
            writer = Json.createWriter((java.io.Writer)sWriter);
            writer.writeArray(jsonArray);
            LOGGER.info("IllegalStateException if writer.writeObject(JsonObject) called after writer.writeArray(JsonArray)");
            writer.writeObject(jsonObject2);
            pass = false;
            LOGGER.warning("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            LOGGER.info("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        try {
            LOGGER.info("Create sample JsonObject for testing");
            jsonObject = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Create JsonWriter, write something and close it");
            sWriter2 = new StringWriter();
            writer = Json.createWriter((java.io.Writer)sWriter2);
            writer.writeObject(jsonObject);
            writer.close();
            LOGGER.info("IllegalStateException if writer.close() already called before writer.writeObject(JsonObject)");
            writer.writeObject(jsonObject);
            pass = false;
            LOGGER.warning("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            LOGGER.info("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Create sample JsonObject for testing");
            jsonObject = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Create JsonWriter and write out object");
            sWriter2 = new StringWriter();
            writer = Json.createWriter((java.io.Writer)sWriter2);
            writer.writeObject(jsonObject);
            LOGGER.info("IllegalStateException if writer.writeObject(JsonObject) called after writer.writeObject(JsonObject)");
            writer.writeObject(jsonObject);
            pass = false;
            LOGGER.warning("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            LOGGER.info("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        try {
            LOGGER.info("Create sample JsonArray for testing");
            jsonArray = JSONP_Util.createSampleJsonArray();
            LOGGER.info("Create sample JsonObject for testing");
            jsonObject2 = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Create JsonWriter and write out object");
            sWriter = new StringWriter();
            writer = Json.createWriter((java.io.Writer)sWriter);
            writer.writeObject(jsonObject2);
            LOGGER.info("IllegalStateException if writer.writeArray(JsonArray) called after writer.writeObject(JsonObject)");
            writer.writeArray(jsonArray);
            pass = false;
            LOGGER.warning("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            LOGGER.info("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        try {
            LOGGER.info("Create sample JsonArray for testing");
            jsonArray = JSONP_Util.createSampleJsonArray();
            LOGGER.info("Create JsonWriter, write something and close it");
            sWriter2 = new StringWriter();
            writer = Json.createWriter((java.io.Writer)sWriter2);
            writer.write((JsonStructure)jsonArray);
            writer.close();
            LOGGER.info("IllegalStateException if writer.close() already called before writer.write(JsonArray)");
            writer.write((JsonStructure)jsonArray);
            pass = false;
            LOGGER.warning("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            LOGGER.info("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Create sample JsonArray for testing");
            jsonArray = JSONP_Util.createSampleJsonArray();
            LOGGER.info("Create JsonWriter and write out array");
            sWriter2 = new StringWriter();
            writer = Json.createWriter((java.io.Writer)sWriter2);
            writer.writeArray(jsonArray);
            LOGGER.info("IllegalStateException if writer.write(JsonArray) called after writer.writeArray(JsonArray)");
            writer.write((JsonStructure)jsonArray);
            pass = false;
            LOGGER.warning("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            LOGGER.info("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        try {
            LOGGER.info("Create sample JsonObject for testing");
            jsonObject = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Create JsonWriter and write out object");
            sWriter2 = new StringWriter();
            writer = Json.createWriter((java.io.Writer)sWriter2);
            writer.writeObject(jsonObject);
            LOGGER.info("IllegalStateException if writer.write(JsonObject) called after writer.writeObject(JsonObject)");
            writer.write((JsonStructure)jsonObject);
            pass = false;
            LOGGER.warning("Failed to throw IllegalStateException");
        }
        catch (IllegalStateException e) {
            LOGGER.info("Got expected IllegalStateException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonWriterExceptionTests Failed");
    }

    @Test
    public void jsonWriterIOErrorTests() {
        JsonWriter writer;
        MyBufferedWriter mbw;
        JsonObject myJsonObject;
        boolean pass = true;
        try {
            LOGGER.info("Create sample JsonObject for testing");
            myJsonObject = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Trip JsonException if there is an i/o error on JsonWriter.close().");
            mbw = new MyBufferedWriter((java.io.Writer)new StringWriter());
            writer = Json.createWriter((java.io.Writer)mbw);
            try {
                writer.writeObject(myJsonObject);
                mbw.setThrowIOException(true);
                LOGGER.info("Calling JsonWriter.close()");
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            LOGGER.warning("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            LOGGER.info("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Create sample JsonObject for testing");
            myJsonObject = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Trip JsonException if there is an i/o error on JsonWriter.writeObject(JsonObject).");
            mbw = new MyBufferedWriter((java.io.Writer)new StringWriter());
            writer = Json.createWriter((java.io.Writer)mbw);
            try {
                mbw.setThrowIOException(true);
                LOGGER.info("Calling JsonWriter.writeObject(JsonObject)");
                writer.writeObject(myJsonObject);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            LOGGER.warning("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            LOGGER.info("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Create sample JsonArray for testing");
            JsonArray myJsonArray = JSONP_Util.createSampleJsonArray();
            LOGGER.info("Trip JsonException if there is an i/o error on JsonWriter.writeArray(JsonArray).");
            mbw = new MyBufferedWriter((java.io.Writer)new StringWriter());
            writer = Json.createWriter((java.io.Writer)mbw);
            try {
                mbw.setThrowIOException(true);
                LOGGER.info("Calling JsonWriter.writeArray(JsonArray)");
                writer.writeArray(myJsonArray);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            LOGGER.warning("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            LOGGER.info("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        try {
            LOGGER.info("Create sample JsonObject for testing");
            myJsonObject = JSONP_Util.createSampleJsonObject();
            LOGGER.info("Trip JsonException if there is an i/o error on JsonWriter.write(JsonStructure).");
            mbw = new MyBufferedWriter((java.io.Writer)new StringWriter());
            writer = Json.createWriter((java.io.Writer)mbw);
            try {
                mbw.setThrowIOException(true);
                LOGGER.info("Calling JsonWriter.write(JsonStructure)");
                writer.write((JsonStructure)myJsonObject);
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            LOGGER.warning("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            LOGGER.info("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            LOGGER.warning("Caught unexpected exception: " + e);
        }
        Assertions.assertTrue((boolean)pass, (String)"jsonWriterIOErrorTests Failed");
    }

    @Test
    public void jsonWriter11Test() {
        Writer writerTest = new Writer();
        TestResult result = writerTest.test();
        result.eval();
    }
}

