/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.api.jsonb;

import ee.jakarta.tck.json.bind.api.model.SimpleContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class JsonbTest {
    private static final String TEST_STRING = "Test String";
    private static final String TEST_JSON = "{ \"instance\" : \"Test String\" }";
    private static final byte[] TEST_JSON_BYTE = "{ \"instance\" : \"Test String\" }".getBytes(StandardCharsets.UTF_8);
    private static final String MATCHING_PATTERN = "\\{\\s*\"instance\"\\s*:\\s*\"Test\"\\s*}";
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testFromJsonStringClass() {
        SimpleContainer unmarshalledObject = (SimpleContainer)this.jsonb.fromJson(TEST_JSON, SimpleContainer.class);
        MatcherAssert.assertThat((String)"Failed to unmarshal using Jsonb.fromJson method with String and Class arguments.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)TEST_STRING));
    }

    @Test
    public void testFromJsonStringType() {
        SimpleContainer unmarshalledObject = (SimpleContainer)this.jsonb.fromJson(TEST_JSON, new SimpleContainer(){}.getClass().getGenericSuperclass());
        MatcherAssert.assertThat((String)"Failed to unmarshal using Jsonb.fromJson method with String and Type arguments.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)TEST_STRING));
    }

    @Test
    public void testFromJsonReaderClass() throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(TEST_JSON_BYTE);
             InputStreamReader reader = new InputStreamReader(stream);){
            SimpleContainer unmarshalledObject = (SimpleContainer)this.jsonb.fromJson((Reader)reader, SimpleContainer.class);
            MatcherAssert.assertThat((String)"Failed to unmarshal using Jsonb.fromJson method with Reader and Class arguments.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)TEST_STRING));
        }
    }

    @Test
    public void testFromJsonReaderType() throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(TEST_JSON_BYTE);
             InputStreamReader reader = new InputStreamReader(stream);){
            SimpleContainer unmarshalledObject = (SimpleContainer)this.jsonb.fromJson((Reader)reader, new SimpleContainer(){}.getClass().getGenericSuperclass());
            MatcherAssert.assertThat((String)"Failed to unmarshal using Jsonb.fromJson method with Reader and Type arguments.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)TEST_STRING));
        }
    }

    @Test
    public void testFromJsonStreamClass() throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(TEST_JSON_BYTE);){
            SimpleContainer unmarshalledObject = (SimpleContainer)this.jsonb.fromJson((InputStream)stream, SimpleContainer.class);
            MatcherAssert.assertThat((String)"Failed to unmarshal using Jsonb.fromJson method with InputStream and Class arguments.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)TEST_STRING));
        }
    }

    @Test
    public void testFromJsonStreamType() throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(TEST_JSON_BYTE);){
            SimpleContainer unmarshalledObject = (SimpleContainer)this.jsonb.fromJson((InputStream)stream, new SimpleContainer(){}.getClass().getGenericSuperclass());
            MatcherAssert.assertThat((String)"Failed to unmarshal using Jsonb.fromJson method with InputStream and Type arguments.", (Object)unmarshalledObject.getInstance(), (Matcher)Matchers.is((Object)TEST_STRING));
        }
    }

    @Test
    public void testToJsonObject() {
        String jsonString = this.jsonb.toJson((Object)new SimpleContainer());
        MatcherAssert.assertThat((String)"Failed to marshal using Jsonb.toJson method with Object argument.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)MATCHING_PATTERN));
    }

    @Test
    public void testToJsonObjectType() {
        String jsonString = this.jsonb.toJson((Object)new SimpleContainer(), new SimpleContainer(){}.getClass().getGenericSuperclass());
        MatcherAssert.assertThat((String)"Failed to marshal using Jsonb.toJson method with Object and Type arguments.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)MATCHING_PATTERN));
    }

    @Test
    public void testToJsonObjectWriter() throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();
             OutputStreamWriter writer = new OutputStreamWriter(stream);){
            this.jsonb.toJson((Object)new SimpleContainer(), (Writer)writer);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            MatcherAssert.assertThat((String)"Failed to marshal using Jsonb.toJson method with Object and Writer arguments.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)MATCHING_PATTERN));
        }
    }

    @Test
    public void testToJsonObjectTypeWriter() throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();
             OutputStreamWriter writer = new OutputStreamWriter(stream);){
            this.jsonb.toJson((Object)new SimpleContainer(), new SimpleContainer(){}.getClass().getGenericSuperclass(), (Writer)writer);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            MatcherAssert.assertThat((String)"Failed to marshal using Jsonb.toJson method with Object, Type and Writer arguments.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)MATCHING_PATTERN));
        }
    }

    @Test
    public void testToJsonObjectStream() throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            this.jsonb.toJson((Object)new SimpleContainer(), (OutputStream)stream);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            MatcherAssert.assertThat((String)"Failed to marshal using Jsonb.toJson method with Object and OutputStream arguments.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)MATCHING_PATTERN));
        }
    }

    @Test
    public void testToJsonObjectTypeStream() throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            this.jsonb.toJson((Object)new SimpleContainer(), new SimpleContainer(){}.getClass().getGenericSuperclass(), (OutputStream)stream);
            String jsonString = new String(stream.toByteArray(), StandardCharsets.UTF_8);
            MatcherAssert.assertThat((String)"Failed to marshal using Jsonb.toJson method with Object, Type and OutputStream arguments.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)MATCHING_PATTERN));
        }
    }
}

