/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.api.patchtests;

import ee.jakarta.tck.jsonp.api.common.JsonAssert;
import ee.jakarta.tck.jsonp.api.common.SimpleValues;
import ee.jakarta.tck.jsonp.api.common.TestResult;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonPatch;
import jakarta.json.JsonPatchBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.util.logging.Logger;

public class PatchCreate {
    private static final Logger LOGGER = Logger.getLogger(PatchCreate.class.getName());

    PatchCreate() {
    }

    TestResult test() {
        TestResult result = new TestResult("JsonPatch API factory methods added in JSON-P 1.1.");
        LOGGER.info("JsonPatch API factory methods added in JSON-P 1.1.");
        this.testCreateDiff(result);
        this.testCreatePatch(result);
        this.testCreatePatchBuilder(result);
        return result;
    }

    private void testCreateDiff(TestResult result) {
        LOGGER.info(" - Json#createDiff(JsonStructure,JsonStructure)");
        JsonObject src = SimpleValues.createSimpleObject();
        JsonObject trg = SimpleValues.createSimpleObjectWithStr();
        JsonPatch patch = Json.createDiff((JsonStructure)src, (JsonStructure)trg);
        JsonObject out = (JsonObject)patch.apply((JsonStructure)src);
        if (this.operationFailed((JsonValue)trg, (JsonValue)out)) {
            result.fail("createDiff(JsonStructure,JsonStructure)", "Builder output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)trg));
        }
    }

    private void testCreatePatch(TestResult result) {
        LOGGER.info(" - Json#createPatch(JsonArray)");
        JsonObject src = SimpleValues.createSimpleObject();
        JsonObject trg = SimpleValues.createSimpleObjectWithStr();
        JsonArray patchArray = Json.createDiff((JsonStructure)src, (JsonStructure)trg).toJsonArray();
        JsonPatch patch = Json.createPatch((JsonArray)patchArray);
        JsonObject out = (JsonObject)patch.apply((JsonStructure)src);
        if (this.operationFailed((JsonValue)trg, (JsonValue)out)) {
            result.fail("createPatch(JsonArray)", "Builder output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)trg));
        }
    }

    private void testCreatePatchBuilder(TestResult result) {
        LOGGER.info(" - Json#createPatchBuilder(JsonArray)");
        JsonObject src = SimpleValues.createSimpleObject();
        JsonObject trg = SimpleValues.createSimpleObjectWithStr();
        JsonArray patchArray = Json.createDiff((JsonStructure)src, (JsonStructure)trg).toJsonArray();
        JsonPatchBuilder patchBuilder = Json.createPatchBuilder((JsonArray)patchArray);
        JsonObject out = (JsonObject)patchBuilder.build().apply((JsonStructure)src);
        if (this.operationFailed((JsonValue)trg, (JsonValue)out)) {
            result.fail("createPatchBuilder(JsonArray)", "Builder output " + JsonAssert.valueToString((JsonValue)out) + " value shall be " + JsonAssert.valueToString((JsonValue)trg));
        }
    }

    protected boolean operationFailed(JsonValue check, JsonValue out) {
        return out == null || !JsonAssert.assertEquals(check, out);
    }
}

