/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestEnvContext;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestSuite;
import com.sun.javatest.exec.CE_StdPane;
import com.sun.javatest.exec.FileType;
import com.sun.javatest.tool.EditableFileList;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.tool.jthelp.ContextHelpManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

class CE_EnvironmentPane
extends CE_StdPane {
    private Parameters.EnvParameters envParameters;
    private Parameters.LegacyEnvParameters legacyEnvParameters;
    private TestSuite testSuite;
    private JLabel envFilesLabel;
    private EditableFileList envFilesField;
    private JFileChooser envFilesChooser;
    private JLabel envNameLabel;
    private JComboBox<String> envNameField;

    CE_EnvironmentPane(UIFactory uif, InterviewParameters config) {
        super(uif, config, "env");
        ContextHelpManager.setHelpIDString(this, "confEdit.envTab.csh");
        this.testSuite = config.getTestSuite();
        this.envParameters = config.getEnvParameters();
        this.legacyEnvParameters = this.envParameters instanceof Parameters.LegacyEnvParameters ? (Parameters.LegacyEnvParameters)this.envParameters : null;
        this.initGUI();
    }

    @Override
    boolean isOKToClose() {
        return true;
    }

    @Override
    void load() {
        if (this.legacyEnvParameters != null) {
            this.envFilesField.setItems(this.legacyEnvParameters.getEnvFiles());
            this.envNameField.setEditable(true);
            String envName = this.legacyEnvParameters.getEnvName();
            if (envName != null) {
                this.envNameField.setSelectedItem(envName);
            }
        } else {
            String name;
            this.envFilesField.clear();
            this.envFilesField.setEnabled(false);
            this.envNameField.removeAllItems();
            TestEnvironment env = this.envParameters.getEnv();
            String string = name = env == null ? null : env.getName();
            if (name == null) {
                name = this.uif.getI18NString("ce.env.noName");
            }
            this.envNameField.addItem(name);
            this.envNameField.setEnabled(false);
        }
    }

    @Override
    void save() {
        if (this.legacyEnvParameters != null) {
            this.legacyEnvParameters.setEnvFiles(this.envFilesField.getFiles());
            if (this.envNameField.isEnabled()) {
                this.legacyEnvParameters.setEnvName((String)this.envNameField.getSelectedItem());
            }
        }
    }

    private void initGUI() {
        JPanel p = this.uif.createPanel("ce.env", new GridBagLayout(), false);
        GridBagConstraints lc = new GridBagConstraints();
        lc.anchor = 13;
        lc.gridwidth = 1;
        lc.insets.right = 5;
        lc.weightx = 0.0;
        GridBagConstraints fc = new GridBagConstraints();
        fc.fill = 2;
        fc.weightx = 1.0;
        fc.gridwidth = 0;
        this.envFilesLabel = this.uif.createLabel("ce.env.envFiles", true);
        p.add((Component)this.envFilesLabel, lc);
        this.envFilesChooser = new JFileChooser();
        this.envFilesChooser.setAcceptAllFileFilterUsed(false);
        this.envFilesChooser.addChoosableFileFilter(FileType.jteFiles);
        this.envFilesChooser.setFileFilter(FileType.jteFiles);
        this.envFilesField = new EditableFileList(this.envFilesChooser){

            @Override
            public Object getNewItem() {
                File f = (File)super.getNewItem();
                if (f != null) {
                    f = CE_EnvironmentPane.this.makeTestSuiteRelative(f);
                }
                return f;
            }
        };
        this.envFilesField.setDuplicatesAllowed(false);
        this.envFilesField.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                CE_EnvironmentPane.this.envFilesChanged();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                CE_EnvironmentPane.this.envFilesChanged();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                CE_EnvironmentPane.this.envFilesChanged();
            }
        });
        this.uif.setToolTip(this.envFilesField, "ce.env.envFiles");
        this.envFilesLabel.setLabelFor(this.envFilesField);
        p.add((Component)this.envFilesField, fc);
        this.envNameLabel = this.uif.createLabel("ce.env.envName", true);
        p.add((Component)this.envNameLabel, lc);
        JPanel envNamePanel = this.uif.createPanel("ce.env.name", new GridBagLayout(), false);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        this.envNameField = this.uif.createChoice("ce.env.envName", this.envNameLabel);
        this.envNameField.addItem(this.uif.getI18NString("ce.env.noEnvs"));
        this.envNameField.setEditable(true);
        this.envNameField.setEnabled(false);
        this.envNameLabel.setLabelFor(this.envNameField);
        envNamePanel.add(this.envNameField, c);
        p.add((Component)envNamePanel, fc);
        this.addBody(p);
        if (this.legacyEnvParameters == null) {
            this.setEnabled(false);
        }
    }

    private void envFilesChanged() {
        try {
            File tsd = this.testSuite.getRootDir();
            File[] envFiles = this.envFilesField.getFiles();
            for (int i = 0; i < envFiles.length; ++i) {
                if (!envFiles[i].isAbsolute()) {
                    envFiles[i] = new File(tsd, envFiles[i].getPath());
                }
                if (envFiles[i].exists()) continue;
                this.uif.showError("ce.env.cantFindEnvFile", (Object)envFiles[i]);
            }
            TestEnvContext tec = new TestEnvContext(envFiles);
            String[] names = tec.getEnvMenuNames();
            Object[] sortedNames = new String[names.length];
            System.arraycopy(names, 0, sortedNames, 0, names.length);
            Arrays.sort(sortedNames);
            this.envNameField.removeAllItems();
            for (Object sortedName : sortedNames) {
                this.envNameField.addItem((String)sortedName);
            }
        }
        catch (TestEnvContext.Fault ex) {
            this.uif.showError("ce.env.cannotEvalEnvs", (Object)ex.getMessage());
        }
        if (this.envNameField.getItemCount() == 0) {
            this.envNameField.addItem(this.uif.getI18NString("ce.env.noEnvs"));
            this.envNameField.setEnabled(false);
        } else {
            this.envNameField.setEnabled(this.legacyEnvParameters != null);
        }
    }

    private File makeTestSuiteRelative(File file) {
        try {
            int spIndex;
            if (file.isAbsolute()) {
                return file;
            }
            String canonFilePath = file.getCanonicalPath();
            File tsd = this.testSuite.getRootDir();
            String canonTSDPath = tsd.getCanonicalPath();
            if (canonFilePath.length() > canonTSDPath.length() + 1 && canonFilePath.startsWith(canonTSDPath) && canonFilePath.charAt(canonTSDPath.length()) == File.separatorChar) {
                return new File(canonFilePath.substring(canonTSDPath.length() + 1));
            }
            StringBuilder prefix = new StringBuilder();
            String cp = canonTSDPath;
            while ((spIndex = cp.lastIndexOf(File.separatorChar)) != -1) {
                cp = cp.substring(0, spIndex);
                if (prefix.length() != 0) {
                    prefix.append(File.separator);
                }
                prefix.append("..");
                if (canonFilePath.length() <= cp.length() + 1 || !canonFilePath.startsWith(cp) || canonFilePath.charAt(cp.length()) != File.separatorChar) continue;
                File guess = new File(prefix.toString(), file.getPath());
                String canonGuessPath = new File(tsd, guess.getPath()).getCanonicalPath();
                if (!canonGuessPath.equals(canonFilePath)) break;
                return guess;
            }
            return new File(canonFilePath);
        }
        catch (IOException e) {
            this.uif.showError("ce.env.makeTSRelIOError", file, e);
            return null;
        }
    }
}

