/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.ObservableTestFilter;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestSuite;
import com.sun.javatest.exec.ConfigurableTestFilter;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.RenderingUtilities;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FilterConfig {
    private static boolean debug = Debug.getBoolean(FilterConfig.class);
    private TestFilter[] filters = new TestFilter[0];
    private UIFactory uif;
    private ExecModel execModel;
    private Listener listener = new Listener();
    private Observer[] obs = new Observer[0];
    private FilterSelectionHandler[] handlers;
    private FilterEditorPanel fep;
    private JComponent parentComponent;

    public FilterConfig(ExecModel e, JComponent parent, UIFactory uif) {
        this.execModel = e;
        this.parentComponent = parent;
        this.uif = uif;
    }

    synchronized void add(TestFilter f) {
        if (f == null) {
            return;
        }
        this.filters = DynamicArray.append(this.filters, f);
        if (f instanceof ObservableTestFilter) {
            ((ObservableTestFilter)f).addObserver(this.listener);
        }
        if (f instanceof ConfigurableTestFilter && this.fep != null) {
            this.fep.addConfigurableFilter((ConfigurableTestFilter)f);
        }
        for (Observer ob : this.obs) {
            ob.filterAdded(f);
        }
        if (this.fep != null) {
            this.fep.listModel.addElement(f);
        }
    }

    synchronized void remove(TestFilter f) {
        if (f == null) {
            return;
        }
        this.filters = DynamicArray.remove(this.filters, f);
        if (f instanceof ObservableTestFilter) {
            ((ObservableTestFilter)f).removeObserver(this.listener);
        }
        if (f instanceof ConfigurableTestFilter && this.fep != null) {
            this.fep.removeConfigurableFilter((ConfigurableTestFilter)f);
        }
        for (Observer ob : this.obs) {
            ob.filterRemoved(f);
        }
        if (this.fep != null) {
            this.fep.listModel.removeElement(f);
        }
    }

    synchronized String[] getFilterNames() {
        int count = this.filters.length;
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            names[i] = this.filters[i].getName();
        }
        return names;
    }

    synchronized TestFilter[] getFilters() {
        int count = this.filters.length;
        TestFilter[] copy = new TestFilter[count];
        System.arraycopy(this.filters, 0, copy, 0, count);
        return copy;
    }

    synchronized TestFilter getFilter(String name) {
        int count = this.filters.length;
        for (TestFilter filter : this.filters) {
            if (!name.equals(filter.getName())) continue;
            return filter;
        }
        return null;
    }

    synchronized boolean contains(TestFilter f) {
        for (TestFilter filter : this.filters) {
            if (filter != f) continue;
            return true;
        }
        return false;
    }

    synchronized FilterSelectionHandler createFilterSelectionHandler() {
        FilterSelectionHandler fsh = new FilterSelectionHandler(this, this.uif);
        this.handlers = DynamicArray.append(this.handlers, fsh);
        return fsh;
    }

    public synchronized void addObserver(Observer o) {
        if (o == null) {
            return;
        }
        if (this.obs == null) {
            this.obs = new Observer[0];
        }
        this.obs = DynamicArray.append(this.obs, o);
    }

    public synchronized void removeObserver(Observer o) {
        this.obs = DynamicArray.remove(this.obs, o);
    }

    synchronized void notifyUpdated(TestFilter f) {
        if (this.obs == null) {
            return;
        }
        for (Observer ob : this.obs) {
            ob.filterUpdated(f);
        }
    }

    synchronized void showEditorDialog() {
        if (this.fep == null) {
            this.fep = new FilterEditorPanel(this.parentComponent, this.uif);
        }
        this.fep.setVisible(true);
    }

    synchronized void showEditorDialog(TestFilter f) {
        if (this.fep == null) {
            this.fep = new FilterEditorPanel(this.parentComponent, this.uif);
        }
        this.fep.setSelectedFilter(f);
        this.fep.setVisible(true);
    }

    synchronized void hideEditorDialog(Frame parent) {
        this.fep.setVisible(false);
    }

    private class FilterEditorPanel
    extends ToolDialog
    implements ListSelectionListener,
    ActionListener {
        private static final int EDITABLE = 0;
        private static final int UNEDITABLE = 1;
        private static final String CONFIG_ACTIVE = "configa";
        private static final String CONFIG_EMPTY = "confige";
        private static final String NAMING_ACTIVE = "naminga";
        private static final String NAMING_EMPTY = "naminge";
        private static final String INFO_ACTIVE = "infoa";
        private static final String INFO_EMPTY = "infoe";
        private JSplitPane split;
        private JList<TestFilter> leftList;
        private DefaultListModel<TestFilter> listModel;
        private int lastSelected;
        private TestFilter selectedFilter;
        private int mode;
        private JButton applyBut;
        private JButton helpBut;
        private JButton doneBut;
        private JButton cancelBut;
        private JButton createBut;
        private JButton deleteBut;
        private JButton resetBut;
        private JTextArea infoDesc;
        private JTextField infoName;
        private CardLayout nameCards;
        private JPanel namePanel;
        private JTextField namingName;
        private CardLayout configCards;
        private JPanel configPanel;
        private Hashtable<ConfigurableTestFilter, String> configPanelHash;
        private int configCounter;
        private JComponent EMPTY_CONFIG;
        private JComponent EMPTY_NAMING;
        private JComponent EMPTY_INFO;
        private int NUMBER;

        FilterEditorPanel(Component parent, UIFactory uif) {
            super(parent, uif, "fconfig");
            this.lastSelected = -1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            String result = null;
            if (source == this.doneBut) {
                if (this.mode == 0) {
                    result = this.doApply();
                }
                if (result == null) {
                    this.setVisible(false);
                }
            } else if (source == this.applyBut) {
                result = this.doApply();
            } else if (source == this.resetBut) {
                if (this.mode == 0) {
                    this.doReset();
                }
            } else if (source == this.cancelBut) {
                if (this.mode == 0) {
                    this.doReset();
                }
                this.setVisible(false);
            }
            if (result != null) {
                this.uif.showError("fconfig.commit", (Object)result);
            }
        }

        void setSelectedFilter(TestFilter f) {
            if (this.listModel != null) {
                int ind = this.listModel.indexOf(f);
                if (ind >= 0) {
                    this.selectIndex(ind);
                }
            } else {
                this.selectedFilter = f;
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int newSelected = this.leftList.getSelectedIndex();
            if (newSelected < 0) {
                this.selectIndex(0);
                this.lastSelected = 0;
            } else if (newSelected != this.lastSelected) {
                this.selectIndex(newSelected);
                this.lastSelected = newSelected;
            }
        }

        private void selectIndex(int index) {
            this.leftList.setSelectedIndex(index);
            this.selectedFilter = this.listModel.get(index);
            if (this.selectedFilter instanceof ConfigurableTestFilter) {
                if (this.mode == -1 || this.mode == 1) {
                    this.nameCards.show(this.namePanel, NAMING_ACTIVE);
                    this.applyBut.setEnabled(true);
                    this.resetBut.setEnabled(true);
                    this.mode = 0;
                }
                ConfigurableTestFilter ctf = (ConfigurableTestFilter)this.selectedFilter;
                this.namingName.setText(ctf.getName());
                String cardKey = this.configPanelHash.get(ctf);
                this.configCards.show(this.configPanel, cardKey);
            } else if (this.selectedFilter instanceof TestFilter && (this.mode == -1 || this.mode == 0)) {
                this.nameCards.show(this.namePanel, NAMING_EMPTY);
                this.configCards.show(this.configPanel, CONFIG_EMPTY);
                this.applyBut.setEnabled(false);
                this.resetBut.setEnabled(false);
                this.mode = 1;
            }
            this.fillInfo(this.selectedFilter);
            this.leftList.requestFocus();
        }

        @Override
        protected void initGUI() {
            this.setHelp("execFilters.dialog.csh");
            TestSuite ts = FilterConfig.this.execModel.getTestSuite();
            String tsName = ts == null ? this.uif.getI18NString("fconfig.dTitle.unknown") : ts.getName();
            this.setI18NTitle("fconfig.dTitle", (Object)tsName);
            JPanel body = this.uif.createPanel("fe.body", false);
            body.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 3;
            gbc.anchor = 18;
            gbc.insets.left = 10;
            gbc.insets.right = 10;
            gbc.weighty = 1.0;
            gbc.weightx = 0.0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            this.leftList = this.uif.createList("fconfig.list");
            this.leftList.setModel(this.createListModel());
            this.leftList.setCellRenderer(RenderingUtilities.createFilterListRenderer());
            this.leftList.addListSelectionListener(this);
            this.leftList.setBorder(BorderFactory.createEtchedBorder());
            this.leftList.getInsets().left = 5;
            this.leftList.getInsets().right = 5;
            this.uif.setAccessibleInfo(this.leftList, "fconfig.list");
            JPanel spacer = new JPanel();
            spacer.setBorder(this.uif.createTitledBorder("fconfig.list"));
            spacer.setLayout(new BorderLayout());
            spacer.add(this.leftList, "Center");
            body.add((Component)spacer, gbc);
            gbc.weightx = 1.0;
            gbc.fill = 1;
            gbc.gridx = 1;
            JComponent rightPanel = this.createRightPanel();
            body.add((Component)rightPanel, gbc);
            int dpi = this.uif.getDotsPerInch();
            body.setPreferredSize(new Dimension(7 * dpi, 5 * dpi));
            this.setBody(body);
            this.initButtons();
            this.setComponentListener(FilterConfig.this.listener);
            this.mode = -1;
            if (this.selectedFilter != null) {
                this.setSelectedFilter(this.selectedFilter);
            } else {
                this.selectIndex(0);
            }
        }

        private ListModel<TestFilter> createListModel() {
            this.listModel = new DefaultListModel();
            for (TestFilter filter : FilterConfig.this.filters) {
                this.listModel.addElement(filter);
            }
            return this.listModel;
        }

        private JComponent createRightPanel() {
            this.EMPTY_CONFIG = this.createEmptyItem("fconfig.empt.conf");
            this.EMPTY_NAMING = this.createEmptyItem("fconfig.empt.name");
            this.EMPTY_CONFIG.setName("config");
            this.EMPTY_NAMING.setName("naming");
            JPanel pan = new JPanel(new GridBagLayout());
            pan.setName("rightFilter");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = -1;
            gbc.fill = 1;
            gbc.anchor = 11;
            gbc.insets.left = 10;
            gbc.insets.right = 10;
            gbc.weighty = 0.0;
            gbc.weightx = 1.0;
            JComponent nextPanel = this.createInfoPanel();
            nextPanel.setBorder(this.uif.createTitledBorder("fconfig.panel.info"));
            pan.add((Component)nextPanel, gbc);
            nextPanel = this.createNamingPanel();
            nextPanel.setBorder(this.uif.createTitledBorder("fconfig.panel.naming"));
            pan.add((Component)nextPanel, gbc);
            nextPanel = this.createConfigPanel();
            nextPanel.setBorder(this.uif.createTitledBorder("fconfig.panel.config"));
            gbc.weighty = 1.0;
            pan.add((Component)nextPanel, gbc);
            return pan;
        }

        private JComponent createEmptyItem(String uikey) {
            JTextField item = this.uif.createHeading(uikey);
            this.uif.setAccessibleInfo(item, uikey);
            item.setHorizontalAlignment(0);
            return item;
        }

        private JComponent createInfoPanel() {
            JPanel pan = new JPanel(new GridBagLayout());
            pan.setName("info");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 5.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 0;
            gbc.anchor = 13;
            gbc.insets.left = 15;
            gbc.insets.right = 15;
            JLabel lab = this.uif.createLabel("fconfig.info.name");
            this.infoName = this.uif.createOutputField("fconfig.info.name", lab);
            this.infoName.setEditable(false);
            this.infoName.setBorder(BorderFactory.createEmptyBorder());
            lab.setDisplayedMnemonic(this.uif.getI18NString("fconfig.info.name.mne").charAt(0));
            lab.setHorizontalAlignment(4);
            pan.add((Component)lab, gbc);
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.anchor = 17;
            pan.add((Component)this.infoName, gbc);
            lab = this.uif.createLabel("fconfig.info.desc");
            lab.setHorizontalAlignment(4);
            this.infoDesc = this.uif.createTextArea("fconfig.info.desc", lab);
            this.infoDesc.setRows(3);
            this.infoDesc.setEditable(false);
            this.infoDesc.setBorder(BorderFactory.createEmptyBorder());
            this.infoDesc.setLineWrap(true);
            this.infoDesc.setWrapStyleWord(true);
            this.infoDesc.setBackground(UIFactory.Colors.TRANSPARENT.getValue());
            this.infoDesc.setOpaque(false);
            lab.setDisplayedMnemonic(this.uif.getI18NString("fconfig.info.desc.mne").charAt(0));
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.fill = 0;
            gbc.anchor = 12;
            pan.add((Component)lab, gbc);
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.anchor = 17;
            pan.add((Component)this.infoDesc, gbc);
            return pan;
        }

        private JPanel createNamingPanel() {
            this.nameCards = new CardLayout();
            this.namePanel = new JPanel(this.nameCards);
            JPanel pan = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 5.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 0;
            gbc.anchor = 13;
            gbc.insets.left = 15;
            gbc.insets.right = 15;
            JLabel lab = this.uif.createLabel("fconfig.naming.name");
            this.namingName = this.uif.createOutputField("fconfig.naming.name", lab);
            this.namingName.setEditable(true);
            this.namingName.setEnabled(true);
            lab.setDisplayedMnemonic(this.uif.getI18NString("fconfig.naming.name.mne").charAt(0));
            lab.setHorizontalAlignment(4);
            pan.add((Component)lab, gbc);
            gbc.gridx = 1;
            gbc.fill = 2;
            pan.add((Component)this.namingName, gbc);
            this.namePanel.add(NAMING_ACTIVE, pan);
            this.namePanel.add(NAMING_EMPTY, this.EMPTY_NAMING);
            this.nameCards.show(this.namePanel, NAMING_EMPTY);
            return this.namePanel;
        }

        private JPanel createConfigPanel() {
            this.configCards = new CardLayout();
            this.configPanel = new JPanel(this.configCards);
            this.configPanelHash = new Hashtable();
            this.configPanel.add(CONFIG_EMPTY, this.EMPTY_CONFIG);
            for (int i = 0; i < this.listModel.getSize(); ++i) {
                if (!(this.listModel.getElementAt(i) instanceof ConfigurableTestFilter)) continue;
                ConfigurableTestFilter ctf = (ConfigurableTestFilter)this.listModel.getElementAt(i);
                this.addConfigurableFilter(ctf);
            }
            return this.configPanel;
        }

        private void initButtons() {
            this.applyBut = this.uif.createButton("fconfig.edit.apply", this);
            this.resetBut = this.uif.createButton("fconfig.edit.reset", this);
            this.cancelBut = this.uif.createCancelButton("fconfig.edit.cancel", this);
            this.doneBut = this.uif.createButton("fconfig.edit.done", this);
            this.helpBut = this.uif.createHelpButton("fconfig.edit.help", "execFilters.dialog.csh");
            this.setButtons(new JButton[]{this.applyBut, this.resetBut, this.cancelBut, this.doneBut, this.helpBut}, this.doneBut);
        }

        private void addConfigurableFilter(ConfigurableTestFilter ctf) {
            JComponent comp = ctf.getEditorPane();
            String thisName = "ctf" + ++this.configCounter;
            if (comp != null) {
                this.configPanel.add(thisName, comp);
            } else {
                this.configPanel.add(thisName, this.EMPTY_CONFIG);
            }
            this.configPanelHash.put(ctf, thisName);
        }

        private void removeConfigurableFilter(ConfigurableTestFilter ctf) {
            this.configPanelHash.remove(ctf);
        }

        private void fillInfo(TestFilter f) {
            if (f == null) {
                return;
            }
            if (f instanceof ConfigurableTestFilter) {
                this.infoName.setText(((ConfigurableTestFilter)f).getBaseName());
            } else {
                this.infoName.setText(f.getName());
            }
            this.infoDesc.setText(f.getDescription());
        }

        private void fillNaming(ConfigurableTestFilter f) {
            this.namingName.setText(f.getName());
        }

        private String doApply() {
            if (this.mode == 1) {
                throw new IllegalStateException("filter is uneditable, cannot apply changes");
            }
            ConfigurableTestFilter ctf = (ConfigurableTestFilter)this.selectedFilter;
            String newName = this.namingName.getText();
            if (this.validateName(newName) != -1) {
                return this.uif.getI18NString("fconfig.edit.badName", (Object)newName);
            }
            if (newName != null) {
                ctf.setInstanceName(newName);
            }
            String status = ctf.commitEditorSettings();
            if (FilterConfig.this.handlers != null) {
                for (FilterSelectionHandler handler : FilterConfig.this.handlers) {
                    handler.updateFilterMetaInfo(ctf);
                }
            }
            return status;
        }

        void doReset() {
            for (int i = 0; i < this.listModel.getSize(); ++i) {
                if (!(this.listModel.get(i) instanceof ConfigurableTestFilter)) continue;
                ConfigurableTestFilter ctf = (ConfigurableTestFilter)this.listModel.get(i);
                ctf.resetEditorSettings();
            }
        }

        private int validateName(String text) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.' || c == ' ' || c == ',') continue;
                return i;
            }
            return -1;
        }
    }

    private class Listener
    extends ComponentAdapter
    implements ObservableTestFilter.Observer {
        private Listener() {
        }

        @Override
        public void filterUpdated(ObservableTestFilter otf) {
            FilterConfig.this.notifyUpdated(otf);
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            FilterConfig.this.fep.doReset();
        }
    }

    public static interface Observer {
        public void filterUpdated(TestFilter var1);

        public void filterAdded(TestFilter var1);

        public void filterRemoved(TestFilter var1);
    }
}

