/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.mediatype;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.MediaType;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 3136740904552966415L;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void constructorTest1() throws JAXRSCommonClient.Fault {
        String type = "*";
        String subtype = "*";
        MediaType mt1 = new MediaType();
        JAXRSClientIT.verifyMediaType(mt1, type, subtype);
    }

    @Test
    public void constructorTest2() throws JAXRSCommonClient.Fault {
        String type = "application";
        String subtype = "atom+xml";
        MediaType mt2 = new MediaType(type, subtype);
        JAXRSClientIT.verifyMediaType(mt2, type, subtype);
    }

    @Test
    public void constructorTest3() throws JAXRSCommonClient.Fault {
        String type = "application";
        String subtype = "x-www-form-urlencoded";
        HashMap<String, String> params = new HashMap<String, String>();
        MediaType mt3 = new MediaType(type, subtype, params);
        JAXRSClientIT.verifyMediaType(mt3, type, subtype, params, new String[0]);
    }

    @Test
    public void constructorStringStringStringTest() throws JAXRSCommonClient.Fault {
        String[] charsets;
        String type = MediaType.APPLICATION_FORM_URLENCODED_TYPE.getType();
        String subtype = MediaType.APPLICATION_FORM_URLENCODED_TYPE.getSubtype();
        for (String charset : charsets = new String[]{"UTF-8", "ISO-8859-2", "UTF-16", null}) {
            MediaType mt = new MediaType(type, subtype, charset);
            JAXRSClientIT.verifyMediaType(mt, type, subtype);
            if (charset == null) continue;
            JAXRSClientIT.assertCharset(mt, charset);
        }
    }

    @Test
    public void isCompatibleTest1() throws JAXRSCommonClient.Fault {
        String type = "text";
        String subtype = "plain";
        MediaType mt3 = new MediaType(type, subtype);
        if (!mt3.isCompatible(MediaType.TEXT_PLAIN_TYPE)) {
            throw new JAXRSCommonClient.Fault("isCompatible test failed.");
        }
    }

    @Test
    public void isCompatibleTest2() throws JAXRSCommonClient.Fault {
        String type = "text";
        String subtype = "plain";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("charset", "iso-8859-1");
        MediaType mt5 = new MediaType(type, subtype);
        MediaType mt6 = new MediaType(type, subtype, params);
        if (!mt5.isCompatible(mt6)) {
            throw new JAXRSCommonClient.Fault("isCompatible test failed: Expecting " + mt5.toString() + ", got " + mt6.toString());
        }
    }

    @Test
    public void isCompatibleTest3() throws JAXRSCommonClient.Fault {
        String type = "text";
        String subtype = "plain";
        MediaType mt5 = new MediaType(type, subtype);
        String subtype1 = "html";
        MediaType mt6 = new MediaType(type, subtype1);
        if (mt5.isCompatible(mt6)) {
            throw new JAXRSCommonClient.Fault("isCompatible test failed: Expecting " + mt5.toString() + ", got " + mt6.toString());
        }
    }

    @Test
    public void hashCodeTest1() throws JAXRSCommonClient.Fault {
        String type = "text";
        String subtype = "plain";
        MediaType mt3 = new MediaType(type, subtype);
        if (mt3.hashCode() != MediaType.TEXT_PLAIN_TYPE.hashCode()) {
            throw new JAXRSCommonClient.Fault("hashCode test failed. Expecting " + mt3.hashCode() + ", got " + MediaType.TEXT_PLAIN_TYPE.hashCode());
        }
    }

    @Test
    public void hashCodeTest2() throws JAXRSCommonClient.Fault {
        String type = "text";
        String subtype = "plain";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("charset", "iso-8859-1");
        MediaType mt5 = new MediaType(type, subtype);
        MediaType mt6 = new MediaType(type, subtype, params);
        if (mt5.hashCode() == mt6.hashCode()) {
            throw new JAXRSCommonClient.Fault("hashCode test failed. Expecting different hashCode than " + mt5.hashCode() + ", got the same");
        }
    }

    @Test
    public void hashCodeTest3() throws JAXRSCommonClient.Fault {
        int hc1;
        String type = "text";
        String subtype = "plain";
        String subtype1 = "html";
        MediaType mt5 = new MediaType(type, subtype);
        MediaType mt6 = new MediaType(type, subtype1);
        int hc = mt5.hashCode();
        if (hc == (hc1 = mt6.hashCode())) {
            throw new JAXRSCommonClient.Fault("hashCode test failed: Expecting " + mt5.toString() + ", got " + mt6.toString());
        }
    }

    @Test
    public void equalsTest1() throws JAXRSCommonClient.Fault {
        String type = "text";
        String subtype = "html";
        MediaType mt4 = new MediaType(type, subtype);
        if (!mt4.equals((Object)MediaType.TEXT_HTML_TYPE)) {
            throw new JAXRSCommonClient.Fault("Equals test failedExpecting " + MediaType.TEXT_PLAIN_TYPE.toString() + ", got " + mt4.toString());
        }
    }

    @Test
    public void equalsTest2() throws JAXRSCommonClient.Fault {
        String type = "application";
        String subtype = "xml";
        MediaType mt7 = new MediaType(type, subtype);
        String type1 = "Application";
        String subtype1 = "XML";
        MediaType mt8 = new MediaType(type1, subtype1);
        if (!mt7.equals((Object)mt8)) {
            throw new JAXRSCommonClient.Fault("Equals test failedExpecting " + mt7.toString() + ", got " + mt8.toString());
        }
    }

    @Test
    public void equalsTest3() throws JAXRSCommonClient.Fault {
        String type = "application";
        String subtype = "svg+xml";
        MediaType mt5 = new MediaType(type, subtype);
        HashMap params = new HashMap();
        MediaType mt6 = new MediaType(type, subtype, params);
        if (!mt5.equals((Object)mt6)) {
            throw new JAXRSCommonClient.Fault("Equals test failedExpecting " + mt5.toString() + ", got " + mt6.toString());
        }
    }

    @Test
    public void equalsTest4() throws JAXRSCommonClient.Fault {
        String type = "text";
        String subtype = "plain";
        HashMap params = new HashMap();
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("charset", "iso-8859-1");
        MediaType mt5 = new MediaType(type, subtype, params);
        MediaType mt6 = new MediaType(type, subtype, params1);
        if (mt5.equals((Object)mt6)) {
            throw new JAXRSCommonClient.Fault("Equals test failedExpecting " + mt5.toString() + ", got " + mt6.toString());
        }
    }

    @Test
    public void toStringTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        String type = "text";
        String subtype = "plain";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("charset", "iso-8859-1");
        MediaType mt6 = new MediaType(type, subtype, params);
        String to_verify = mt6.toString();
        if (!to_verify.toLowerCase().contains(type)) {
            pass = false;
            sb.append("Type is missing");
        }
        if (!to_verify.toLowerCase().contains(subtype)) {
            pass = false;
            sb.append("Subtype is missing");
        }
        if (!to_verify.toLowerCase().contains("char")) {
            pass = false;
            sb.append("Parameter's name is missing");
        }
        if (!to_verify.toLowerCase().contains("iso-8859-1")) {
            pass = false;
            sb.append("Parameter's value is missing");
        }
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion failed: " + sb.toString()));
    }

    @Test
    public void wildcardTest() throws JAXRSCommonClient.Fault {
        boolean pass = true;
        StringBuffer sb = new StringBuffer();
        MediaType mt2 = new MediaType();
        if (!mt2.isWildcardType()) {
            pass = false;
            sb.append("Failed WildcardType test");
        }
        if (!mt2.isWildcardSubtype()) {
            pass = false;
            sb.append("Failed WildcardSubtype test");
        }
        Assertions.assertTrue((boolean)pass, (String)("At least one assertion failed: " + sb.toString()));
    }

    @Test
    public void valueOfTest() throws JAXRSCommonClient.Fault {
        String type = "text";
        String subtype = "plain";
        String toParse = "text/plain; charset=us-ascii";
        MediaType mt10 = MediaType.valueOf((String)toParse);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("charset", "us-ascii");
        String[] pname = new String[]{"charset"};
        JAXRSClientIT.verifyMediaType(mt10, type, subtype, params, pname);
    }

    @Test
    public void valueOfTest1() throws JAXRSCommonClient.Fault {
        try {
            MediaType.valueOf(null);
            throw new JAXRSCommonClient.Fault("Expected IllegalArgumentException now thrown.  Test Failed");
        }
        catch (IllegalArgumentException ilex) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected");
            return;
        }
    }

    @Test
    public void withCharsetTest() throws JAXRSCommonClient.Fault {
        String type = MediaType.APPLICATION_FORM_URLENCODED_TYPE.getType();
        String subtype = MediaType.APPLICATION_FORM_URLENCODED_TYPE.getSubtype();
        MediaType original = new MediaType(type, subtype);
        String[] charsets = new String[]{"UTF-8", "ISO-8859-2", "UTF-16", null};
        for (int i = 0; i != charsets.length - 1; ++i) {
            Assertions.assertTrue((!original.toString().toLowerCase().contains(charsets[i].toLowerCase()) ? 1 : 0) != 0);
        }
        for (String charset : charsets) {
            MediaType created = original.withCharset(charset);
            JAXRSClientIT.verifyMediaType(created, type, subtype);
            if (charset == null) continue;
            Assertions.assertTrue((!original.toString().toLowerCase().contains(charset.toLowerCase()) ? 1 : 0) != 0);
            JAXRSClientIT.assertContainsIgnoreCase(created.toString(), charset, new Object[]{"MediaType", created, "does not contain expected character set", charset});
            JAXRSClientIT.logMsg("MediaType", created, "contains expected character set", charset);
        }
    }

    @Test
    public void withCharsetNullOrEmptyCharsetTest() throws JAXRSCommonClient.Fault {
        String charset = "UTF-8";
        String type = MediaType.APPLICATION_FORM_URLENCODED_TYPE.getType();
        String subtype = MediaType.APPLICATION_FORM_URLENCODED_TYPE.getSubtype();
        MediaType original = new MediaType(type, subtype, charset);
        for (String newCharset : new String[]{null, ""}) {
            MediaType created = original.withCharset(newCharset);
            JAXRSClientIT.verifyMediaType(created, type, subtype);
            Assertions.assertTrue((created != original ? 1 : 0) != 0, (String)"withCharset(null) did NOT create a new instance");
            JAXRSClientIT.assertCharset(created, charset);
            JAXRSClientIT.assertCharset(original, charset);
        }
    }

    private static void assertCharset(MediaType mediaType, String charset) throws JAXRSCommonClient.Fault {
        String characterSet = "charset=" + charset;
        JAXRSClientIT.assertContainsIgnoreCase(mediaType.toString(), characterSet, new Object[]{"MediaType", mediaType, "does not contain expected", characterSet});
        JAXRSClientIT.logMsg("MediaType", mediaType, "contains character set", characterSet, "as expected");
    }

    private static void verifyMediaType(MediaType mt, String type, String subtype) throws JAXRSCommonClient.Fault {
        StringBuffer sb = new StringBuffer();
        boolean pass = true;
        if (!mt.getType().equals(type)) {
            pass = false;
            sb.append("Failed type test.  Expect " + type + " got " + mt.getType());
        }
        if (!mt.getSubtype().equals(subtype)) {
            pass = false;
            sb.append("Failed subtype test.  Expect " + type + " got " + mt.getSubtype());
        }
        Assertions.assertTrue((boolean)pass, (String)("at least one assertion failed: " + sb.toString()));
    }

    private static void verifyMediaType(MediaType mt, String type, String subtype, Map<String, String> params, String[] pname) throws JAXRSCommonClient.Fault {
        StringBuffer sb = new StringBuffer();
        boolean pass = true;
        if (!mt.getType().equals(type)) {
            pass = false;
            sb.append("Failed type test.  Expect " + type + " got " + mt.getType());
        }
        if (!mt.getSubtype().equals(subtype)) {
            pass = false;
            sb.append("Failed subtype test.  Expect " + type + " got " + mt.getSubtype());
        }
        Map param_actual = mt.getParameters();
        if (params.size() != param_actual.size()) {
            pass = false;
            sb.append("Parameters size are different.  Expecting " + params.size() + ", got " + param_actual.size() + ".");
        }
        int i = pname.length;
        int j = 0;
        while (j < i) {
            sb.append("Processing Parameter " + j);
            if (!param_actual.containsKey(pname[j])) {
                pass = false;
                sb.append("Parameter Key " + pname[j] + " not found.");
            } else {
                String tmp = (String)param_actual.get(pname[j]);
                if (tmp.equals(params.get(pname[j])) || tmp.startsWith("\"") || tmp.equals("\"" + params.get(pname[j]) + "\"")) break;
                pass = false;
                sb.append("Parameter Key " + pname[j] + " returned different value than expected.");
                sb.append("expecting " + params.get(pname[j]) + ", got " + (String)param_actual.get(pname[j]));
                ++j;
            }
            Assertions.assertTrue((boolean)pass, (String)("at least one assertion failed:" + sb.toString()));
        }
    }
}

