/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.client.entity;

import ee.jakarta.tck.ws.rs.api.client.entity.AnnotatedClass;
import ee.jakarta.tck.ws.rs.api.client.entity.SerializableClass;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Variant;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Locale;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 3872631127958907381L;
    static final String[] ENTITY_VALUES = new String[]{"string", "inputstream", "serializable", "stringbuilder", "stringbuffer"};
    static final Locale[] LANGUAGES = new Locale[]{Locale.FRENCH, Locale.GERMAN};
    static final String[] ENCODINGS = new String[]{"UTF-16", "ISO-8859-2", "CP1250"};

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void entityMediaTypeTest() throws JAXRSCommonClient.Fault {
        MediaType[] mTypes;
        for (MediaType type : mTypes = this.getMediaTypes(MediaType.class)) {
            Entity entity = Entity.entity((Object)"entity", (MediaType)type);
            this.assertEntity(entity, "entity");
            this.assertMediaType(entity, type.toString());
        }
    }

    @Test
    public void entityMediaTypeGetEntityTest() throws JAXRSCommonClient.Fault {
        Object[] entities = this.getEntities();
        for (int i = 0; i != ENTITY_VALUES.length; ++i) {
            Entity entity = Entity.entity((Object)entities[i], (MediaType)MediaType.WILDCARD_TYPE);
            this.assertEntity(entity, ENTITY_VALUES[i]);
        }
    }

    @Test
    public void entityMediaTypeAnnotationsTest() throws JAXRSCommonClient.Fault {
        MediaType[] mTypes = this.getMediaTypes(MediaType.class);
        Annotation[] annotations = AnnotatedClass.class.getAnnotations();
        for (MediaType type : mTypes) {
            Entity entity = Entity.entity((Object)"entity", (MediaType)type, (Annotation[])annotations);
            this.assertEntity(entity, "entity");
            this.assertMediaType(entity, type.toString());
            this.assertAnnotations(entity, annotations);
        }
    }

    @Test
    public void entityMediaTypeAnnotationsDifferentEntitiesTest() throws JAXRSCommonClient.Fault {
        Annotation[] annotations = AnnotatedClass.class.getAnnotations();
        Object[] entities = this.getEntities();
        for (int i = 0; i != ENTITY_VALUES.length; ++i) {
            Entity entity = Entity.entity((Object)entities[i], (MediaType)MediaType.WILDCARD_TYPE, (Annotation[])annotations);
            this.assertEntity(entity, ENTITY_VALUES[i]);
            this.assertMediaType(entity, "*/*");
            this.assertAnnotations(entity, annotations);
        }
    }

    @Test
    public void entityStringTest() throws JAXRSCommonClient.Fault {
        String[] mTypes;
        for (String type : mTypes = this.getMediaTypes(String.class)) {
            Entity entity = Entity.entity((Object)"entity", (String)type);
            this.assertEntity(entity, "entity");
            this.assertMediaType(entity, type);
        }
    }

    @Test
    public void entityStringGetEntityTest() throws JAXRSCommonClient.Fault {
        Object[] entities = this.getEntities();
        for (int i = 0; i != ENTITY_VALUES.length; ++i) {
            Entity entity = Entity.entity((Object)entities[i], (String)"*/*");
            this.assertEntity(entity, ENTITY_VALUES[i]);
        }
    }

    @Test
    public void entityStringThrowsExceptionWhenNullTest() throws JAXRSCommonClient.Fault {
        try {
            Entity.entity((Object)"entity", (String)null);
            throw new JAXRSCommonClient.Fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected");
            return;
        }
    }

    @Test
    public void entityStringThrowsExceptionWhenUnparsableTest() throws JAXRSCommonClient.Fault {
        try {
            Entity.entity((Object)"entity", (String)"\\//\\");
            throw new JAXRSCommonClient.Fault("IllegalArgumentException has not been thrown");
        }
        catch (IllegalArgumentException e) {
            JAXRSClientIT.logMsg("IllegalArgumentException has been thrown as expected");
            return;
        }
    }

    @Test
    public void entityVariantTest() throws JAXRSCommonClient.Fault {
        Object[] pairs = this.getEntities();
        MediaType[] media = this.getMediaTypes(MediaType.class);
        for (int i = 0; i != pairs.length; ++i) {
            for (int j = 0; j != media.length; ++j) {
                for (int k = 0; k != LANGUAGES.length; ++k) {
                    for (int l = 0; l != ENCODINGS.length; ++l) {
                        Variant variant = new Variant(media[j], LANGUAGES[k], ENCODINGS[l]);
                        Entity entity = Entity.entity((Object)pairs[i], (Variant)variant);
                        this.assertEntity(entity, ENTITY_VALUES[i]);
                        this.assertMediaType(entity, media[j].toString());
                        this.assertLanguages(entity, LANGUAGES[k]);
                        this.assertEncoding(entity, ENCODINGS[l]);
                        this.assertVariant(entity, variant);
                    }
                }
            }
        }
    }

    @Test
    public void entityVariantAnnotationsTest() throws JAXRSCommonClient.Fault {
        Object[] pairs = this.getEntities();
        MediaType[] media = this.getMediaTypes(MediaType.class);
        Annotation[] annotations = AnnotatedClass.class.getAnnotations();
        for (int i = 0; i != pairs.length; ++i) {
            for (int j = 0; j != media.length; ++j) {
                for (int k = 0; k != LANGUAGES.length; ++k) {
                    for (int l = 0; l != ENCODINGS.length; ++l) {
                        Variant variant = new Variant(media[j], LANGUAGES[k], ENCODINGS[l]);
                        Entity entity = Entity.entity((Object)pairs[i], (Variant)variant, (Annotation[])annotations);
                        JAXRSClientIT.logMsg(pairs[i], media[j], LANGUAGES[k], ENCODINGS[l]);
                        this.assertEntity(entity, ENTITY_VALUES[i]);
                        this.assertMediaType(entity, media[j].toString());
                        this.assertLanguages(entity, LANGUAGES[k]);
                        this.assertEncoding(entity, ENCODINGS[l]);
                        this.assertVariant(entity, variant);
                        this.assertAnnotations(entity, annotations);
                    }
                }
            }
        }
    }

    @Test
    public void formFormTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.form((Form)new Form());
        this.assertMediaType(entity, "application/x-www-form-urlencoded");
    }

    @Test
    public void formMultivaluedMapTest() throws JAXRSCommonClient.Fault {
        Entity entity = Entity.form((MultivaluedMap)new MultivaluedHashMap());
        this.assertMediaType(entity, "application/x-www-form-urlencoded");
    }

    @Test
    public void htmlTest() throws JAXRSCommonClient.Fault {
        Object[] entities = this.getEntities();
        for (int i = 0; i != entities.length; ++i) {
            Entity entity = Entity.html((Object)entities[i]);
            this.assertMediaType(entity, "text/html");
            this.assertEntity(entity, ENTITY_VALUES[i]);
        }
    }

    @Test
    public void jsonTest() throws JAXRSCommonClient.Fault {
        Object[] entities = this.getEntities();
        for (int i = 0; i != entities.length; ++i) {
            Entity entity = Entity.json((Object)entities[i]);
            this.assertMediaType(entity, "application/json");
            this.assertEntity(entity, ENTITY_VALUES[i]);
        }
    }

    @Test
    public void textTest() throws JAXRSCommonClient.Fault {
        Object[] entities = this.getEntities();
        for (int i = 0; i != entities.length; ++i) {
            Entity entity = Entity.text((Object)entities[i]);
            this.assertMediaType(entity, "text/plain");
            this.assertEntity(entity, ENTITY_VALUES[i]);
        }
    }

    @Test
    public void xhtmlTest() throws JAXRSCommonClient.Fault {
        Object[] entities = this.getEntities();
        for (int i = 0; i != entities.length; ++i) {
            Entity entity = Entity.xhtml((Object)entities[i]);
            this.assertMediaType(entity, "application/xhtml+xml");
            this.assertEntity(entity, ENTITY_VALUES[i]);
        }
    }

    @Test
    public void xmlTest() throws JAXRSCommonClient.Fault {
        Object[] entities = this.getEntities();
        for (int i = 0; i != entities.length; ++i) {
            Entity entity = Entity.xml((Object)entities[i]);
            this.assertMediaType(entity, "application/xml");
            this.assertEntity(entity, ENTITY_VALUES[i]);
        }
    }

    protected <T> void assertEntity(Entity<T> entity, String original) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((boolean)entity.getEntity().toString().contains(original), (String)(entity.getEntity().toString() + " does not contain expected " + original));
        JAXRSClientIT.logMsg("Found expected", original);
    }

    protected <T> void assertMediaType(Entity<T> entity, String original) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((boolean)entity.getMediaType().toString().equals(original), (String)("MediaType retrieved from entity " + entity.getMediaType() + " differes from " + original));
        JAXRSClientIT.logMsg("Sucessfully retrieved MediaType", original);
    }

    protected <T> void assertAnnotation(Entity<T> entity, Annotation original) throws JAXRSCommonClient.Fault {
        Comparator<Annotation> comparator = new Comparator<Annotation>(){

            @Override
            public int compare(Annotation o1, Annotation o2) {
                return o1.toString().compareTo(o2.toString());
            }
        };
        Annotation[] annotations = entity.getAnnotations();
        Arrays.sort(annotations, comparator);
        int index = Arrays.binarySearch(annotations, original, comparator);
        Assertions.assertTrue((index != -1 ? 1 : 0) != 0, (String)("Annotation " + original + " not found"));
        JAXRSClientIT.logMsg("Sucessfully retrieved Annotation", original);
    }

    protected <T> void assertAnnotations(Entity<T> entity, Annotation[] original) throws JAXRSCommonClient.Fault {
        for (Annotation annotation : original) {
            this.assertAnnotation(entity, annotation);
        }
    }

    protected <T> void assertLanguages(Entity<T> entity, Locale original) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((boolean)entity.getLanguage().equals(original), (String)("Language retrieved from entity " + entity.getLanguage() + " differes from " + original));
        JAXRSClientIT.logMsg("Sucessfully retrieved Language", original);
    }

    protected <T> void assertEncoding(Entity<T> entity, String original) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((boolean)entity.getEncoding().equals(original), (String)("Encoding retrieved from entity " + entity.getEncoding() + " differes from " + original));
        JAXRSClientIT.logMsg("Sucessfully retrieved Encoding", original);
    }

    protected <T> void assertVariant(Entity<T> entity, Variant original) throws JAXRSCommonClient.Fault {
        Assertions.assertTrue((entity.getVariant() == original ? 1 : 0) != 0, (String)("Variant retrieved from entity " + entity.getVariant() + " differes from " + original));
        JAXRSClientIT.logMsg("Sucessfully retrieved Variant", original);
    }

    protected <T> T[] getMediaTypes(Class<T> clazz) throws JAXRSCommonClient.Fault {
        MediaType type = MediaType.WILDCARD_TYPE;
        LinkedList<Object> list = new LinkedList<Object>();
        for (Field field : MediaType.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !field.getType().equals(clazz)) continue;
            try {
                Object value = field.get(type);
                if (!value.toString().contains("/")) continue;
                list.add(value);
            }
            catch (Exception e) {
                throw new JAXRSCommonClient.Fault(e);
            }
        }
        Object[] array = (Object[])Array.newInstance(clazz, 0);
        return list.toArray(array);
    }

    protected Object[] getEntities() {
        String sEntity = ENTITY_VALUES[0];
        ByteArrayInputStream isEntity = new ByteArrayInputStream(ENTITY_VALUES[1].getBytes()){

            public String toString() {
                String line = null;
                try {
                    line = JaxrsUtil.readFromStream(this);
                    this.reset();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return line;
            }
        };
        SerializableClass serEntity = new SerializableClass();
        StringBuilder builderEntity = new StringBuilder().append(ENTITY_VALUES[3]);
        StringBuffer bufferEntity = new StringBuffer().append(ENTITY_VALUES[4]);
        Object[] array = new Object[]{sEntity, isEntity, serEntity, builderEntity, bufferEntity};
        return array;
    }
}

