/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.pluggability.jsonbprovidertests;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.common.vehicle.EmptyVehicleRunner;
import com.sun.ts.tests.common.vehicle.VehicleClient;
import com.sun.ts.tests.common.vehicle.VehicleRunnable;
import com.sun.ts.tests.common.vehicle.VehicleRunnerFactory;
import com.sun.ts.tests.common.vehicle.ejb.EJBVehicle;
import com.sun.ts.tests.common.vehicle.ejb.EJBVehicleRemote;
import com.sun.ts.tests.common.vehicle.ejb.EJBVehicleRunner;
import com.sun.ts.tests.jsonb.provider.MyJsonbBuilder;
import com.sun.ts.tests.jsonb.provider.MyJsonbProvider;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.spi.JsonbProvider;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.porting.lib.spi.TestArchiveProcessor;
import tck.arquillian.protocol.common.TargetVehicle;

@Tags(value={@Tag(value="tck-appclient"), @Tag(value="jsonb"), @Tag(value="platform")})
@ExtendWith(value={ArquillianExtension.class})
public class ClientEjbTest
extends ServiceEETest {
    private static final System.Logger logger = System.getLogger(ClientEjbTest.class.getName());
    static final String VEHICLE_ARCHIVE = "jsonprovidertests_ejb_vehicle";
    private static String packagePath = ClientEjbTest.class.getPackageName().replace(".", "/");
    private static final String providerPackagePath = MyJsonbProvider.class.getPackageName().replace(".", "/");
    private boolean providerJarDeployed = false;
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir", "/tmp");
    private static final String MY_JSONBROVIDER_CLASS = "com.sun.ts.tests.jsonb.provider.MyJsonbProvider";
    private static final String MY_JSONBBUILDER_CLASS = "com.sun.ts.tests.jsonb.provider.MyJsonbBuilder";

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @TargetsContainer(value="tck-appclient")
    @OverProtocol(value="appclient")
    @Deployment(name="jsonprovidertests_ejb_vehicle", order=2)
    public static EnterpriseArchive createDeploymentVehicle(@ArquillianResource TestArchiveProcessor archiveProcessor) {
        JavaArchive jsonb_alternate_provider = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jsonb_alternate_provider.jar")).addClasses(new Class[]{MyJsonbBuilder.class, MyJsonbProvider.class, ClientEjbTest.class})).addAsResource((Asset)new UrlAsset(MyJsonbProvider.class.getClassLoader().getResource(providerPackagePath + "/META-INF/services/jakarta.json.bind.spi.JsonbProvider")), "META-INF/services/jakarta.json.bind.spi.JsonbProvider");
        jsonb_alternate_provider.addAsManifestResource((Asset)new StringAsset("Main-Class: " + ClientEjbTest.class.getName() + "\n"), "MANIFEST.MF");
        JavaArchive jsonbprovidertests_ejb_vehicle_client = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jsonbprovidertests_ejb_vehicle_client.jar");
        jsonbprovidertests_ejb_vehicle_client.addClasses(new Class[]{EmptyVehicleRunner.class, VehicleRunnerFactory.class, VehicleRunnable.class, VehicleClient.class, EJBVehicleRemote.class, EJBVehicleRunner.class, EETest.class, EETest.Fault.class, EETest.SetupException.class, ServiceEETest.class, MyJsonbProvider.class, MyJsonbBuilder.class, ClientEjbTest.class});
        URL resURL = ClientEjbTest.class.getClassLoader().getResource(packagePath + "/ejb_vehicle_client.xml");
        if (resURL != null) {
            jsonbprovidertests_ejb_vehicle_client.addAsManifestResource(resURL, "application-client.xml");
        }
        jsonbprovidertests_ejb_vehicle_client.addAsManifestResource((Asset)new StringAsset("Main-Class: " + ClientEjbTest.class.getName() + "\n"), "MANIFEST.MF");
        resURL = ClientEjbTest.class.getClassLoader().getResource(packagePath + "/ejb_vehicle_client.jar.sun-application-client.xml");
        if (resURL != null) {
            jsonbprovidertests_ejb_vehicle_client.addAsManifestResource(resURL, "sun-application-client.xml");
        }
        archiveProcessor.processClientArchive(jsonbprovidertests_ejb_vehicle_client, ClientEjbTest.class, resURL);
        JavaArchive jsonbprovidertests_ejb_vehicle_ejb = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jsonbprovidertests_ejb_vehicle_ejb.jar");
        jsonbprovidertests_ejb_vehicle_ejb.addClasses(new Class[]{VehicleRunnerFactory.class, VehicleRunnable.class, VehicleClient.class, EJBVehicleRemote.class, EJBVehicle.class, EETest.class, EETest.Fault.class, EETest.SetupException.class, ServiceEETest.class, MyJsonbProvider.class, MyJsonbBuilder.class, ClientEjbTest.class});
        URL ejbResURL = ClientEjbTest.class.getClassLoader().getResource(packagePath + "/ejb_vehicle_ejb.xml");
        if (ejbResURL != null) {
            jsonbprovidertests_ejb_vehicle_ejb.addAsManifestResource(ejbResURL, "ejb-jar.xml");
        }
        if ((ejbResURL = ClientEjbTest.class.getClassLoader().getResource(packagePath + "/ejb_vehicle_ejb.jar.sun-ejb-jar.xml")) != null) {
            jsonbprovidertests_ejb_vehicle_ejb.addAsManifestResource(ejbResURL, "sun-ejb-jar.xml");
        }
        archiveProcessor.processEjbArchive(jsonbprovidertests_ejb_vehicle_ejb, ClientEjbTest.class, ejbResURL);
        EnterpriseArchive jsonbprovidertests_ejb_vehicle_ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"jsonbprovidertests_ejb_vehicle.ear");
        jsonbprovidertests_ejb_vehicle_ear.addAsModule((Archive)jsonbprovidertests_ejb_vehicle_client);
        jsonbprovidertests_ejb_vehicle_ear.addAsModule((Archive)jsonbprovidertests_ejb_vehicle_ejb);
        jsonbprovidertests_ejb_vehicle_ear.addAsLibrary((Archive)jsonb_alternate_provider);
        jsonbprovidertests_ejb_vehicle_ear.addAsModule((Archive)jsonb_alternate_provider);
        return jsonbprovidertests_ejb_vehicle_ear;
    }

    public void removeProviderJarFromCP() throws Exception {
        if (this.providerJarDeployed) {
            URLClassLoader currentThreadClassLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(currentThreadClassLoader.getParent());
            currentThreadClassLoader.close();
            this.providerJarDeployed = false;
        }
    }

    public void createProviderJar() throws Exception {
        JavaArchive jarArchive = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jsonb_alternate_provider.jar")).addClass(MyJsonbBuilder.class)).addClass(MyJsonbProvider.class)).addAsResource((Asset)new UrlAsset(MyJsonbProvider.class.getClassLoader().getResource(providerPackagePath + "/META-INF/services/jakarta.json.bind.spi.JsonbProvider")), "META-INF/services/jakarta.json.bind.spi.JsonbProvider");
        ((ZipExporter)jarArchive.as(ZipExporter.class)).exportTo(new File(TEMP_DIR + File.separator + "jsonb_alternate_provider.jar"), true);
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{new File(TEMP_DIR + File.separator + "jsonb_alternate_provider.jar").toURL()}, currentThreadClassLoader);
        Thread.currentThread().setContextClassLoader(urlClassLoader);
        this.providerJarDeployed = true;
    }

    public static void main(String[] args) {
        ClientEjbTest theTests = new ClientEjbTest();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
    }

    @BeforeEach
    public void setup() throws Exception {
        this.createProviderJar();
        logger.log(System.Logger.Level.INFO, "setup ok");
    }

    @AfterEach
    public void cleanup() throws Exception {
        this.removeProviderJarFromCP();
        logger.log(System.Logger.Level.INFO, "cleanup ok");
    }

    @Test
    @TargetVehicle(value="ejb")
    public void jsonbProviderTest1() throws Exception {
        try {
            JsonbProvider provider = JsonbProvider.provider();
            String providerClass = provider.getClass().getName();
            logger.log(System.Logger.Level.INFO, "provider class=" + providerClass);
        }
        catch (Exception e) {
            throw new Exception("jsonbProviderTest1 Failed: ", e);
        }
    }

    @Test
    @TargetVehicle(value="ejb")
    public void jsonbProviderTest2() throws Exception {
        boolean pass = true;
        try {
            JsonbProvider provider = JsonbProvider.provider((String)MY_JSONBROVIDER_CLASS);
            String providerClass = provider.getClass().getName();
            logger.log(System.Logger.Level.INFO, "provider class=" + providerClass);
            if (providerClass.equals(MY_JSONBROVIDER_CLASS)) {
                logger.log(System.Logger.Level.INFO, "Current provider is my provider - expected.");
            } else {
                logger.log(System.Logger.Level.ERROR, "Current provider is not my provider - unexpected.");
                pass = false;
                ServiceLoader<JsonbProvider> loader = ServiceLoader.load(JsonbProvider.class);
                Iterator<JsonbProvider> it = loader.iterator();
                ArrayList<JsonbProvider> providers = new ArrayList<JsonbProvider>();
                while (it.hasNext()) {
                    providers.add(it.next());
                }
                logger.log(System.Logger.Level.INFO, "Providers: " + String.valueOf(providers));
            }
        }
        catch (Exception e) {
            throw new Exception("jsonbProviderTest2 Failed: ", e);
        }
        if (!pass) {
            throw new Exception("jsonbProviderTest2 Failed");
        }
    }

    @Test
    @TargetVehicle(value="ejb")
    public void jsonbProviderTest3() throws Exception {
        try {
            JsonbBuilder builder = JsonbProvider.provider((String)MY_JSONBROVIDER_CLASS).create();
            String providerClass = builder.getClass().getName();
            logger.log(System.Logger.Level.INFO, "jsonb builder class=" + providerClass);
            if (!providerClass.equals(MY_JSONBBUILDER_CLASS)) {
                logger.log(System.Logger.Level.ERROR, "Current jsonb builder is not my builder - unexpected.");
                throw new Exception("jsonbProviderTest3 Failed");
            }
            logger.log(System.Logger.Level.INFO, "Current jsonb builder is my builder - expected.");
        }
        catch (Exception e) {
            throw new Exception("jsonbProviderTest3 Failed: ", e);
        }
    }
}

