/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.StoredProcedureQuery;

import ee.jakarta.tck.persistence.core.StoredProcedureQuery.Client;
import ee.jakarta.tck.persistence.core.StoredProcedureQuery.Employee;
import ee.jakarta.tck.persistence.core.StoredProcedureQuery.Employee2;
import jakarta.persistence.Parameter;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.TemporalType;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client2
extends Client {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client2.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] xmlFiles = new String[]{"myMappingFile.xml"};
        String[] classes = new String[]{pkgName + "Employee", pkgName + "Employee2", pkgName + "EmployeeMappedSC"};
        return this.createDeploymentJar("jpa_core_types_StoredProcedureQuery2.jar", pkgNameWithoutSuffix, classes, xmlFiles);
    }

    @BeforeEach
    public void setupEmployee2Data() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createEmployee2TestData();
            this.dataBaseName = System.getProperty("jdbc.db");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Override
    public List<List> getResultSetsFromStoredProcedure(StoredProcedureQuery spq) {
        logger.log(System.Logger.Level.TRACE, "in getResultSetsFromStoredProcedure");
        boolean results = true;
        ArrayList<List> listOfList = new ArrayList<List>();
        int rsnum = 1;
        int rowsAffected = 0;
        do {
            if (results) {
                logger.log(System.Logger.Level.TRACE, "Processing set:" + rsnum);
                ArrayList<Employee> empList = new ArrayList<Employee>();
                List list = spq.getResultList();
                if (list != null) {
                    logger.log(System.Logger.Level.TRACE, "Getting result set: " + rsnum + ", size:" + list.size());
                    for (Object o : list) {
                        if (o instanceof Employee) {
                            Employee e = (Employee)o;
                            logger.log(System.Logger.Level.TRACE, "Saving:" + e);
                            empList.add(e);
                            continue;
                        }
                        logger.log(System.Logger.Level.ERROR, "Did not get instance of Employee, instead got:" + o.getClass().getSimpleName());
                    }
                    if (empList.size() > 0) {
                        listOfList.add(empList);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Result set[" + rsnum + "] returned was null");
                }
                ++rsnum;
            } else {
                rowsAffected = spq.getUpdateCount();
                if (rowsAffected >= 0) {
                    logger.log(System.Logger.Level.TRACE, "rowsAffected:" + rowsAffected);
                }
            }
            results = spq.hasMoreResults();
            logger.log(System.Logger.Level.TRACE, "Results:" + results);
        } while (results || rowsAffected != -1);
        return listOfList;
    }

    @Override
    public boolean verifyEmployeeIds(List<Integer> expected, List<List> listOfList) {
        boolean result = false;
        int count = 0;
        for (List lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Integer> actual = new ArrayList<Integer>();
                for (Employee employee : lEmp) {
                    actual.add(employee.getId());
                }
                if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                    logger.log(System.Logger.Level.TRACE, "Received expected result:");
                    for (Integer n : actual) {
                        logger.log(System.Logger.Level.TRACE, "id:" + n);
                    }
                    ++count;
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, "Did not receive expected result:");
                for (Integer n : expected) {
                    logger.log(System.Logger.Level.ERROR, " Expected id:" + n);
                }
                for (Integer n : actual) {
                    logger.log(System.Logger.Level.ERROR, "Actual id:" + n);
                }
                continue;
            }
            logger.log(System.Logger.Level.ERROR, "Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean verifyListOfListEmployees(List<Employee> expected, List<List> listOfList) {
        boolean result = false;
        int count = 0;
        for (List lEmp : listOfList) {
            if (lEmp.size() > 0) {
                ArrayList<Employee> actual = new ArrayList<Employee>();
                for (Employee e : lEmp) {
                    actual.add(e);
                }
                if (!this.verifyListEmployees(expected, actual)) continue;
                ++count;
                continue;
            }
            logger.log(System.Logger.Level.ERROR, "Result set that was returned had 0 length");
        }
        if (count == listOfList.size()) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean verifyListEmployees(List<Employee> expected, List<Employee> actual) {
        boolean result = false;
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            for (Employee e : expected) {
                logger.log(System.Logger.Level.TRACE, "Received expected result:" + e);
            }
            result = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Did not receive expected result:");
            for (Employee e : expected) {
                logger.log(System.Logger.Level.ERROR, "expected employee:" + e);
            }
            for (Employee e : actual) {
                logger.log(System.Logger.Level.ERROR, "actual employee :" + e);
            }
        }
        return result;
    }

    @Test
    public void setParameterIntCalendarTemporalTypeTest() throws Exception {
        boolean pass2 = false;
        boolean pass4 = false;
        try {
            this.getEntityTransaction().begin();
            try {
                logger.log(System.Logger.Level.INFO, "Testing StoredProcedureQuery object");
                StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                spq.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
                spq.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                spq.setParameter(1, this.calDate, TemporalType.DATE);
                if (!spq.execute()) {
                    Object o = spq.getOutputParameterValue(2);
                    if (o instanceof Integer) {
                        int actual = (Integer)o;
                        if (actual == this.emp2.getId()) {
                            logger.log(System.Logger.Level.TRACE, "Received expected id:" + actual);
                            pass2 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected id: " + this.emp2.getId() + ", actual:" + actual);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get instance of Integer back:" + o);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
            }
            try {
                logger.log(System.Logger.Level.INFO, "Testing Query object");
                StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                spq1.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
                spq1.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                StoredProcedureQuery q = spq1;
                q.setParameter(1, this.getCalDate(), TemporalType.DATE);
                StoredProcedureQuery spq2 = q;
                if (!spq2.execute()) {
                    Object o = spq2.getOutputParameterValue(2);
                    if (o instanceof Integer) {
                        int actual = (Integer)o;
                        if (actual == 5) {
                            logger.log(System.Logger.Level.TRACE, "Received expected id:" + actual);
                            pass4 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected id: 5, actual:" + actual);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get instance of Integer back:" + o);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!pass2 || !pass4) {
            throw new Exception("setParameterIntCalendarTemporalTypeTest failed");
        }
    }

    @Test
    public void setParameterIntCalendarTemporalTypeIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Testing StoredProcedureQuery with incorrect position specified");
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq1.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
            try {
                spq1.setParameter(99, this.getCalDate(), TemporalType.DATE);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            logger.log(System.Logger.Level.INFO, "Testing Query object with incorrect position specified");
            StoredProcedureQuery spq3 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq3.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
            StoredProcedureQuery q1 = spq3.setParameter(1, this.getCalDate(), TemporalType.DATE);
            try {
                q1.setParameter(99, (Object)this.getCalDate());
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterIntCalendarTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void setParameterParameterCalendarTemporalTypeTest() throws Exception {
        boolean pass5;
        boolean pass3;
        boolean pass2;
        block20: {
            block19: {
                pass2 = false;
                pass3 = false;
                pass5 = false;
                try {
                    logger.log(System.Logger.Level.INFO, "Testing StoredProcedure");
                    this.getEntityTransaction().begin();
                    StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                    spq.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
                    spq.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                    spq.setParameter(1, this.getCalDate(), TemporalType.DATE);
                    Parameter p = spq.getParameter(1);
                    spq.setParameter(p, this.calDate, TemporalType.DATE);
                    if (!spq.execute()) {
                        Object o = spq.getOutputParameterValue(2);
                        if (o instanceof Integer) {
                            int actual = (Integer)o;
                            if (actual == this.emp2.getId()) {
                                logger.log(System.Logger.Level.TRACE, "Received expected id:" + actual);
                                pass2 = true;
                            } else {
                                logger.log(System.Logger.Level.ERROR, "Expected id: " + this.emp2.getId() + ", actual:" + actual);
                            }
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Did not get instance of Integer back:" + o);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
                    }
                    this.getEntityTransaction().commit();
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
                    if (!this.getEntityTransaction().isActive()) break block19;
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                logger.log(System.Logger.Level.INFO, "Testing Query object");
                StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
                spq1.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
                spq1.registerStoredProcedureParameter(2, Integer.class, ParameterMode.OUT);
                spq1.setParameter(1, this.getCalDate(), TemporalType.DATE);
                StoredProcedureQuery q = spq1;
                Parameter p = q.getParameter(1);
                q.setParameter(p, this.calDate, TemporalType.DATE);
                Parameter p2 = q.getParameter(1);
                if (p.getPosition().equals(p2.getPosition()) && p.getParameterType().equals(p2.getParameterType())) {
                    logger.log(System.Logger.Level.TRACE, "Received expected parameter");
                    pass3 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected parameter:" + p + ", actual:" + p2);
                }
                StoredProcedureQuery spq2 = q;
                if (!spq2.execute()) {
                    Object o = spq2.getOutputParameterValue(2);
                    if (o instanceof Integer) {
                        int actual = (Integer)o;
                        if (actual == this.emp2.getId()) {
                            logger.log(System.Logger.Level.TRACE, "Received expected id:" + actual);
                            pass5 = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Expected id: " + this.emp2.getId() + ", actual:" + actual);
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get instance of Integer back:" + o);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected execute() to return false, actual: true");
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
                if (!this.getEntityTransaction().isActive()) break block20;
                this.getEntityTransaction().rollback();
            }
        }
        if (!(pass2 && pass3 && pass5)) {
            throw new Exception("setParameterParameterCalendarTemporalTypeTest failed");
        }
    }

    @Test
    public void setParameterParameterCalendarTemporalTypeIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Get parameter from other stored procedure");
            StoredProcedureQuery spq = this.getEntityManager().createStoredProcedureQuery("GetEmpLastNameFromInOut");
            spq.registerStoredProcedureParameter(1, String.class, ParameterMode.INOUT);
            spq.setParameter(1, (Object)"INOUT");
            Parameter p = spq.getParameter(1);
            logger.log(System.Logger.Level.INFO, "Testing StoredProcedureQuery with parameter specified from another query");
            StoredProcedureQuery spq1 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq1.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
            spq1.setParameter(1, this.getCalDate(), TemporalType.DATE);
            try {
                spq1.setParameter(p, this.getCalDate(), TemporalType.DATE);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass1 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            logger.log(System.Logger.Level.INFO, "Testing Query object with parameter specified from another query");
            StoredProcedureQuery spq3 = this.getEntityManager().createStoredProcedureQuery("GetEmpIdUsingHireDateFromOut");
            spq3.registerStoredProcedureParameter(1, Calendar.class, ParameterMode.IN);
            StoredProcedureQuery q1 = spq3.setParameter(1, (Object)this.getCalDate());
            try {
                q1.setParameter(p, this.getCalDate(), TemporalType.DATE);
                logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
            }
            catch (IllegalArgumentException iae) {
                logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
                pass2 = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception", (Throwable)e);
            }
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterParameterCalendarTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployee2TestData() {
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Creating Employee2");
            Calendar d2 = this.getCalDate(2001, 6, 27);
            Calendar d3 = this.getCalDate(2002, 7, 7);
            Calendar d4 = this.getCalDate(2003, 3, 3);
            Calendar d5 = this.getCalDate();
            this.emp2 = new Employee2(1, "Alan", "Frechette", this.calDate, 35000.0f);
            this.empRef2.add(this.emp2);
            this.empRef2.add(new Employee2(2, "Arthur", "Frechette", d2, 35000.0f));
            this.empRef2.add(new Employee2(3, "Shelly", "McGowan", d3, 50000.0f));
            this.empRef2.add(new Employee2(4, "Robert", "Bissett", d4, 55000.0f));
            this.empRef2.add(new Employee2(5, "Stephen", "DMilla", d5, 25000.0f));
            for (Employee2 e : this.empRef2) {
                if (e == null) continue;
                this.getEntityManager().persist((Object)e);
                logger.log(System.Logger.Level.TRACE, "persisted Employee2:" + e);
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }
}

