/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.embeddable;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.embeddable.Address;
import ee.jakarta.tck.persistence.core.annotations.embeddable.B;
import ee.jakarta.tck.persistence.core.annotations.embeddable.ZipCode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Address", pkgName + "B", pkgName + "ZipCode"};
        return this.createDeploymentJar("jpa_core_annotations_embeddable.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void EM1XMTest() throws Exception {
        logger.log(System.Logger.Level.TRACE, "Begin EM1XMTest2");
        boolean pass = false;
        EntityManager em = this.getEntityManager();
        EntityTransaction et = this.getEntityTransaction();
        try {
            et.begin();
            logger.log(System.Logger.Level.TRACE, "New instances");
            ZipCode z1 = new ZipCode("01801", "1234");
            Address addr1 = new Address("1 Network Drive", "Burlington", "MA");
            addr1.setZipCode(z1);
            B b1 = new B("1", "b1", 1);
            b1.setAddress(addr1);
            em.persist((Object)b1);
            em.flush();
            B newB = this.findB("1");
            em.refresh((Object)newB);
            String newStreet = (String)em.createQuery("Select b.address.street from B b ").getSingleResult();
            String newState = (String)em.createQuery("Select b.address.state from B b ").getSingleResult();
            String newCity = (String)em.createQuery("Select b.address.city from B b ").getSingleResult();
            String newPlusFour = (String)em.createQuery("Select b.address.zipCode.plusFour from B b ").getSingleResult();
            String newZip = (String)em.createQuery("Select b.address.zipCode.zip from B b ").getSingleResult();
            boolean pass1 = false;
            boolean pass2 = false;
            boolean pass3 = false;
            boolean pass4 = false;
            boolean pass5 = false;
            if (addr1.getStreet().equals(newStreet)) {
                pass1 = true;
                logger.log(System.Logger.Level.TRACE, "Received Street match");
            }
            if (addr1.getState().equals(newState)) {
                pass2 = true;
                logger.log(System.Logger.Level.TRACE, "Received State match");
            }
            if (addr1.getCity().equals(newCity)) {
                pass3 = true;
                logger.log(System.Logger.Level.TRACE, "Received City match");
            }
            if (addr1.getZipCode().getPlusFour().equals(newPlusFour)) {
                pass4 = true;
                logger.log(System.Logger.Level.TRACE, "Received zipCode PlusFour match");
            }
            if (addr1.getZipCode().getZip().equals(newZip)) {
                pass5 = true;
                logger.log(System.Logger.Level.TRACE, "Received zipCode zip match");
            }
            if (pass1 && pass2 && pass3 && pass4 && pass5) {
                pass = true;
                logger.log(System.Logger.Level.TRACE, "Received Address match");
            } else {
                logger.log(System.Logger.Level.TRACE, "Received incorrect data");
            }
            et.commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (et.isActive()) {
                    et.rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new Exception("EM1XMTest failed");
        }
    }

    private B findB(String id) {
        return (B)this.getEntityManager().find(B.class, (Object)id);
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from B_EMBEDDABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

