/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.mapkey;

import ee.jakarta.tck.persistence.core.annotations.mapkey.Client;
import ee.jakarta.tck.persistence.core.annotations.mapkey.Department;
import ee.jakarta.tck.persistence.core.annotations.mapkey.Employee2;
import ee.jakarta.tck.persistence.core.annotations.mapkey.Employee3;
import ee.jakarta.tck.persistence.core.annotations.mapkey.Employee4;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client2
extends Client {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());
    private Employee2 empRef2;
    private Employee3 empRef3;
    private Employee4 empRef4;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = Client.class.getPackageName() + ".";
        String[] classes = new String[]{pkgName + "Department", pkgName + "Employee", pkgName + "Employee2", pkgName + "Employee3", pkgName + "Employee4"};
        return this.createDeploymentJar("jpa_core_annotations_mapkey2.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupCreateTestData2() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTestData2();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void joinColumnInsertable() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "find employee2");
            Employee2 emp2 = (Employee2)this.getEntityManager().find(Employee2.class, (Object)6);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp2.getFirstName() + " " + emp2.getLastName());
            Department dept = emp2.getDepartment();
            if (dept == null) {
                logger.log(System.Logger.Level.TRACE, "Received expected null department for employee2");
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Expected null department, actual:" + dept.getName());
            }
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "--------------");
            logger.log(System.Logger.Level.TRACE, "find employee3");
            Employee3 emp3 = (Employee3)this.getEntityManager().find(Employee3.class, (Object)7);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp3.getFirstName() + " " + emp3.getLastName());
            dept = emp3.getDepartment();
            if (dept != null && dept.getName().equals(deptRef[0].getName())) {
                logger.log(System.Logger.Level.TRACE, "Received expected department for employee3:" + dept.getName());
            } else {
                pass = false;
                if (dept != null) {
                    logger.log(System.Logger.Level.ERROR, "Expected department:" + deptRef[0].getName() + ", actual:" + dept.getName());
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected department:" + deptRef[0].getName() + ", actual:null");
                }
            }
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "--------------");
            logger.log(System.Logger.Level.TRACE, "find employee4");
            Employee4 emp4 = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp4.getFirstName() + " " + emp4.getLastName());
            dept = emp4.getDepartment();
            if (dept == null) {
                logger.log(System.Logger.Level.TRACE, "Received expected null department for employee4");
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Expected department: null, actual:" + dept.getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("joinColumnInsertable Failed");
        }
    }

    @Test
    public void joinColumnUpdatable() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "find employee2");
            Employee2 emp2 = (Employee2)this.getEntityManager().find(Employee2.class, (Object)6);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp2.getFirstName() + " " + emp2.getLastName());
            logger.log(System.Logger.Level.TRACE, "set department to:" + deptRef[1].getId() + ", " + deptRef[1].getName());
            emp2.setDepartment(deptRef[1]);
            this.getEntityManager().merge((Object)emp2);
            this.getEntityManager().flush();
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "find employee2 again");
            emp2 = (Employee2)this.getEntityManager().find(Employee2.class, (Object)6);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp2.getFirstName() + " " + emp2.getLastName());
            Department dept = emp2.getDepartment();
            if (dept == null) {
                logger.log(System.Logger.Level.TRACE, "Received expected null department");
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Expected null department, actual:" + dept.getName());
            }
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "--------------");
            logger.log(System.Logger.Level.TRACE, "find employee3");
            Employee3 emp3 = (Employee3)this.getEntityManager().find(Employee3.class, (Object)7);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp3.getFirstName() + " " + emp3.getLastName());
            logger.log(System.Logger.Level.TRACE, "Department:" + emp3.getDepartment().getId() + ", " + emp3.getDepartment().getName());
            logger.log(System.Logger.Level.TRACE, "set department to:" + deptRef[1].getId() + ", " + deptRef[1].getName());
            emp3.setDepartment(deptRef[1]);
            this.getEntityManager().merge((Object)emp3);
            this.getEntityManager().flush();
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "find employee3 again");
            emp3 = (Employee3)this.getEntityManager().find(Employee3.class, (Object)7);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp3.getFirstName() + " " + emp3.getLastName());
            dept = emp3.getDepartment();
            if (dept != null && dept.getName().equals(deptRef[0].getName())) {
                logger.log(System.Logger.Level.TRACE, "Received expected department:" + dept.getName());
            } else {
                pass = false;
                if (dept != null) {
                    logger.log(System.Logger.Level.ERROR, "Expected department:" + deptRef[0].getName() + ", actual:" + dept.getName());
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected department:" + deptRef[0].getName() + ", actual:null");
                }
            }
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "--------------");
            logger.log(System.Logger.Level.TRACE, "find employee4");
            Employee4 emp4 = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp4.getFirstName() + " " + emp4.getLastName());
            if (emp4.getFirstName() != null) {
                logger.log(System.Logger.Level.ERROR, "Expected first name to be null, actual:" + emp4.getFirstName());
                pass = false;
            }
            if (emp4.getDepartment() != null) {
                logger.log(System.Logger.Level.ERROR, "Expected Department to be null, actual:" + emp4.getDepartment().toString());
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "set department to:" + deptRef[1].getId() + ", " + deptRef[1].getName());
            emp4.setDepartment(deptRef[1]);
            this.getEntityManager().merge((Object)emp4);
            this.getEntityManager().flush();
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "find employee4 again");
            emp4 = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp4.getFirstName() + " " + emp4.getLastName());
            dept = emp4.getDepartment();
            if (dept != null && dept.getName().equals(deptRef[1].getName())) {
                logger.log(System.Logger.Level.TRACE, "Received expected department:" + dept.getName());
            } else {
                pass = false;
                if (dept != null) {
                    logger.log(System.Logger.Level.ERROR, "Expected " + deptRef[1].getName() + " department, actual:" + dept.getName());
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected " + deptRef[1].getName() + " department, actual:null");
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("joinColumnUpdatable Failed");
        }
    }

    @Test
    public void columnInsertable() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "find employee2");
            Employee2 emp2 = (Employee2)this.getEntityManager().find(Employee2.class, (Object)6);
            String firstName = emp2.getFirstName();
            logger.log(System.Logger.Level.TRACE, "Name:" + firstName + " " + emp2.getLastName());
            if (firstName == null) {
                logger.log(System.Logger.Level.TRACE, "Received expected null firstName");
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Expected firstName: null, actual:" + firstName);
            }
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "--------------");
            logger.log(System.Logger.Level.TRACE, "find employee3");
            Employee3 emp3 = (Employee3)this.getEntityManager().find(Employee3.class, (Object)7);
            firstName = emp3.getFirstName();
            logger.log(System.Logger.Level.TRACE, "Name:" + firstName + " " + emp3.getLastName());
            if (firstName != null && firstName.equals("Paul")) {
                logger.log(System.Logger.Level.TRACE, "Received expected firstName:" + firstName);
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Expected firstName: Paul, actual: null");
            }
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "--------------");
            logger.log(System.Logger.Level.TRACE, "find employee4");
            Employee4 emp4 = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            firstName = emp4.getFirstName();
            logger.log(System.Logger.Level.TRACE, "Name:" + firstName + " " + emp4.getLastName());
            if (firstName == null) {
                logger.log(System.Logger.Level.TRACE, "Received expected null firstName");
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Expected firstName: null, actual:" + firstName);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("columnInsertable Failed");
        }
    }

    @Test
    public void columnUpdatable() throws Exception {
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "find employee2");
            Employee2 emp2 = (Employee2)this.getEntityManager().find(Employee2.class, (Object)6);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp2.getFirstName() + " " + emp2.getLastName());
            logger.log(System.Logger.Level.TRACE, "set firstName and save");
            emp2.setFirstName("foo");
            this.getEntityManager().merge((Object)emp2);
            this.getEntityManager().flush();
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "find employee2 again");
            emp2 = (Employee2)this.getEntityManager().find(Employee2.class, (Object)6);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp2.getFirstName() + " " + emp2.getLastName());
            String firstName = emp2.getFirstName();
            if (firstName == null) {
                logger.log(System.Logger.Level.TRACE, "Received expected null firstName");
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Expected firstName: null, actual:" + firstName);
            }
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "--------------");
            logger.log(System.Logger.Level.TRACE, "find employee3");
            Employee3 emp3 = (Employee3)this.getEntityManager().find(Employee3.class, (Object)7);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp3.getFirstName() + " " + emp3.getLastName());
            logger.log(System.Logger.Level.TRACE, "set firstName and save");
            emp3.setFirstName("foo");
            this.getEntityManager().merge((Object)emp3);
            this.getEntityManager().flush();
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "find employee3 again");
            emp3 = (Employee3)this.getEntityManager().find(Employee3.class, (Object)7);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp3.getFirstName() + " " + emp3.getLastName());
            firstName = emp3.getFirstName();
            if (firstName != null && firstName.equals("Paul")) {
                logger.log(System.Logger.Level.TRACE, "Received expected firstName:" + firstName);
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Expected firstName: Paul, actual: null");
            }
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "--------------");
            logger.log(System.Logger.Level.TRACE, "find employee4");
            Employee4 emp4 = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp4.getFirstName() + " " + emp4.getLastName());
            logger.log(System.Logger.Level.TRACE, "set firstName and save");
            emp4.setFirstName("foo");
            this.getEntityManager().merge((Object)emp4);
            this.getEntityManager().flush();
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "find employee4 again");
            emp4 = (Employee4)this.getEntityManager().find(Employee4.class, (Object)8);
            logger.log(System.Logger.Level.TRACE, "Name:" + emp4.getFirstName() + " " + emp4.getLastName());
            firstName = emp4.getFirstName();
            if (firstName != null && firstName.equals("foo")) {
                logger.log(System.Logger.Level.TRACE, "Received expected firstName:" + firstName);
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Expected firstName: foo, actual: null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("columnUpdatable Failed");
        }
    }

    public void createTestData2() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "createTestData2");
            this.createTestDataCommon();
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "Create and persist employee2 ");
            this.empRef2 = new Employee2(6, "John", "Smith");
            this.empRef2.setDepartment(deptRef[0]);
            this.getEntityManager().persist((Object)this.empRef2);
            logger.log(System.Logger.Level.TRACE, "Create and persist employee3 ");
            this.empRef3 = new Employee3(7, "Paul", "Jones");
            this.empRef3.setDepartment(deptRef[0]);
            this.getEntityManager().persist((Object)this.empRef3);
            logger.log(System.Logger.Level.TRACE, "Create and persist employee4 ");
            this.empRef4 = new Employee4(8, "Thomas", "Brady");
            this.empRef4.setDepartment(deptRef[0]);
            this.getEntityManager().persist((Object)this.empRef4);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }
}

