/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.version;

import ee.jakarta.tck.persistence.core.annotations.version.Client;
import ee.jakarta.tck.persistence.core.annotations.version.Int_Field;
import ee.jakarta.tck.persistence.core.annotations.version.Int_Property;
import ee.jakarta.tck.persistence.core.annotations.version.Integer_Field;
import ee.jakarta.tck.persistence.core.annotations.version.Integer_Property;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client1
extends Client {
    private static final System.Logger logger = System.getLogger(Client1.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = Client.class.getPackageName() + ".";
        String[] classes = new String[]{pkgName + "Int_Field", pkgName + "Int_Property", pkgName + "Integer_Field", pkgName + "Integer_Property", pkgName + "Long_Field", pkgName + "Long_Property", pkgName + "LongClass_Field", pkgName + "LongClass_Property", pkgName + "Short_Field", pkgName + "Short_Property", pkgName + "ShortClass_Field", pkgName + "ShortClass_Property", pkgName + "Timestamp_Field", pkgName + "Timestamp_Property"};
        return this.createDeploymentJar("jpa_core_annotations_version1.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupIntData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setupIntData");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createIntTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void intFieldTest() throws Exception {
        boolean pass = false;
        try {
            Int_Field a = (Int_Field)this.getEntityManager().find(Int_Field.class, (Object)"1");
            if (a != null) {
                logger.log(System.Logger.Level.TRACE, "version:" + a.getVersion());
                int version = a.getVersion();
                a.setName("two");
                this.getEntityTransaction().begin();
                this.getEntityManager().merge((Object)a);
                this.getEntityManager().flush();
                this.getEntityTransaction().commit();
                Int_Field a1 = (Int_Field)this.getEntityManager().find(Int_Field.class, (Object)"1");
                if (a1 != null) {
                    if (a1.getVersion() > version) {
                        logger.log(System.Logger.Level.TRACE, "version:" + a1.getVersion());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get a greater version after a modification:" + a1.getVersion());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Second find returned null result");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("intFieldTest failed");
        }
    }

    @Test
    public void intPropertyTest() throws Exception {
        boolean pass = false;
        try {
            Int_Property a = (Int_Property)this.getEntityManager().find(Int_Property.class, (Object)"2");
            if (a != null) {
                logger.log(System.Logger.Level.TRACE, "version:" + a.getValue());
                int version = a.getValue();
                a.setName("two");
                this.getEntityTransaction().begin();
                this.getEntityManager().merge((Object)a);
                this.getEntityManager().flush();
                this.getEntityTransaction().commit();
                Int_Property a1 = (Int_Property)this.getEntityManager().find(Int_Property.class, (Object)"2");
                if (a1 != null) {
                    if (a1.getValue() > version) {
                        logger.log(System.Logger.Level.TRACE, "version:" + a1.getValue());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get a greater version after a modification:" + a1.getValue());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Second find returned null result");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("intPropertyTest failed");
        }
    }

    @Test
    public void integerFieldTest() throws Exception {
        boolean pass = false;
        try {
            Integer_Field a = (Integer_Field)this.getEntityManager().find(Integer_Field.class, (Object)"3");
            if (a != null) {
                logger.log(System.Logger.Level.TRACE, "version:" + a.getVersion());
                Integer version = a.getVersion();
                a.setName("two");
                this.getEntityTransaction().begin();
                this.getEntityManager().merge((Object)a);
                this.getEntityManager().flush();
                this.getEntityTransaction().commit();
                Integer_Field a1 = (Integer_Field)this.getEntityManager().find(Integer_Field.class, (Object)"3");
                if (a1 != null) {
                    if (a1.getVersion() > version) {
                        logger.log(System.Logger.Level.TRACE, "version:" + a1.getVersion());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get a greater version after a modification:" + a1.getVersion());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Second find returned null result");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("integerFieldTest failed");
        }
    }

    @Test
    public void integerPropertyTest() throws Exception {
        boolean pass = false;
        try {
            Integer_Property a = (Integer_Property)this.getEntityManager().find(Integer_Property.class, (Object)"4");
            if (a != null) {
                logger.log(System.Logger.Level.TRACE, "version:" + a.getBasicInteger());
                Integer version = a.getBasicInteger();
                a.setName("two");
                this.getEntityTransaction().begin();
                this.getEntityManager().merge((Object)a);
                this.getEntityManager().flush();
                this.getEntityTransaction().commit();
                Integer_Property a1 = (Integer_Property)this.getEntityManager().find(Integer_Property.class, (Object)"4");
                if (a1 != null) {
                    if (a1.getBasicInteger() > version) {
                        logger.log(System.Logger.Level.TRACE, "version:" + a1.getBasicInteger());
                        pass = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Did not get a greater version after a modification:" + a1.getBasicInteger());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Second find returned null result");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Find returned null result");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("integerPropertyTest failed");
        }
    }

    public void createIntTestData() {
        logger.log(System.Logger.Level.TRACE, "createIntTestData");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)new Int_Field("1"));
            this.getEntityManager().persist((Object)new Int_Property("2"));
            this.getEntityManager().persist((Object)new Integer_Field("3", new Integer(0)));
            this.getEntityManager().persist((Object)new Integer_Property("4", new Integer(0)));
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception in createIntTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }
}

