/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.version;

import ee.jakarta.tck.persistence.core.annotations.version.Client;
import ee.jakarta.tck.persistence.core.annotations.version.Timestamp_Field;
import ee.jakarta.tck.persistence.core.annotations.version.Timestamp_Property;
import java.sql.Timestamp;
import java.util.Date;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client4
extends Client {
    private static final System.Logger logger = System.getLogger(Client4.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = Client.class.getPackageName() + ".";
        String[] classes = new String[]{pkgName + "Int_Field", pkgName + "Int_Property", pkgName + "Integer_Field", pkgName + "Integer_Property", pkgName + "Long_Field", pkgName + "Long_Property", pkgName + "LongClass_Field", pkgName + "LongClass_Property", pkgName + "Short_Field", pkgName + "Short_Property", pkgName + "ShortClass_Field", pkgName + "ShortClass_Property", pkgName + "Timestamp_Field", pkgName + "Timestamp_Property"};
        return this.createDeploymentJar("jpa_core_annotations_version4.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupTimestampData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setupTimestampData");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createTimestampTestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void timestampFieldTest() throws Exception {
        boolean pass;
        block10: {
            pass = false;
            try {
                Timestamp_Field a = (Timestamp_Field)this.getEntityManager().find(Timestamp_Field.class, (Object)"1");
                if (a != null) {
                    logger.log(System.Logger.Level.TRACE, "version:" + a.getVersion());
                    Timestamp version = a.getVersion();
                    a.setName("two");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    this.getEntityTransaction().begin();
                    this.getEntityManager().merge((Object)a);
                    this.getEntityManager().flush();
                    this.getEntityTransaction().commit();
                    Timestamp_Field a1 = (Timestamp_Field)this.getEntityManager().find(Timestamp_Field.class, (Object)"1");
                    if (a1 != null) {
                        if (a1.getVersion().after(version)) {
                            logger.log(System.Logger.Level.TRACE, "version:" + a1.getVersion());
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Did not get a greater version after a modification:" + a1.getVersion());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Second find returned null result");
                    }
                    break block10;
                }
                logger.log(System.Logger.Level.ERROR, "Find returned null result");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("timestampFieldTest failed");
        }
    }

    @Test
    public void timestampPropertyTest() throws Exception {
        boolean pass;
        block10: {
            pass = false;
            try {
                Timestamp_Property a = (Timestamp_Property)this.getEntityManager().find(Timestamp_Property.class, (Object)"2");
                if (a != null) {
                    logger.log(System.Logger.Level.TRACE, "version:" + a.getBasicTimestamp());
                    Timestamp version = a.getBasicTimestamp();
                    a.setName("two");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    this.getEntityTransaction().begin();
                    this.getEntityManager().merge((Object)a);
                    this.getEntityManager().flush();
                    this.getEntityTransaction().commit();
                    Timestamp_Property a1 = (Timestamp_Property)this.getEntityManager().find(Timestamp_Property.class, (Object)"2");
                    if (a1 != null) {
                        if (a1.getBasicTimestamp().after(version)) {
                            logger.log(System.Logger.Level.TRACE, "version:" + a1.getBasicTimestamp());
                            pass = true;
                        } else {
                            logger.log(System.Logger.Level.ERROR, "Did not get a greater version after a modification:" + a1.getBasicTimestamp());
                        }
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Second find returned null result");
                    }
                    break block10;
                }
                logger.log(System.Logger.Level.ERROR, "Find returned null result");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            }
        }
        if (!pass) {
            throw new Exception("timestampPropertyTest failed");
        }
    }

    public void createTimestampTestData() {
        logger.log(System.Logger.Level.TRACE, "createTimestampTestData");
        try {
            this.getEntityTransaction().begin();
            Timestamp currentTime = new Timestamp(new Date().getTime());
            this.getEntityManager().persist((Object)new Timestamp_Field("1", currentTime));
            this.getEntityManager().persist((Object)new Timestamp_Property("2", currentTime));
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception in createTimestampTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }
}

