/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaQuery;

import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.common.schema30.Country;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.UtilCustomerData;
import ee.jakarta.tck.persistence.core.criteriaapi.CriteriaQuery.A;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.Metamodel;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client3
extends UtilCustomerData {
    private static final System.Logger logger = System.getLogger(Client3.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client3.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A"};
        classes = Client3.concat((String[])this.getSchema30classes(), (String[])classes);
        return this.createDeploymentJar("jpa_core_criteriaapi_CriteriaQuery3.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void multiselect() throws Exception {
        boolean pass = false;
        int expectedResultSize = 20;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            logger.log(System.Logger.Level.TRACE, "Use Tuple Query");
            cquery.multiselect(new Selection[]{customer.get(Customer_2.getSingularAttribute("id", String.class)), customer.get(Customer_2.getSingularAttribute("name", String.class))});
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            if (result.size() == 20) {
                logger.log(System.Logger.Level.TRACE, "Result size =" + result.size());
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Received incorrect result size =" + result.size());
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("multiselect test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void multiselectListTest() throws Exception {
        boolean pass = false;
        int expectedResultSize = 20;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createTupleQuery();
        if (cquery != null) {
            logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
            Root customer = cquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            logger.log(System.Logger.Level.TRACE, "Use Tuple Query");
            ArrayList<Path> list = new ArrayList<Path>();
            list.add(customer.get(Customer_2.getSingularAttribute("id", String.class)));
            list.add(customer.get(Customer_2.getSingularAttribute("name", String.class)));
            cquery.multiselect(list);
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            if (result.size() == 20) {
                logger.log(System.Logger.Level.TRACE, "Result size =" + result.size());
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Received incorrect result size =" + result.size());
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("multiselectListTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void where() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("name", String.class)), (Object)"Robert E. Bissett"));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            int expectedResultSize = 1;
            if (result != null) {
                if (result.size() == expectedResultSize) {
                    logger.log(System.Logger.Level.TRACE, "Successfully returned expected results");
                    pass = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Mismatch in received results - expected = " + expectedResultSize + " received = " + result.size());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Missing expected result");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("where test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void createQueryCriteriaUpdateTest() throws Exception {
        boolean pass = false;
        String expected = "foobar";
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaUpdate cquery = cbuilder.createCriteriaUpdate(Customer.class);
        Root customer = cquery.from(Customer.class);
        cquery.set(customer.get("name"), (Object)expected);
        cquery.where((Expression)cbuilder.equal((Expression)customer.get("id"), (Object)"1"));
        this.getEntityManager().createQuery(cquery).executeUpdate();
        this.getEntityTransaction().commit();
        this.clearCache();
        this.getEntityTransaction().begin();
        Customer actual = (Customer)this.getEntityManager().find(Customer.class, (Object)"1");
        if (actual == null) {
            logger.log(System.Logger.Level.ERROR, "Received null result from find");
        } else if (actual.getName().equals(expected)) {
            logger.log(System.Logger.Level.TRACE, "Name was successfully updated");
            pass = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected:" + expected + ", actual:" + actual.getName());
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("createQueryCriteriaUpdateTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void createQueryCriteriaDeleteTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaDelete cquery = cbuilder.createCriteriaDelete(Customer.class);
        Root customer = cquery.from(Customer.class);
        EntityType Customer_2 = customer.getModel();
        cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)), (Object)"1"));
        this.getEntityManager().createQuery(cquery).executeUpdate();
        this.getEntityTransaction().commit();
        this.clearCache();
        this.getEntityTransaction().begin();
        Customer actual = (Customer)this.getEntityManager().find(Customer.class, (Object)"1");
        if (actual != null) {
            logger.log(System.Logger.Level.ERROR, "Expected null result from find, actual = " + actual.toString());
        } else {
            logger.log(System.Logger.Level.TRACE, "Customer was successfully deleted");
            pass = true;
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new Exception("createQueryCriteriaDeleteTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void fromGetStringTest() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Customer.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get("name"), (Object)"Karen R. Tegan"));
            cquery.select((Selection)customer);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (result.size() == 1) {
                if (!((Customer)result.get(0)).getId().equals("6")) {
                    logger.log(System.Logger.Level.ERROR, "Expected id:6, actual:" + ((Customer)result.get(0)).getId());
                } else {
                    pass = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get correct number of results, expected:1, actual:" + result.size());
                for (Customer c : result) {
                    logger.log(System.Logger.Level.ERROR, "id:" + c.getId());
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("fromGetStringTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void groupBy() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<ExpectedResult> expected = new ArrayList<ExpectedResult>();
        expected.add(new ExpectedResult("CHA", "4"));
        expected.add(new ExpectedResult("GBR", "2"));
        expected.add(new ExpectedResult("IRE", "2"));
        expected.add(new ExpectedResult("JPN", "1"));
        expected.add(new ExpectedResult("USA", "11"));
        try {
            CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            Metamodel mm = this.getEntityManagerFactory().getMetamodel();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            Root customer = cquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            EmbeddableType Country_ = mm.embeddable(Country.class);
            cquery.multiselect(new Selection[]{customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)), cbuilder.count((Expression)customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)))});
            cquery.groupBy(new Expression[]{customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class))});
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)))});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            int i = 0;
            int passCount1 = 0;
            int passCount2 = 0;
            if (result.size() == expected.size()) {
                for (Tuple actual : result) {
                    logger.log(System.Logger.Level.TRACE, "code=" + actual.get(0) + ", count=" + actual.get(1));
                    if (!actual.get(0).equals(((ExpectedResult)expected.get((int)i)).arg1)) {
                        logger.log(System.Logger.Level.ERROR, "Expected: " + ((ExpectedResult)expected.get((int)i)).arg1 + ", actual:" + actual.get(0));
                    } else {
                        ++passCount1;
                    }
                    if (!actual.get(1).equals(Long.parseLong(((ExpectedResult)expected.get((int)i)).arg2))) {
                        logger.log(System.Logger.Level.ERROR, "Expected: " + ((ExpectedResult)expected.get((int)i)).arg2 + ", actual:" + actual.get(1));
                    } else {
                        ++passCount2;
                    }
                    ++i;
                }
                if (passCount1 == expected.size()) {
                    pass1 = true;
                }
                if (passCount2 == expected.size()) {
                    pass2 = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected number of entries, expected:" + expected.size() + ", actual:" + result.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception groupBy: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("groupBy failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void groupByExpArrayTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<ExpectedResult> expected = new ArrayList<ExpectedResult>();
        expected.add(new ExpectedResult("CHA", "13"));
        expected.add(new ExpectedResult("CHA", "18"));
        expected.add(new ExpectedResult("CHA", "19"));
        expected.add(new ExpectedResult("CHA", "20"));
        expected.add(new ExpectedResult("GBR", "11"));
        expected.add(new ExpectedResult("GBR", "16"));
        expected.add(new ExpectedResult("IRE", "12"));
        expected.add(new ExpectedResult("IRE", "17"));
        expected.add(new ExpectedResult("JPN", "14"));
        expected.add(new ExpectedResult("USA", "1"));
        expected.add(new ExpectedResult("USA", "10"));
        expected.add(new ExpectedResult("USA", "15"));
        expected.add(new ExpectedResult("USA", "2"));
        expected.add(new ExpectedResult("USA", "3"));
        expected.add(new ExpectedResult("USA", "4"));
        expected.add(new ExpectedResult("USA", "5"));
        expected.add(new ExpectedResult("USA", "6"));
        expected.add(new ExpectedResult("USA", "7"));
        expected.add(new ExpectedResult("USA", "8"));
        expected.add(new ExpectedResult("USA", "9"));
        try {
            CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            Metamodel mm = this.getEntityManagerFactory().getMetamodel();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            Root customer = cquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            EmbeddableType Country_ = mm.embeddable(Country.class);
            Selection[] selection = new Selection[]{customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)), customer.get(Customer_2.getSingularAttribute("id", String.class))};
            Expression[] expressionArray1 = new Expression[]{customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class))};
            Expression[] expressionArray2 = new Expression[]{customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)), customer.get(Customer_2.getSingularAttribute("id", String.class))};
            cquery.multiselect(selection);
            cquery.groupBy(expressionArray1);
            cquery.groupBy(expressionArray2);
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class))), cbuilder.asc((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class)))});
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (TestUtil.traceflag) {
                for (Tuple actual : result) {
                    logger.log(System.Logger.Level.TRACE, "Actual - code=" + actual.get(0) + ", id=" + actual.get(1));
                }
            }
            int i = 0;
            int passCount1 = 0;
            int passCount2 = 0;
            for (Tuple actual : result) {
                logger.log(System.Logger.Level.TRACE, "verifying: code=" + actual.get(0) + ", id=" + actual.get(1));
                if (!actual.get(0).equals(((ExpectedResult)expected.get(i)).getArg1())) {
                    logger.log(System.Logger.Level.ERROR, "Expected getArg1:" + ((ExpectedResult)expected.get(i)).getArg1() + ", actual.get(0):" + actual.get(0));
                } else {
                    ++passCount1;
                }
                if (!actual.get(1).equals(((ExpectedResult)expected.get(i)).getArg2())) {
                    logger.log(System.Logger.Level.ERROR, "Expected getArg2:" + ((ExpectedResult)expected.get(i)).getArg2() + ", actual.get(1):" + actual.get(1));
                } else {
                    ++passCount2;
                }
                ++i;
            }
            if (passCount1 == expected.size()) {
                pass1 = true;
            }
            if (passCount2 == expected.size()) {
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("groupByExpArrayTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void groupByListTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<ExpectedResult> expected = new ArrayList<ExpectedResult>();
        expected.add(new ExpectedResult("CHA", "13"));
        expected.add(new ExpectedResult("CHA", "18"));
        expected.add(new ExpectedResult("CHA", "19"));
        expected.add(new ExpectedResult("CHA", "20"));
        expected.add(new ExpectedResult("GBR", "11"));
        expected.add(new ExpectedResult("GBR", "16"));
        expected.add(new ExpectedResult("IRE", "12"));
        expected.add(new ExpectedResult("IRE", "17"));
        expected.add(new ExpectedResult("JPN", "14"));
        expected.add(new ExpectedResult("USA", "1"));
        expected.add(new ExpectedResult("USA", "10"));
        expected.add(new ExpectedResult("USA", "15"));
        expected.add(new ExpectedResult("USA", "2"));
        expected.add(new ExpectedResult("USA", "3"));
        expected.add(new ExpectedResult("USA", "4"));
        expected.add(new ExpectedResult("USA", "5"));
        expected.add(new ExpectedResult("USA", "6"));
        expected.add(new ExpectedResult("USA", "7"));
        expected.add(new ExpectedResult("USA", "8"));
        expected.add(new ExpectedResult("USA", "9"));
        try {
            CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            Metamodel mm = this.getEntityManagerFactory().getMetamodel();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            Root customer = cquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            EmbeddableType Country_ = mm.embeddable(Country.class);
            Selection[] selection = new Selection[]{customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)), customer.get(Customer_2.getSingularAttribute("id", String.class))};
            ArrayList<Path> groupByList1 = new ArrayList<Path>();
            groupByList1.add(customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)));
            ArrayList<Path> groupByList2 = new ArrayList<Path>();
            groupByList2.add(customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)));
            groupByList2.add(customer.get(Customer_2.getSingularAttribute("id", String.class)));
            cquery.multiselect(selection);
            cquery.groupBy(groupByList1);
            cquery.groupBy(groupByList2);
            ArrayList<Order> orderList1 = new ArrayList<Order>();
            orderList1.add(cbuilder.asc((Expression)customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class))));
            ArrayList<Order> orderList2 = new ArrayList<Order>();
            orderList2.add(cbuilder.asc((Expression)customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class))));
            orderList2.add(cbuilder.asc((Expression)customer.get(Customer_2.getSingularAttribute("id", String.class))));
            cquery.orderBy(orderList1);
            cquery.orderBy(orderList2);
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            if (TestUtil.traceflag) {
                for (Tuple actual : result) {
                    logger.log(System.Logger.Level.TRACE, "Actual - code=" + actual.get(0) + ", id=" + actual.get(1));
                }
            }
            int i = 0;
            int passCount1 = 0;
            int passCount2 = 0;
            for (Tuple actual : result) {
                logger.log(System.Logger.Level.TRACE, "verifying: code=" + actual.get(0) + ", id=" + actual.get(1));
                if (!actual.get(0).equals(((ExpectedResult)expected.get(i)).getArg1())) {
                    logger.log(System.Logger.Level.ERROR, "Expected getArg1:" + ((ExpectedResult)expected.get(i)).getArg1() + ", actual.get(0):" + actual.get(0));
                } else {
                    ++passCount1;
                }
                if (!actual.get(1).equals(((ExpectedResult)expected.get(i)).getArg2())) {
                    logger.log(System.Logger.Level.ERROR, "Expected getArg2:" + ((ExpectedResult)expected.get(i)).getArg2() + ", actual.get(1):" + actual.get(1));
                } else {
                    ++passCount2;
                }
                ++i;
            }
            if (passCount1 == expected.size()) {
                pass1 = true;
            }
            if (passCount2 == expected.size()) {
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("groupByListTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void having() throws Exception {
        boolean pass = false;
        Long expectedGBR = 2L;
        Long expectedCHA = 4L;
        int expectedRows = 2;
        CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createQuery(Long.class);
            Root customer = cquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            cquery.groupBy(new Expression[]{customer.get(Customer_2.getSingularAttribute("country", Country.class)).get("code")});
            Predicate exp = customer.get(Customer_2.getSingularAttribute("country", Country.class)).get("code").in(new Object[]{"GBR", "CHA"});
            cquery.having((Expression)exp).select((Selection)cbuilder.count((Expression)customer));
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List result = tquery.getResultList();
            int numOfExpected = 0;
            for (Long val : result) {
                if (!val.equals(expectedGBR) && !val.equals(expectedCHA)) continue;
                ++numOfExpected;
            }
            if (numOfExpected == 2) {
                logger.log(System.Logger.Level.TRACE, "Expected results received.");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results.  Expected 2 Values returned : 2 with Country Code GBR and 4 with Country Code CHA. Received: " + result.size());
                for (Long val : result) {
                    logger.log(System.Logger.Level.ERROR, "Count of Codes Returned: " + val);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("having failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void distinct() throws Exception {
        ArrayList<String> expected;
        List actual;
        TypedQuery q;
        EmbeddableType Country_;
        Metamodel mm;
        EntityType Customer_2;
        Root customer;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        logger.log(System.Logger.Level.INFO, "True test");
        CriteriaQuery cquery = cbuilder.createQuery(String.class);
        if (cquery != null) {
            customer = cquery.from(Customer.class);
            Customer_2 = customer.getModel();
            mm = this.getEntityManagerFactory().getMetamodel();
            Country_ = mm.embeddable(Country.class);
            cquery.select((Selection)customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)));
            cquery.distinct(true);
            q = this.getEntityManager().createQuery(cquery);
            actual = q.getResultList();
            Collections.sort(actual);
            expected = new ArrayList<String>();
            expected.add("CHA");
            expected.add("GBR");
            expected.add("IRE");
            expected.add("JPN");
            expected.add("USA");
            Collections.sort(expected);
            if (actual != null) {
                if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                    pass1 = true;
                    if (TestUtil.traceflag) {
                        logger.log(System.Logger.Level.TRACE, "Received expected results(" + actual.size() + "):");
                        for (String s : actual) {
                            logger.log(System.Logger.Level.TRACE, "code:" + s);
                        }
                    }
                } else {
                    logger.log(System.Logger.Level.TRACE, "Expected(" + expected.size() + "):");
                    for (String s : expected) {
                        logger.log(System.Logger.Level.TRACE, "code:" + s);
                    }
                    logger.log(System.Logger.Level.TRACE, "Actual(" + actual.size() + "):");
                    for (String s : actual) {
                        logger.log(System.Logger.Level.TRACE, "code:" + s);
                    }
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getResultList() returned null result");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        logger.log(System.Logger.Level.INFO, "False test");
        cquery = cbuilder.createQuery(String.class);
        if (cquery != null) {
            customer = cquery.from(Customer.class);
            Customer_2 = customer.getModel();
            mm = this.getEntityManagerFactory().getMetamodel();
            Country_ = mm.embeddable(Country.class);
            cquery.select((Selection)customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)));
            cquery.distinct(false);
            q = this.getEntityManager().createQuery(cquery);
            actual = q.getResultList();
            Collections.sort(actual);
            expected = new ArrayList();
            expected.add("CHA");
            expected.add("CHA");
            expected.add("CHA");
            expected.add("CHA");
            expected.add("GBR");
            expected.add("GBR");
            expected.add("IRE");
            expected.add("IRE");
            expected.add("JPN");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            Collections.sort(expected);
            if (actual != null) {
                if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                    pass2 = true;
                    if (TestUtil.traceflag) {
                        logger.log(System.Logger.Level.TRACE, "Received expected results(" + actual.size() + "):");
                        for (String s : expected) {
                            logger.log(System.Logger.Level.TRACE, "code:" + s);
                        }
                    }
                } else {
                    logger.log(System.Logger.Level.TRACE, "Expected(" + expected.size() + "):");
                    for (String s : expected) {
                        logger.log(System.Logger.Level.TRACE, "code:" + s);
                    }
                    logger.log(System.Logger.Level.TRACE, "Actual(" + actual.size() + "):");
                    for (String s : actual) {
                        logger.log(System.Logger.Level.TRACE, "code:" + s);
                    }
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getResultList() returned null result");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        logger.log(System.Logger.Level.INFO, "Default test");
        cquery = cbuilder.createQuery(String.class);
        if (cquery != null) {
            customer = cquery.from(Customer.class);
            Customer_2 = customer.getModel();
            mm = this.getEntityManagerFactory().getMetamodel();
            Country_ = mm.embeddable(Country.class);
            cquery.select((Selection)customer.get(Customer_2.getSingularAttribute("country", Country.class)).get(Country_.getSingularAttribute("code", String.class)));
            q = this.getEntityManager().createQuery(cquery);
            actual = q.getResultList();
            Collections.sort(actual);
            expected = new ArrayList();
            expected.add("CHA");
            expected.add("CHA");
            expected.add("CHA");
            expected.add("CHA");
            expected.add("GBR");
            expected.add("GBR");
            expected.add("IRE");
            expected.add("IRE");
            expected.add("JPN");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            expected.add("USA");
            Collections.sort(expected);
            if (actual != null) {
                if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
                    pass3 = true;
                    if (TestUtil.traceflag) {
                        logger.log(System.Logger.Level.TRACE, "Received expected results(" + actual.size() + "):");
                        for (String s : expected) {
                            logger.log(System.Logger.Level.TRACE, "code:" + s);
                        }
                    }
                } else {
                    logger.log(System.Logger.Level.TRACE, "Expected(" + expected.size() + "):");
                    for (String s : expected) {
                        logger.log(System.Logger.Level.TRACE, "code:" + s);
                    }
                    logger.log(System.Logger.Level.TRACE, "Actual(" + actual.size() + "):");
                    for (String s : actual) {
                        logger.log(System.Logger.Level.TRACE, "code:" + s);
                    }
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getResultList() returned null result");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("distinct test failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void orderBy() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        Object[] expectedZips = new String[]{"00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "11345"};
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find work zip codes that are not null");
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isNotNull((Expression)customer.get("work").get("zip"))).select((Selection)customer.get("work").get("zip"));
            Path exp1 = customer.get("work").get("zip");
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)exp1)});
            List lOrder = cquery.getOrderList();
            if (lOrder.size() == 1) {
                Order o = (Order)lOrder.get(0);
                if (!o.isAscending()) {
                    logger.log(System.Logger.Level.ERROR, "isAscending() did not return an order of ascending");
                } else {
                    pass1 = true;
                }
                if (o.getExpression() != null) {
                    logger.log(System.Logger.Level.TRACE, "getExpression() returned non-null expression");
                    pass2 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "getExpression() returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected a size of 1, actual:" + lOrder.size());
            }
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            Object[] result = clist.toArray(new String[clist.size()]);
            logger.log(System.Logger.Level.TRACE, "Compare results of work zip codes");
            pass3 = Arrays.equals(expectedZips, result);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception queryTest47: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("orderBy failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void orderReverseTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        Object[] expectedZips = new String[]{"11345", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252", "00252"};
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find work zip codes that are not null");
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isNotNull((Expression)customer.get("work").get("zip")));
            cquery.select((Selection)customer.get("work").get("zip"));
            cquery.orderBy(new Order[]{cbuilder.asc((Expression)customer.get("work").get("zip")).reverse()});
            List lOrder = cquery.getOrderList();
            if (lOrder.size() == 1) {
                Order o = (Order)lOrder.get(0);
                if (o.isAscending()) {
                    logger.log(System.Logger.Level.ERROR, "isAscending() did not return an order of descending");
                } else {
                    pass1 = true;
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected a size of 1, actual:" + lOrder.size());
            }
            TypedQuery tquery = this.getEntityManager().createQuery(cquery);
            List clist = tquery.getResultList();
            Object[] result = clist.toArray(new String[clist.size()]);
            logger.log(System.Logger.Level.TRACE, "Compare results of work zip codes");
            pass2 = Arrays.equals(expectedZips, result);
            if (!pass2) {
                logger.log(System.Logger.Level.ERROR, "Results are incorrect:");
                for (Object s : expectedZips) {
                    logger.log(System.Logger.Level.ERROR, "Expected:" + (String)s);
                }
                for (Object s : result) {
                    logger.log(System.Logger.Level.ERROR, "actual:" + (String)s);
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: ", (Throwable)e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("orderReverseTest failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void getOrderList() throws Exception {
        boolean pass = false;
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.TRACE, "find work zip codes that are not null");
            CriteriaQuery cquery = cbuilder.createQuery(String.class);
            Root customer = cquery.from(Customer.class);
            cquery.where((Expression)cbuilder.isNotNull((Expression)customer.get("work").get("zip"))).select((Selection)customer.get("work").get("zip")).orderBy(new Order[]{cbuilder.asc((Expression)customer.get("work").get("zip"))});
            List orderedList = cquery.getOrderList();
            if (orderedList != null) {
                if (orderedList.size() == 1) {
                    pass = true;
                    logger.log(System.Logger.Level.TRACE, "Received expected results");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Received Unexpected results");
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception queryTest47: ", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("getOrderList failed");
        }
    }

    @SetupMethod(name="setupCustomerData")
    @Test
    public void modifiedQueryTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(Integer.valueOf(this.customerRef[3].getId()));
        ArrayList<Integer> actual = new ArrayList<Integer>();
        logger.log(System.Logger.Level.INFO, "Testing initial query");
        CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
        this.getEntityTransaction().begin();
        CriteriaQuery cquery = cbuilder.createQuery();
        if (cquery != null) {
            Root customer = cquery.from(Customer.class);
            EntityType Customer_2 = customer.getModel();
            cquery.select((Selection)customer);
            cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("name", String.class)), (Object)"Robert E. Bissett"));
            TypedQuery q = this.getEntityManager().createQuery(cquery);
            List result = q.getResultList();
            for (Customer c : result) {
                actual.add(Integer.parseInt(c.getId()));
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results for first query. Expected " + expected.size() + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass1 = true;
            }
            logger.log(System.Logger.Level.INFO, "Testing modified query");
            expected.clear();
            expected.add(Integer.valueOf(this.customerRef[7].getId()));
            actual.clear();
            cquery.select((Selection)customer.get("id"));
            cquery.where((Expression)cbuilder.equal((Expression)customer.get(Customer_2.getSingularAttribute("name", String.class)), (Object)"Irene M. Caruso"));
            q = this.getEntityManager().createQuery(cquery);
            List lResult = q.getResultList();
            if (lResult.size() == 1) {
                Object o = lResult.get(0);
                actual.add(Integer.parseInt((String)o));
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected 1 result, actual:" + lResult.size());
            }
            Collections.sort(actual);
            if (!this.checkEntityPK(actual, expected)) {
                logger.log(System.Logger.Level.ERROR, "Did not get expected results for second query. Expected " + expected.size() + " references, got: " + actual.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass2 = true;
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("modifiedQueryTest test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createATestData() {
        try {
            this.getEntityTransaction().begin();
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            A aRef = new A("9", null, 9, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception in createTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }

    private void removeATestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM A_BASIC").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }

    public static class ExpectedResult {
        String arg1 = null;
        String arg2 = null;

        public ExpectedResult(String arg1) {
            this.arg1 = arg1;
        }

        public ExpectedResult(String arg1, String arg2) {
            this.arg1 = arg1;
            this.arg2 = arg2;
        }

        public String getArg1() {
            return this.arg1;
        }

        public void setArg1(String arg1) {
            this.arg1 = arg1;
        }

        public String getArg2() {
            return this.arg2;
        }

        public void setArg2(String arg2) {
            this.arg2 = arg2;
        }
    }
}

